/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.uddi.client.v3.ext.serialization;

import java.io.IOException;
import java.util.Map;
import javax.xml.namespace.QName;
import org.idoox.config.Configurable;
import org.idoox.wasp.serialization.SerializationChain;
import org.idoox.wasp.serialization.SerializationContext;
import org.idoox.wasp.serialization.XMLSerializer;
import org.idoox.xml.TokenWriter;
import org.idoox.xmlrpc.MessageCreatingException;
import org.systinet.uddi.client.serialization.SerializationMappingKey;
import org.systinet.uddi.client.serialization.SerializationMappingValue;
import org.systinet.uddi.client.serialization.Serializer;
import org.systinet.uddi.client.serialization.StringSerializer;
import org.systinet.uddi.client.v3.ext.struct.ContactInfo;
import org.systinet.uddi.client.v3.ext.struct.ExtensionMapping;
import org.systinet.uddi.client.v3.ext.util.Helper;
import org.systinet.uddi.client.v3.serialization.PersonNameSerializer;
import org.systinet.uddi.client.v3.struct.PersonName;
import org.systinet.uddi.client.v3.struct.PersonNameArrayList;
import org.systinet.uddi.client.v3.struct.PersonNameArrayListIterator;
import org.systinet.wasp.webservice.Current;
import org.systinet.wasp.webservice.ServiceClientContext;
import org.systinet.wasp.webservice.ServiceEndpointContext;

public class ContactInfoSerializer
implements XMLSerializer,
Serializer {
    public static final ContactInfoSerializer serializer = new ContactInfoSerializer();

    public static ContactInfoSerializer getInstance() {
        return serializer;
    }

    public void serialize(TokenWriter dataWriter, Object data, SerializationContext context, SerializationChain next) throws MessageCreatingException {
        ServiceClientContext serviceClientContext;
        Map mapping = null;
        ServiceEndpointContext serviceEndpointContext = Current.getServiceEndpointContext();
        if (serviceEndpointContext != null) {
            mapping = (Map)serviceEndpointContext.getContextData().get("serializationMapping");
        }
        if ((serviceClientContext = Current.getServiceClientContext()) != null) {
            mapping = (Map)serviceClientContext.getContextData().get("serializationMapping");
        }
        if (mapping == null) {
            mapping = ExtensionMapping.serializationMapping;
        }
        SerializationMappingValue serializationMappingValue = null;
        serializationMappingValue = (SerializationMappingValue)mapping.get(new SerializationMappingKey(data.getClass().getName(), new QName("http://systinet.com/uddi/api/v3/ext/5.0", "contactInfo")));
        if (serializationMappingValue != null) {
            Serializer serializer = serializationMappingValue.getSerializer();
            String namespaceURI = serializationMappingValue.getElement().getNamespaceURI();
            String localPart = serializationMappingValue.getElement().getLocalPart();
            serializer.serialize(dataWriter, data, namespaceURI, localPart, mapping);
        } else {
            this.serialize(dataWriter, data, "http://systinet.com/uddi/api/v3/ext/5.0", "contactInfo", mapping);
        }
    }

    public void serialize(TokenWriter dataWriter, Object data, String namespace, String localName, Map mapping) throws MessageCreatingException {
        ContactInfo uddiObject = (ContactInfo)data;
        try {
            dataWriter.enter(namespace, localName);
            this.serializeAttribute(dataWriter, uddiObject, namespace, localName, mapping);
            this.serializeBody(dataWriter, uddiObject, namespace, localName, mapping);
            dataWriter.leave();
        }
        catch (IOException e) {
            throw new MessageCreatingException((Throwable)e);
        }
    }

    public void serializeAttribute(TokenWriter dataWriter, ContactInfo uddiObject, String namespace, String localName, Map mapping) throws MessageCreatingException {
        String useType = uddiObject.getUseType();
        if (!Helper.isNull(useType)) {
            StringSerializer.serializeAttribute((TokenWriter)dataWriter, (String)useType, (String)"", (String)"useType");
        }
    }

    public void serializeBody(TokenWriter dataWriter, ContactInfo uddiObject, String namespace, String localName, Map mapping) throws MessageCreatingException, IOException {
        PersonNameArrayList personNameArrayList = uddiObject.getPersonNameArrayList();
        if (!Helper.isNull(personNameArrayList) && personNameArrayList.size() > 0) {
            Serializer serializer = null;
            String namespaceURI = null;
            String localPart = null;
            SerializationMappingValue serializationMappingValue = null;
            PersonNameArrayListIterator iterator = personNameArrayList.personNameArrayListIterator();
            while (iterator.hasNext()) {
                PersonName item = iterator.next();
                serializationMappingValue = (SerializationMappingValue)mapping.get(new SerializationMappingKey(item.getClass().getName(), new QName("urn:uddi-org:api_v3", "personName")));
                if (serializationMappingValue != null) {
                    serializer = serializationMappingValue.getSerializer();
                    namespaceURI = serializationMappingValue.getElement().getNamespaceURI();
                    localPart = serializationMappingValue.getElement().getLocalPart();
                    serializer.serialize(dataWriter, (Object)item, namespaceURI, localPart, mapping);
                    continue;
                }
                PersonNameSerializer.getInstance().serialize(dataWriter, item, "urn:uddi-org:api_v3", "personName", mapping);
            }
        }
    }

    public void grabReferences(Object data, SerializationContext context, SerializationChain next) throws MessageCreatingException {
    }

    public void init(Configurable configurable) {
    }

    public String getMechanismType() {
        return "systinet:xmlser/1.0";
    }
}

