/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.jaxrpc.rpc;

import com.systinet.jaxrpc.rpc.handler.HandlerRegistryImpl;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.Remote;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.Port;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import javax.xml.rpc.Call;
import javax.xml.rpc.Service;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.encoding.TypeMappingRegistry;
import javax.xml.rpc.handler.HandlerRegistry;
import org.idoox.util.RuntimeWrappedException;
import org.systinet.wasp.Version;
import org.systinet.wasp.webservice.LookupException;
import org.systinet.wasp.webservice.ServiceClient;

public class ServiceImpl
implements Service {
    private String wsdlURL;
    private QName serviceName;
    private HandlerRegistry handlerRegistry;
    private Map portNameToServiceClient = new HashMap(1);
    private boolean wsdlParsed = false;
    private QName defaultPortName;
    private Map portNameToOperations = new HashMap(11, 0.75f);
    private String defaultTNS;

    ServiceImpl(String wsdlURL, QName serviceName) {
        this.wsdlURL = wsdlURL;
        this.serviceName = serviceName;
        if (wsdlURL == null) {
            this.wsdlParsed = true;
        }
    }

    public Iterator getPorts() {
        if (!this.wsdlParsed) {
            try {
                this.parseWSDL();
            }
            catch (ServiceException e) {
                throw new RuntimeWrappedException("Exception while parsing parsing wsdl:" + (Object)((Object)e));
            }
        }
        return this.portNameToServiceClient.keySet().iterator();
    }

    public Remote getPort(Class class1) throws ServiceException {
        return this.getPort(null, class1);
    }

    public Remote getPort(QName qname, Class class1) throws ServiceException {
        Remote proxy;
        ServiceClient baseServiceClient;
        if (!this.wsdlParsed) {
            this.parseWSDL();
        }
        if (qname != null) {
            baseServiceClient = this.getServiceClient(qname);
        } else if (this.defaultPortName != null) {
            baseServiceClient = this.getServiceClient(this.defaultPortName);
        } else {
            throw new ServiceException("Service can't be generated. Either not wsdl was supplied or portname was not specified.");
        }
        try {
            proxy = (Remote)baseServiceClient.createProxy(class1);
        }
        catch (LookupException e) {
            throw new ServiceException("Exception while creating service proxy." + e.getMessage());
        }
        return proxy;
    }

    public Call createCall(QName portName) throws ServiceException {
        return this.createCall(portName, (QName)null);
    }

    public Call createCall(QName portName, QName operationName) throws ServiceException {
        ServiceClient baseServiceClient;
        QName usedPortName;
        if (!this.wsdlParsed) {
            this.parseWSDL();
        }
        if ((usedPortName = portName) != null) {
            baseServiceClient = this.getServiceClient(usedPortName);
        } else if (this.defaultPortName != null) {
            usedPortName = this.defaultPortName;
            baseServiceClient = this.getServiceClient(usedPortName);
        } else {
            throw new ServiceException("More than one port exist in wsdl (" + this.wsdlURL + "). Portname to be used must be specified.");
        }
        if (baseServiceClient == null) {
            baseServiceClient = ServiceClient.create();
            baseServiceClient.setWSDLServiceName(this.serviceName);
            baseServiceClient.setWSDLPortName(usedPortName.getLocalPart());
        }
        try {
            if (operationName == null) {
                return baseServiceClient.createCall();
            }
            return baseServiceClient.createCall(operationName.getLocalPart());
        }
        catch (LookupException e) {
            throw new ServiceException("Service client lookup problems during creating call." + e.getMessage(), (Throwable)e);
        }
    }

    public Call createCall(QName portName, String operationName) throws ServiceException {
        return this.createCall(portName, new QName(portName.getNamespaceURI(), operationName));
    }

    public Call createCall() throws ServiceException {
        return this.createCall(null);
    }

    public Call[] getCalls(QName portName) throws ServiceException {
        List opNames = (List)this.portNameToOperations.get(portName.getLocalPart());
        if (opNames == null) {
            throw new ServiceException("Exception while creating calls - no such port" + portName + " exist in " + this.wsdlURL);
        }
        Iterator it = opNames.iterator();
        ArrayList<Call> calls = new ArrayList<Call>();
        while (it.hasNext()) {
            String opName = (String)it.next();
            calls.add(this.createCall(portName, opName));
        }
        return calls.toArray(new Call[0]);
    }

    public QName getServiceName() {
        return this.serviceName;
    }

    public URL getWSDLDocumentLocation() {
        try {
            return new URL(this.wsdlURL);
        }
        catch (MalformedURLException e) {
            throw new RuntimeWrappedException((Throwable)e);
        }
    }

    public TypeMappingRegistry getTypeMappingRegistry() {
        throw new UnsupportedOperationException("Not supported by " + Version.getVersion());
    }

    public HandlerRegistry getHandlerRegistry() {
        if (!this.wsdlParsed) {
            try {
                this.parseWSDL();
            }
            catch (ServiceException e) {
                throw new RuntimeWrappedException("Unable to parse service wsdl", (Throwable)e);
            }
        }
        if (this.handlerRegistry == null) {
            this.handlerRegistry = new HandlerRegistryImpl(this);
        }
        return this.handlerRegistry;
    }

    private void parseWSDL() throws ServiceException {
        try {
            javax.wsdl.Service service;
            WSDLReader reader = WSDLFactory.newInstance().newWSDLReader();
            reader.setFeature("javax.wsdl.verbose", false);
            Definition def = reader.readWSDL(null, this.wsdlURL);
            this.defaultTNS = def.getTargetNamespace();
            QName wsdlServiceName = this.serviceName;
            if ("".equals(wsdlServiceName.getNamespaceURI())) {
                wsdlServiceName = new QName(this.defaultTNS, this.serviceName.getLocalPart());
            }
            if ((service = def.getService(wsdlServiceName)) == null) {
                throw new ServiceException("Exception during parsing wsdl on location " + this.wsdlURL + " - no such service present " + this.serviceName);
            }
            Map portsMap = service.getPorts();
            Iterator ports = portsMap.keySet().iterator();
            int portCounter = 0;
            while (ports.hasNext()) {
                String portName = (String)ports.next();
                Port port = (Port)portsMap.get(portName);
                ServiceClient sc = ServiceClient.create();
                sc.setWSDLServiceName(wsdlServiceName);
                sc.setWSDLPortName(portName);
                sc.setWSDLLocation(this.wsdlURL);
                QName portQName = new QName(service.getQName().getNamespaceURI(), portName);
                this.portNameToServiceClient.put(portQName, sc);
                this.defaultPortName = portCounter++ == 0 ? new QName(wsdlServiceName.getNamespaceURI(), portName) : null;
                Iterator operations = port.getBinding().getBindingOperations().iterator();
                ArrayList<String> opNames = new ArrayList<String>();
                while (operations.hasNext()) {
                    BindingOperation opBinding = (BindingOperation)operations.next();
                    Operation op = opBinding.getOperation();
                    opNames.add(op.getName());
                    this.portNameToOperations.put(portName, opNames);
                }
            }
            this.wsdlParsed = true;
        }
        catch (WSDLException e) {
            throw new ServiceException("Exception while parsing wsdl on location " + this.wsdlURL + " ." + e.getMessage());
        }
    }

    public ServiceClient getServiceClient(QName portName) {
        QName corrPortName = portName;
        if ("".equals(portName.getNamespaceURI())) {
            corrPortName = new QName(this.defaultTNS, portName.getLocalPart());
        }
        return (ServiceClient)this.portNameToServiceClient.get(corrPortName);
    }
}

