/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.uddi.client.util;

import java.io.IOException;
import java.util.Stack;
import org.idoox.xml.TokenWriter;

public class UDDITokenWriter
implements TokenWriter {
    private Stack namespaces = new Stack();
    private TokenWriter tokenWriter = null;

    public UDDITokenWriter(TokenWriter tokenWriter) {
        this.tokenWriter = tokenWriter;
    }

    public void flush() throws IOException {
        this.tokenWriter.flush();
    }

    public void enter(String namespace, String name) throws IOException, IllegalStateException {
        this.tokenWriter.enter(namespace, name);
        if (namespace != null && (this.namespaces.empty() || !namespace.equals(((StackItem)this.namespaces.peek()).namespace))) {
            this.namespaces.push(new StackItem(namespace));
            this.setPrefixForNamespace("", namespace);
        } else {
            this.namespaces.push(new StackItem(namespace));
        }
    }

    public void writeAttribute(String namespace, String name, String value) throws IOException, IllegalStateException {
        if (!"http://www.w3.org/2001/XMLSchema-instance".equals(namespace)) {
            this.tokenWriter.writeAttribute(namespace, name, value);
        }
    }

    public void writeXmlAttribute(String name, String value) throws IOException, IllegalStateException {
        this.tokenWriter.writeXmlAttribute(name, value);
    }

    public void writeContent(String content) throws IOException, IllegalStateException {
        this.tokenWriter.writeContent(content);
    }

    public void leave() throws IOException, IllegalStateException {
        this.namespaces.pop();
        this.tokenWriter.leave();
    }

    public String getPrefixForNamespace(String namespace) throws IOException, IllegalStateException {
        if ("http://www.w3.org/2001/XMLSchema".equals(namespace)) {
            return "";
        }
        return this.tokenWriter.getPrefixForNamespace(namespace);
    }

    public void setPrefixForNamespace(String prefix, String namespace) throws IOException, IllegalStateException {
        StackItem stackItem = (StackItem)this.namespaces.peek();
        if (!stackItem.isSetPrefixForNamespace || "http://www.w3.org/2000/09/xmldsig#".equals(namespace)) {
            stackItem.isSetPrefixForNamespace = true;
            String ns = stackItem.namespace;
            if (namespace.equals(ns) && !"http://www.w3.org/2000/09/xmldsig#".equals(namespace) || "http://www.w3.org/2000/09/xmldsig#".equals(namespace) && !"".equals(prefix)) {
                this.tokenWriter.setPrefixForNamespace(prefix, namespace);
            }
        }
    }

    private class StackItem {
        String namespace;
        boolean isSetPrefixForNamespace = false;

        public StackItem(String namespace) {
            this.namespace = namespace;
        }
    }
}

