/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.uddi.client.serialization;

import com.idoox.wasp.serialization.DeserializationException;
import com.idoox.wasp.serialization.SerializationHelper;
import java.io.IOException;
import org.idoox.xml.Attribute;
import org.idoox.xml.Token;
import org.idoox.xml.Tokenizer;
import org.idoox.xml.TokenizerException;
import org.idoox.xmlrpc.MessageProcessingException;

public class DoubleDeserializer {
    public static double deserialize(Tokenizer dataTokenizer, Token token) throws MessageProcessingException {
        try {
            dataTokenizer.readToken(token);
            if (token.getAttributeCount() > 0) {
                String attributes = "";
                int i = 0;
                while (i < token.getAttributeCount()) {
                    Attribute attribute = token.getAttribute(i);
                    if (!"http://www.w3.org/2001/XMLSchema-instance".equals(attribute.uri)) {
                        attributes = attributes.length() != 0 ? attributes + ", " + attribute.toString() : attributes + attribute.toString();
                    }
                    ++i;
                }
                if (attributes.length() != 0) {
                    throw new MessageProcessingException("Unexpected input attribute(s) " + attributes + " in " + token.toString());
                }
            }
            byte tok = dataTokenizer.next();
            double content = 0.0;
            if (tok == 4) {
                content = DoubleDeserializer.deserialize(dataTokenizer.readContent());
                tok = SerializationHelper.nextNonWhitespace((Tokenizer)dataTokenizer);
            }
            if (tok != 3) {
                throw new MessageProcessingException("Unexpected input element {" + dataTokenizer.getNamespace() + "}" + dataTokenizer.getLocalName());
            }
            return content;
        }
        catch (IOException e) {
            throw new MessageProcessingException((Throwable)e);
        }
        catch (TokenizerException e) {
            throw new MessageProcessingException((Throwable)e);
        }
        catch (Exception e) {
            throw new MessageProcessingException((Throwable)e);
        }
    }

    public static double deserialize(String s) throws DeserializationException {
        if (s.equals("INF")) {
            return new Double(Double.POSITIVE_INFINITY);
        }
        if (s.equals("-INF")) {
            return new Double(Double.NEGATIVE_INFINITY);
        }
        if (s.equals("NaN")) {
            return new Double(Double.NaN);
        }
        try {
            return Double.valueOf(s);
        }
        catch (NumberFormatException e) {
            throw new DeserializationException("Unexpected double value : " + s, (Throwable)e);
        }
    }
}

