/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.uddi.client.serialization;

import com.idoox.wasp.serialization.DeserializationException;
import com.idoox.wasp.serialization.SerializationHelper;
import java.io.IOException;
import org.idoox.xml.Attribute;
import org.idoox.xml.Token;
import org.idoox.xml.Tokenizer;
import org.idoox.xml.TokenizerException;
import org.idoox.xmlrpc.MessageProcessingException;

public class BooleanDeserializer {
    public static boolean deserialize(Tokenizer dataTokenizer, Token token) throws MessageProcessingException {
        try {
            dataTokenizer.readToken(token);
            if (token.getAttributeCount() > 0) {
                String attributes = "";
                int i = 0;
                while (i < token.getAttributeCount()) {
                    Attribute attribute = token.getAttribute(i);
                    if (!"http://www.w3.org/2001/XMLSchema-instance".equals(attribute.uri)) {
                        attributes = attributes.length() != 0 ? attributes + ", " + attribute.toString() : attributes + attribute.toString();
                    }
                    ++i;
                }
                if (attributes.length() != 0) {
                    throw new MessageProcessingException("Unexpected input attribute(s) " + attributes + " in " + token.toString());
                }
            }
            byte tok = dataTokenizer.next();
            boolean content = false;
            if (tok == 4) {
                content = BooleanDeserializer.deserialize(dataTokenizer.readContent());
                tok = SerializationHelper.nextNonWhitespace((Tokenizer)dataTokenizer);
            }
            if (tok != 3) {
                throw new MessageProcessingException("Unexpected input element {" + dataTokenizer.getNamespace() + "}" + dataTokenizer.getLocalName());
            }
            return content;
        }
        catch (IOException e) {
            throw new MessageProcessingException((Throwable)e);
        }
        catch (TokenizerException e) {
            throw new MessageProcessingException((Throwable)e);
        }
        catch (Exception e) {
            throw new MessageProcessingException((Throwable)e);
        }
    }

    public static boolean deserialize(String s) throws DeserializationException {
        if ("true".equals(s) || "1".equals(s)) {
            return true;
        }
        if ("false".equals(s) || "0".equals(s)) {
            return false;
        }
        throw new DeserializationException("Unexpected boolean value : " + s);
    }
}

