/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.uddi.client.base;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.systinet.uddi.InvalidParameterException;
import org.systinet.uddi.client.base.DOMHelper;
import org.systinet.uddi.client.base.ElementArrayListIterator;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ElementArrayList
implements Serializable,
Cloneable {
    protected List list;

    public ElementArrayList() {
        this.list = new ArrayList();
    }

    public ElementArrayList(Element[] elementArrayList) {
        this.list = new ArrayList();
        this.fromArray(elementArrayList);
    }

    public ElementArrayList(Element element) {
        this.list = new ArrayList();
        this.add(element);
    }

    private ElementArrayList(List list) {
        this.list = list;
    }

    public void check() throws InvalidParameterException {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ElementArrayList)) {
            return false;
        }
        ElementArrayList elementArrayList = (ElementArrayList)o;
        return !(this.list != null ? !this.compareLists(this.list, elementArrayList.list) : elementArrayList.list != null);
    }

    private boolean compareLists(List first, List second) {
        if (second == null) {
            return false;
        }
        if (first.size() != second.size()) {
            return false;
        }
        int i = 0;
        while (i < first.size()) {
            Node node1 = (Node)first.get(i);
            Node node2 = (Node)second.get(i);
            if (node1 != null && node2 == null || node1 == null && node2 != null) {
                return false;
            }
            if (!DOMHelper.isEqual(node1, node2)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        return this.list != null ? this.list.hashCode() : 0;
    }

    public int size() {
        return this.list.size();
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public boolean contains(Element element) {
        return this.list.contains(element);
    }

    public Iterator iterator() {
        return this.list.iterator();
    }

    public Element[] toArray() {
        return this.list.toArray(new Element[this.list.size()]);
    }

    public void fromArray(Element[] elementArrayList) {
        if (elementArrayList == null) {
            return;
        }
        this.list.clear();
        int i = 0;
        while (i < elementArrayList.length) {
            this.add(elementArrayList[i]);
            ++i;
        }
    }

    public boolean add(Element element) {
        if (element == null) {
            throw new NullPointerException("This list does not support null elements.");
        }
        return this.list.add(element);
    }

    public boolean remove(Element element) {
        if (element == null) {
            throw new NullPointerException("This list does not support null elements.");
        }
        return this.list.remove(element);
    }

    public List toList() {
        return Collections.unmodifiableList(this.list);
    }

    public boolean containsAll(ElementArrayList elementArrayList) {
        return this.list.containsAll(elementArrayList.toList());
    }

    public boolean addAll(ElementArrayList elementArrayList) {
        return this.list.addAll(elementArrayList.toList());
    }

    public boolean addAll(int index, ElementArrayList elementArrayList) {
        return this.list.addAll(index, elementArrayList.toList());
    }

    public boolean removeAll(ElementArrayList elementArrayList) {
        return this.list.removeAll(elementArrayList.toList());
    }

    public boolean retainAll(ElementArrayList elementArrayList) {
        return this.list.retainAll(elementArrayList.toList());
    }

    public void clear() {
        this.list.clear();
    }

    public Element get(int index) {
        return (Element)this.list.get(index);
    }

    public Element set(int index, Element element) {
        return this.list.set(index, element);
    }

    public void add(int index, Element element) {
        this.list.add(index, element);
    }

    public Element remove(int index) {
        return (Element)this.list.remove(index);
    }

    public int indexOf(Element element) {
        return this.list.indexOf(element);
    }

    public int lastIndexOf(Element element) {
        return this.list.lastIndexOf(element);
    }

    public ElementArrayListIterator elementArrayListIterator() {
        return new ElementArrayListIterator(this.list.listIterator());
    }

    public ElementArrayListIterator elementArrayListIterator(int index) {
        return new ElementArrayListIterator(this.list.listIterator(index));
    }

    public ElementArrayList subList(int fromIndex, int toIndex) {
        return new ElementArrayList(this.list.subList(fromIndex, toIndex));
    }

    public boolean normalize() {
        boolean result = true;
        Iterator iterator = this.list.iterator();
        while (iterator.hasNext()) {
            Element item = (Element)iterator.next();
            if (item != null) {
                result = false;
                continue;
            }
            this.list.remove(null);
        }
        return result;
    }

    public Object clone() throws CloneNotSupportedException {
        ElementArrayList theClone = (ElementArrayList)super.clone();
        theClone.list = new ArrayList();
        Iterator iterator = this.list.iterator();
        while (iterator.hasNext()) {
            Element item = (Element)iterator.next();
            if (item == null) continue;
            theClone.list.add(item.cloneNode(true));
        }
        return theClone;
    }
}

