/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.uddi.client.base;

import org.systinet.uddi.client.util.StringHelper;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMHelper {
    public static boolean isEqual(Node node1, Node node2) {
        if (node1 != null && node2 == null || node1 == null && node2 != null) {
            return false;
        }
        if (node1 == null && node2 == null) {
            return true;
        }
        if (node1.getNodeType() != node2.getNodeType()) {
            return false;
        }
        if (1 == node1.getNodeType()) {
            if (!DOMHelper.isEqualRootNode(node1, node2)) {
                return false;
            }
            if (!DOMHelper.isEqualAttributes(node1.getAttributes(), node2.getAttributes())) {
                return false;
            }
            if (!DOMHelper.isEqualSubelements(node1.getChildNodes(), node2.getChildNodes())) {
                return false;
            }
        } else if (3 == node1.getNodeType()) {
            return DOMHelper.isEqualTextNodes(node1, node2);
        }
        return true;
    }

    private static boolean isEqualSubelements(NodeList nodeList1, NodeList nodeList2) {
        if (nodeList1 == null && nodeList2 == null) {
            return true;
        }
        if (nodeList1 != null && nodeList2 == null || nodeList1 == null && nodeList2 != null) {
            return false;
        }
        return DOMHelper.isSubset(nodeList1, nodeList2) && DOMHelper.isSubset(nodeList2, nodeList1);
    }

    private static boolean isSubset(NodeList subset, NodeList set) {
        int i = 0;
        while (i < subset.getLength()) {
            short type;
            Node node = subset.item(i);
            if (node != null && (1 == (type = node.getNodeType()) ? !DOMHelper.elementIsContained(node, set) : 3 == type && !DOMHelper.textNodeIsContained(node, set))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean textNodeIsContained(Node node, NodeList nodeList) {
        int i = 0;
        while (i < nodeList.getLength()) {
            Node nd = nodeList.item(i);
            if (3 == nd.getNodeType() && DOMHelper.isEqual(nd, node)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean elementIsContained(Node node, NodeList nodeList) {
        int i = 0;
        while (i < nodeList.getLength()) {
            Node nd = nodeList.item(i);
            if (1 == nd.getNodeType() && DOMHelper.isEqual(nd, node)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean isEqualAttributes(NamedNodeMap attributes1, NamedNodeMap attributes2) {
        if (attributes1 == null && attributes2 == null) {
            return true;
        }
        if (attributes1 != null && attributes2 == null || attributes1 == null && attributes2 != null) {
            return false;
        }
        int attributesCount = attributes1.getLength();
        if (attributesCount != attributes2.getLength()) {
            return false;
        }
        int i = 0;
        while (i < attributesCount) {
            String attrValue;
            Attr attr = (Attr)attributes1.item(i);
            String attrName = attr.getNodeName();
            if (!DOMHelper.attrIsContained(attrName, attrValue = attr.getValue(), attributes2, attributesCount)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean attrIsContained(String attributeName, String attributeValue, NamedNodeMap attributes, int attributesCount) {
        int i = 0;
        while (i < attributesCount) {
            Attr attr = (Attr)attributes.item(i);
            String attrName = attr.getNodeName();
            String attrValue = attr.getValue();
            if (DOMHelper.isEqualStringValue(attributeName, attrName) && DOMHelper.isEqualStringValue(attributeValue, attrValue)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean isEqualRootNode(Node node1, Node node2) {
        return DOMHelper.isEqualStringValue(node1.getLocalName(), node2.getLocalName()) && DOMHelper.isEqualStringValue(node1.getNamespaceURI(), node2.getNamespaceURI());
    }

    private static boolean isEqualStringValue(String value1, String value2) {
        if (value1 == null && value2 == null) {
            return true;
        }
        if (value1 != null && value2 == null || value1 == null && value2 != null) {
            return false;
        }
        return value1.equals(value2);
    }

    private static boolean isEqualTextNodes(Node node1, Node node2) {
        String text1 = node1.getNodeValue();
        String text2 = node2.getNodeValue();
        if (text1 == null && text2 == null) {
            return true;
        }
        if (text1 != null && text2 == null || text1 == null && text2 != null) {
            return false;
        }
        return StringHelper.whitespaceCollapse(text1).equals(StringHelper.whitespaceCollapse(text2));
    }
}

