/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.uddi.client;

import org.systinet.uddi.client.UDDIResourceBundle;

public class UDDIErrorCodes {
    public static final int E_ASSERTION_NOT_FOUND = 30000;
    public static final int E_AUTH_TOKEN_EXPIRED = 10110;
    public static final int E_AUTH_TOKEN_REQUIRED = 10120;
    public static final int E_ACCOUNT_LIMIT_EXCEEDED = 10160;
    public static final int E_BUSY = 10400;
    public static final int E_CATEGORIZATION_NOT_ALLOWED = 20100;
    public static final int E_FATAL_ERROR = 10500;
    public static final int E_INVALID_KEY_PASSED = 10210;
    public static final int E_INVALID_PROJECTION = 20230;
    public static final int E_INVALID_CATEGORY = 20000;
    public static final int E_INVALID_COMPLETION_STATUS = 30100;
    public static final int E_INVALID_URL_PASSED = 10220;
    public static final int E_INVALID_VALUE = 20200;
    public static final int E_KEY_RETIRED = 10310;
    public static final int E_LANGUAGE_ERROR = 10060;
    public static final int E_MESSAGE_TOO_LARGE = 30110;
    public static final int E_NAME_TOO_LONG = 10020;
    public static final int E_OPERATOR_MISMATCH = 10130;
    public static final int E_PUBLISHER_CANCELLED = 30220;
    public static final int E_REQUEST_DENIED = 30210;
    public static final int E_REQUEST_TIMEOUT = 20240;
    public static final int E_SECRET_UNKNOWN = 30230;
    public static final int E_SUCCESS = 0;
    public static final int E_TOKEN_ALREADY_EXISTS = 40070;
    public static final int E_TOO_MANY_OPTIONS = 10030;
    public static final int E_TRANSFER_ABORTED = 30200;
    public static final int E_UNRECOGNIZED_VERSION = 10040;
    public static final int E_UNKNOWN_USER = 10150;
    public static final int E_UNSUPPORTED = 10050;
    public static final int E_UNVALIDATABLE = 20220;
    public static final int E_USER_MISMATCH = 10140;
    public static final int E_VALUE_NOT_ALLOWED = 20210;
    public static final int E_INVALID_PARAMETER = 10501;
    public static final int E_HISTORY_DATA_NOT_AVAILABLE = 40010;
    public static final int E_INVALID_COMBINATION = 40500;
    public static final int E_KEY_UNAVAILABLE = 40100;
    public static final int E_NO_VALUES_AVAILABLE = 40200;
    public static final int E_RESULT_SET_TOO_LARGE = 40300;
    public static final int E_TRANSFER_NOT_ALLOWED = 40600;
    public static final int E_UNACCEPTABLE_SIGNATURE = 40400;
    public static final int E_INTERCEPTOR_ERROR = 40004;

    public static String getCode(int errno) {
        String code = null;
        switch (errno) {
            case 30000: {
                code = "E_assertionNotFound";
                break;
            }
            case 10110: {
                code = "E_authTokenExpired";
                break;
            }
            case 10120: {
                code = "E_authTokenRequired";
                break;
            }
            case 10160: {
                code = "E_accountLimitExceeded";
                break;
            }
            case 10400: {
                code = "E_busy";
                break;
            }
            case 20100: {
                code = "E_categorizationNotAllowed";
                break;
            }
            case 10500: {
                code = "E_fatalError";
                break;
            }
            case 10210: {
                code = "E_invalidKeyPassed";
                break;
            }
            case 20230: {
                code = "E_invalidProjection";
                break;
            }
            case 20000: {
                code = "E_invalidCategory";
                break;
            }
            case 30100: {
                code = "E_invalidCompletionStatus";
                break;
            }
            case 10220: {
                code = "E_invalidURLPassed";
                break;
            }
            case 20200: {
                code = "E_invalidValue";
                break;
            }
            case 10310: {
                code = "E_keyRetired";
                break;
            }
            case 10060: {
                code = "E_languageError";
                break;
            }
            case 30110: {
                code = "E_messageTooLarge";
                break;
            }
            case 10020: {
                code = "E_nameTooLong";
                break;
            }
            case 10130: {
                code = "E_operatorMismatch";
                break;
            }
            case 30220: {
                code = "E_publisherCancelled";
                break;
            }
            case 30210: {
                code = "E_requestDenied";
                break;
            }
            case 20240: {
                code = "E_requestTimeout";
                break;
            }
            case 30230: {
                code = "E_secretUnknown";
                break;
            }
            case 0: {
                code = "E_success";
                break;
            }
            case 40070: {
                code = "E_tokenAlreadyExists";
                break;
            }
            case 10030: {
                code = "E_tooManyOptions";
                break;
            }
            case 30200: {
                code = "E_transferAborted";
                break;
            }
            case 10040: {
                code = "E_unrecognizedVersion";
                break;
            }
            case 10150: {
                code = "E_unknownUser";
                break;
            }
            case 20220: {
                code = "E_unvalidatable";
                break;
            }
            case 10050: {
                code = "E_unsupported";
                break;
            }
            case 10140: {
                code = "E_userMismatch";
                break;
            }
            case 20210: {
                code = "E_valueNotAllowed";
                break;
            }
            case 10501: {
                code = "E_invalidParameter";
                break;
            }
            case 40010: {
                code = "E_historyDataNotAvailable";
                break;
            }
            case 40500: {
                code = "E_invalidCombination";
                break;
            }
            case 40100: {
                code = "E_keyUnvailable";
                break;
            }
            case 40200: {
                code = "E_noValuesAvailable";
                break;
            }
            case 40300: {
                code = "E_resultSetTooLarge";
                break;
            }
            case 40600: {
                code = "E_transferNotAllowed";
                break;
            }
            case 40400: {
                code = "E_unacceptableSignature";
                break;
            }
            case 40004: {
                code = "E_interceptorError";
            }
        }
        return code;
    }

    public static String getMessage(int errorCode) {
        String desc = null;
        switch (errorCode) {
            case 30000: {
                desc = UDDIResourceBundle.getString("EXC_AssertionNotFound");
                break;
            }
            case 10110: {
                desc = UDDIResourceBundle.getString("EXC_AuthTokenExpired");
                break;
            }
            case 10120: {
                desc = UDDIResourceBundle.getString("EXC_AuthTokenRequired");
                break;
            }
            case 10160: {
                desc = UDDIResourceBundle.getString("EXC_AccountLimitExceeded");
                break;
            }
            case 10400: {
                desc = UDDIResourceBundle.getString("EXC_Busy");
                break;
            }
            case 20100: {
                desc = UDDIResourceBundle.getString("EXC_CategorizationNotAllowed");
                break;
            }
            case 10500: {
                desc = UDDIResourceBundle.getString("EXC_FatalError");
                break;
            }
            case 10210: {
                desc = UDDIResourceBundle.getString("EXC_InvalidKeyPassed");
                break;
            }
            case 20230: {
                desc = UDDIResourceBundle.getString("EXC_InvalidProjection");
                break;
            }
            case 20000: {
                desc = UDDIResourceBundle.getString("EXC_InvalidCategory");
                break;
            }
            case 30100: {
                desc = UDDIResourceBundle.getString("EXC_InvalidCompletionStatus");
                break;
            }
            case 10220: {
                desc = UDDIResourceBundle.getString("EXC_InvalidUrlPassed");
                break;
            }
            case 20200: {
                desc = UDDIResourceBundle.getString("EXC_InvalidValue");
                break;
            }
            case 10310: {
                desc = UDDIResourceBundle.getString("EXC_KeyRetired");
                break;
            }
            case 10060: {
                desc = UDDIResourceBundle.getString("EXC_LanguageError");
                break;
            }
            case 30110: {
                desc = UDDIResourceBundle.getString("EXC_MessageTooLarge");
                break;
            }
            case 10020: {
                desc = UDDIResourceBundle.getString("EXC_NameTooLong");
                break;
            }
            case 10130: {
                desc = UDDIResourceBundle.getString("EXC_OperatorMismatch");
                break;
            }
            case 30220: {
                desc = UDDIResourceBundle.getString("EXC_PublisherCancelled");
                break;
            }
            case 30210: {
                desc = UDDIResourceBundle.getString("EXC_RequestDenied");
                break;
            }
            case 20240: {
                desc = UDDIResourceBundle.getString("EXC_RequestTimeout");
                break;
            }
            case 30230: {
                desc = UDDIResourceBundle.getString("EXC_SecretUnknown");
                break;
            }
            case 0: {
                desc = UDDIResourceBundle.getString("EXC_Success");
                break;
            }
            case 40070: {
                desc = UDDIResourceBundle.getString("EXC_tokenAlreadyExists");
                break;
            }
            case 10030: {
                desc = UDDIResourceBundle.getString("EXC_TooManyOptions");
                break;
            }
            case 30200: {
                desc = UDDIResourceBundle.getString("EXC_TransferAborted");
                break;
            }
            case 10040: {
                desc = UDDIResourceBundle.getString("EXC_UnrecognizedVersion");
                break;
            }
            case 10150: {
                desc = UDDIResourceBundle.getString("EXC_UnknownUser");
                break;
            }
            case 10050: {
                desc = UDDIResourceBundle.getString("EXC_Unsupported");
                break;
            }
            case 20220: {
                desc = UDDIResourceBundle.getString("EXC_Unvalidatable");
                break;
            }
            case 10140: {
                desc = UDDIResourceBundle.getString("EXC_UserMismatch");
                break;
            }
            case 20210: {
                desc = UDDIResourceBundle.getString("EXC_ValueNotAllowed");
                break;
            }
            case 10501: {
                desc = UDDIResourceBundle.getString("EXC_InvalidParameter");
                break;
            }
            case 40010: {
                desc = UDDIResourceBundle.getString("EXC_HistoryDataNotAvailable");
                break;
            }
            case 40500: {
                desc = UDDIResourceBundle.getString("EXC_InvalidCombination");
                break;
            }
            case 40100: {
                desc = UDDIResourceBundle.getString("EXC_KeyUnvailable");
                break;
            }
            case 40200: {
                desc = UDDIResourceBundle.getString("EXC_NoValuesAvailable");
                break;
            }
            case 40300: {
                desc = UDDIResourceBundle.getString("EXC_ResultSetTooLarge");
                break;
            }
            case 40600: {
                desc = UDDIResourceBundle.getString("EXC_TransferNotAllowed");
                break;
            }
            case 40400: {
                desc = UDDIResourceBundle.getString("EXC_UnacceptableSignature");
                break;
            }
            case 40004: {
                desc = UDDIResourceBundle.getString("EXC_InterceptorError");
            }
        }
        return desc;
    }
}

