/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.uddi.client;

import com.idoox.wasp.serialization.SerializationHelper;
import com.systinet.jaxm.messaging.ProviderConnectionImpl;
import com.systinet.wasp.soap.util.SAAJUtils;
import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.Detail;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.idoox.wasp.types.MessageAttachment;
import org.idoox.wasp.types.ResponseMessageAttachment;
import org.idoox.xml.ElementFinalizingTokenizerWrapper;
import org.idoox.xml.TokenWriter;
import org.idoox.xml.Tokenizer;
import org.idoox.xml.TokenizerException;
import org.systinet.uddi.client.UDDIException;
import org.systinet.uddi.client.base.UDDIObject;
import org.systinet.wasp.messaging.WaspProviderConnection;
import org.systinet.wasp.soap.FirstElementSkippingTokenizer;
import org.systinet.wasp.soap.SOAPElementContent;
import org.systinet.wasp.soap.WaspInternalSOAPMessage;
import org.systinet.wasp.soap.util.LazyFillingTokenizer;
import org.systinet.wasp.webservice.ServiceClient;

public abstract class UDDIClientProxy
implements InvocationHandler {
    private MessageFactory messageFactory;
    private WaspProviderConnection providerConnection = new ProviderConnectionImpl();
    private ServiceClient serviceClient;
    protected Map deserializationMapping;
    protected Map serializationMapping;
    static /* synthetic */ Class class$org$idoox$wasp$types$MessageAttachment;
    static /* synthetic */ Class class$org$idoox$wasp$types$RequestMessageAttachment;
    static /* synthetic */ Class class$org$idoox$wasp$types$ResponseMessageAttachment;
    static /* synthetic */ Class class$org$idoox$xml$Tokenizer;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$org$idoox$wasp$RequestMessageAttachment;

    protected UDDIClientProxy(ServiceClient serviceClient) throws SOAPException {
        this.messageFactory = this.providerConnection.createMessageFactory("soap11");
        this.serviceClient = serviceClient;
    }

    protected UDDIClientProxy(String serviceUrl) throws SOAPException {
        this.messageFactory = this.providerConnection.createMessageFactory("soap11");
        this.serviceClient = ServiceClient.create();
        this.serviceClient.setServiceURL(serviceUrl);
    }

    public ServiceClient getServiceClient() {
        return this.serviceClient;
    }

    protected static Object getClassInstance(String className, String methodName) throws UDDIException {
        try {
            return Class.forName(className).getMethod(methodName, null).invoke(null, null);
        }
        catch (ClassCastException e) {
            throw new UDDIException(10500, e);
        }
        catch (ClassNotFoundException e) {
            throw new UDDIException(10500, e);
        }
        catch (IllegalAccessException e) {
            throw new UDDIException(10500, e);
        }
        catch (NoSuchMethodException e) {
            throw new UDDIException(10500, e);
        }
        catch (InvocationTargetException e) {
            throw new UDDIException(10500, e);
        }
    }

    protected void parseFault(SOAPFault fault) throws Exception {
        if (fault == null) {
            throw new RuntimeException("Unable to deserialize fault - NO FAULT");
        }
        Detail detail = fault.getDetail();
        if (detail != null) {
            SOAPElementContent elementContent = (SOAPElementContent)detail;
            Tokenizer tokenizer = elementContent.getContent();
            SerializationHelper.nextNonWhitespace((Tokenizer)tokenizer);
            Iterator childElements = detail.getChildElements();
            SOAPElement firstChild = null;
            while (childElements.hasNext()) {
                Object o = childElements.next();
                if (!(o instanceof SOAPElement)) continue;
                firstChild = (SOAPElement)o;
            }
            if (firstChild == null) {
                return;
            }
            this.parseFaultBody(tokenizer, firstChild, fault);
        }
        SOAPElement faultCode = SAAJUtils.getFaultCodeElement((SOAPFault)fault);
        throw new SOAPFaultException(SAAJUtils.stringToQName((SOAPElement)faultCode, (String)fault.getFaultCode()), fault.getFaultString(), fault.getFaultActor(), fault.getDetail());
    }

    protected abstract void parseFaultBody(Tokenizer var1, SOAPElement var2, SOAPFault var3) throws Exception;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        SOAPMessage responseMessage;
        SOAPMessage requestMessage;
        boolean responseAttachment;
        Object result;
        block14: {
            Object object;
            block18: {
                ResponseMessageAttachment responseMessageAttachment;
                block17: {
                    Object var19_19;
                    block15: {
                        block16: {
                            result = null;
                            responseAttachment = false;
                            int attachmentIndex = -1;
                            int i = 0;
                            while (true) {
                                if (i >= args.length) {
                                    if (args.length > 2) throw new UDDIException("Invalid parameters !!!");
                                    if (attachmentIndex != -1 || args.length <= 1) break;
                                    throw new UDDIException("Invalid parameters !!!");
                                }
                                if ((class$org$idoox$wasp$types$MessageAttachment == null ? UDDIClientProxy.class$("org.idoox.wasp.types.MessageAttachment") : class$org$idoox$wasp$types$MessageAttachment).isAssignableFrom(args[i].getClass()) || (class$org$idoox$wasp$types$RequestMessageAttachment == null ? UDDIClientProxy.class$("org.idoox.wasp.types.RequestMessageAttachment") : class$org$idoox$wasp$types$RequestMessageAttachment).isAssignableFrom(args[i].getClass())) {
                                    attachmentIndex = i;
                                }
                                ++i;
                            }
                            requestMessage = null;
                            responseMessage = null;
                            try {
                                requestMessage = this.messageFactory.createMessage();
                                ((WaspInternalSOAPMessage)requestMessage).setEnvelopePrefix("");
                                SOAPPart soapPart = requestMessage.getSOAPPart();
                                SOAPEnvelope envelope = soapPart.getEnvelope();
                                SOAPBody body = envelope.getBody();
                                String attachmentId = null;
                                if (attachmentIndex != -1) {
                                    AttachmentPart attachmentPart = this.createAttachmentPart((MessageAttachment)args[attachmentIndex], requestMessage);
                                    requestMessage.addAttachmentPart(attachmentPart);
                                    attachmentId = attachmentPart.getContentId();
                                }
                                LazyFillingTokenizer writerReader = new LazyFillingTokenizer((LazyFillingTokenizer.Filler)new MyFiller((UDDIObject)args[0], attachmentId));
                                ((WaspInternalSOAPMessage)requestMessage).setLazyFillingTokenizer(writerReader);
                                FirstElementSkippingTokenizer bodyTokenizer = new FirstElementSkippingTokenizer((Tokenizer)writerReader);
                                ElementFinalizingTokenizerWrapper bodyTokenizerWithEnd = new ElementFinalizingTokenizerWrapper((Tokenizer)new ElementFinalizingTokenizerWrapper((Tokenizer)bodyTokenizer, (SOAPElement)body), (SOAPElement)envelope);
                                ((SOAPElementContent)body).setContent((Tokenizer)bodyTokenizerWithEnd);
                                ((WaspInternalSOAPMessage)requestMessage).startProcessing();
                                responseMessage = this.providerConnection.call(requestMessage, this.serviceClient);
                                body = responseMessage.getSOAPPart().getEnvelope().getBody();
                                Tokenizer tokenizer = null;
                                SOAPElementContent elementContent = null;
                                if (body.hasFault()) {
                                    this.parseFault(body.getFault());
                                    break block14;
                                }
                                elementContent = (SOAPElementContent)body;
                                tokenizer = elementContent.getContent();
                                tokenizer.next();
                                if (attachmentIndex != -1 && (class$org$idoox$wasp$types$ResponseMessageAttachment == null ? (class$org$idoox$wasp$types$ResponseMessageAttachment = UDDIClientProxy.class$("org.idoox.wasp.types.ResponseMessageAttachment")) : class$org$idoox$wasp$types$ResponseMessageAttachment).isAssignableFrom(args[attachmentIndex].getClass())) {
                                    responseAttachment = true;
                                    this.readAttachments((MessageAttachment)args[attachmentIndex], responseMessage);
                                }
                                if (method.getReturnType().equals(Void.TYPE)) {
                                    var19_19 = null;
                                    Object var23_20 = null;
                                    if (requestMessage == null) break block15;
                                    break block16;
                                }
                                if ((class$org$idoox$wasp$types$ResponseMessageAttachment == null ? (class$org$idoox$wasp$types$ResponseMessageAttachment = UDDIClientProxy.class$("org.idoox.wasp.types.ResponseMessageAttachment")) : class$org$idoox$wasp$types$ResponseMessageAttachment).isAssignableFrom(method.getReturnType())) {
                                    ResponseMessageAttachment attachment = (ResponseMessageAttachment)method.getReturnType().newInstance();
                                    responseAttachment = true;
                                    this.readAttachments((MessageAttachment)attachment, responseMessage);
                                    responseMessageAttachment = attachment;
                                    break block17;
                                }
                                object = method.getReturnType().getMethod("fromXML", class$org$idoox$xml$Tokenizer == null ? (class$org$idoox$xml$Tokenizer = UDDIClientProxy.class$("org.idoox.xml.Tokenizer")) : class$org$idoox$xml$Tokenizer, class$java$util$Map == null ? (class$java$util$Map = UDDIClientProxy.class$("java.util.Map")) : class$java$util$Map).invoke(null, tokenizer, this.deserializationMapping);
                                break block18;
                            }
                            catch (Throwable throwable) {
                                Object var23_24 = null;
                                if (requestMessage != null) {
                                    ((WaspInternalSOAPMessage)requestMessage).release();
                                }
                                if (responseMessage == null) throw throwable;
                                if (responseAttachment) throw throwable;
                                ((WaspInternalSOAPMessage)responseMessage).release();
                                throw throwable;
                            }
                        }
                        ((WaspInternalSOAPMessage)requestMessage).release();
                    }
                    if (responseMessage == null) return var19_19;
                    if (responseAttachment) return var19_19;
                    ((WaspInternalSOAPMessage)responseMessage).release();
                    return var19_19;
                }
                Object var23_21 = null;
                if (requestMessage != null) {
                    ((WaspInternalSOAPMessage)requestMessage).release();
                }
                if (responseMessage == null) return responseMessageAttachment;
                if (responseAttachment) return responseMessageAttachment;
                ((WaspInternalSOAPMessage)responseMessage).release();
                return responseMessageAttachment;
            }
            Object var23_22 = null;
            if (requestMessage != null) {
                ((WaspInternalSOAPMessage)requestMessage).release();
            }
            if (responseMessage == null) return object;
            if (responseAttachment) return object;
            ((WaspInternalSOAPMessage)responseMessage).release();
            return object;
        }
        Object var23_23 = null;
        if (requestMessage != null) {
            ((WaspInternalSOAPMessage)requestMessage).release();
        }
        if (responseMessage == null) return result;
        if (responseAttachment) return result;
        ((WaspInternalSOAPMessage)responseMessage).release();
        return result;
    }

    protected AttachmentPart createAttachmentPart(MessageAttachment att, SOAPMessage message) throws IOException {
        InputStream is;
        String contentType = att.getContentType();
        if (contentType == null) {
            contentType = "application/binary";
        }
        if ((is = att.getData()) == null) {
            if ((class$org$idoox$wasp$RequestMessageAttachment == null ? (class$org$idoox$wasp$RequestMessageAttachment = UDDIClientProxy.class$("org.idoox.wasp.RequestMessageAttachment")) : class$org$idoox$wasp$RequestMessageAttachment).isAssignableFrom(att.getClass()) || (class$org$idoox$wasp$types$RequestMessageAttachment == null ? (class$org$idoox$wasp$types$RequestMessageAttachment = UDDIClientProxy.class$("org.idoox.wasp.types.RequestMessageAttachment")) : class$org$idoox$wasp$types$RequestMessageAttachment).isAssignableFrom(att.getClass())) {
                throw new IOException("RequestMessageAttachment must have seted data.");
            }
            is = new ByteArrayInputStream(new byte[0]);
        }
        AttachmentPart attachment = message.createAttachmentPart((Object)is, contentType);
        String aux = att.getContentId();
        if (aux != null) {
            attachment.setContentId(aux);
        }
        if ((aux = att.getContentLocation()) != null) {
            attachment.setContentLocation(aux);
        }
        return attachment;
    }

    protected MessageAttachment readAttachments(MessageAttachment messageAttachment, SOAPMessage msg) throws SOAPException, IOException {
        AttachmentPart attachmentPart = (AttachmentPart)msg.getAttachments().next();
        Object input = attachmentPart.getContent();
        InputStream is = null;
        is = input instanceof InputStream ? (InputStream)input : attachmentPart.getDataHandler().getInputStream();
        is = new ClosingStream(is, msg);
        messageAttachment.setData(is);
        return messageAttachment;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class ClosingStream
    extends FilterInputStream {
        SOAPMessage soapMessage;

        public ClosingStream(InputStream in, SOAPMessage soapMessage) {
            super(in);
            this.soapMessage = soapMessage;
        }

        public void close() throws IOException {
            if (this.soapMessage != null) {
                ((WaspInternalSOAPMessage)this.soapMessage).release();
            }
        }
    }

    class MyFiller
    implements LazyFillingTokenizer.Filler {
        UDDIObject uddiObject;
        String attachmentId;

        public MyFiller(UDDIObject uddiObject, String attachmentId) {
            this.uddiObject = uddiObject;
            this.attachmentId = attachmentId;
        }

        public void fillTokenWriter(TokenWriter writer) throws IOException, TokenizerException {
            this.uddiObject.toXML(writer, UDDIClientProxy.this.serializationMapping);
            if (this.attachmentId != null) {
                writer.enter("http://systinet.com/uddi/attachment/5.0", "attachment");
                writer.writeAttribute("", "href", "cid:" + this.attachmentId);
                writer.leave();
            }
        }
    }
}

