/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.security.policy;

import java.lang.reflect.Constructor;
import java.security.AccessControlException;
import java.security.Permission;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import org.idoox.security.Config;
import org.idoox.security.server.Current;
import org.idoox.security.server.ReceivedCredentials;

public abstract class WASPAccessController {
    public static final String WASP_AC_IMPL = "wasp.ac.impl";
    public static final String WASP_POLICY_INSTANCE = "wasp.ac.policy.instance";
    private static WASPAccessController SINGLETON = null;
    private static final Class[] DEF_CONSTR_PARMS = new Class[]{class$java$util$Map == null ? (class$java$util$Map = WASPAccessController.class$("java.util.Map")) : class$java$util$Map};
    static /* synthetic */ Class class$java$util$Map;

    public static final WASPAccessController getInstance() {
        if (SINGLETON == null) {
            HashMap<String, String> map = new HashMap<String, String>(11);
            map.put(WASP_AC_IMPL, "org.systinet.security.policy.JAASAccessController");
            WASPAccessController.initSingleton(map);
        }
        return SINGLETON;
    }

    public static final void setSingleton(WASPAccessController controller) throws SecurityException {
        if (SINGLETON != null) {
            throw new SecurityException("Singleton of WASPAccessController is already initialized!");
        }
        SINGLETON = controller;
    }

    public static final void initSingleton(Map configurationParameters) throws SecurityException {
        if (SINGLETON != null) {
            throw new SecurityException("Singleton of WASPAccessController is already initialized!");
        }
        try {
            String implClass = (String)configurationParameters.get(WASP_AC_IMPL);
            if (implClass == null) {
                throw new Exception("Unable to get implementation class out of wasp.ac.impl init parameter.");
            }
            Class<?> impl = Class.forName(implClass, true, Config.getImplClassLoader());
            Constructor<?> constr = impl.getConstructor(DEF_CONSTR_PARMS);
            Object obj = constr.newInstance(configurationParameters);
            SINGLETON = (WASPAccessController)obj;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SecurityException(e.getClass().getName() + ", " + e.getMessage());
        }
    }

    protected WASPAccessController(Map configurationParameters) {
    }

    public abstract void checkPermission(Subject var1, Permission var2) throws AccessControlException;

    public static final void checkPermission(Permission perm) throws AccessControlException {
        WASPAccessController wac = WASPAccessController.getInstance();
        Current cur = Current.getInstance();
        Subject subj = null;
        ReceivedCredentials creds = cur.getReceivedCredentials();
        if (creds != null) {
            subj = creds.getSubject();
        }
        wac.checkPermission(subj, perm);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

