/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.security.policy;

import java.lang.reflect.Constructor;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Principal;
import java.util.Iterator;
import java.util.Map;
import javax.security.auth.AuthPermission;
import javax.security.auth.Policy;
import javax.security.auth.Subject;
import org.idoox.security.Config;
import org.idoox.security.server.Current;
import org.idoox.security.server.ReceivedCredentials;
import org.idoox.security.util.RuntimeWrappedException;
import org.systinet.security.policy.PrincipalEntries;
import org.systinet.security.policy.WASPAccessController;

public abstract class UpdateablePolicy
extends Policy {
    public static final String WASP_POLICY_IMPL = "wasp.policy.impl";
    public static final String WASP_POLICY_CHECKER = "wasp.policy.checker";
    private static final Class[] DEF_CONSTR_PARMS = new Class[]{class$java$util$Map == null ? (class$java$util$Map = UpdateablePolicy.class$("java.util.Map")) : class$java$util$Map};
    private static final Permission CAN_GET_POLICY = new AuthPermission("getPolicy");
    private static final Permission CAN_SET_POLICY = new AuthPermission("setPolicy");
    private static UpdateablePolicy CURRENT_POLICY = null;
    private static final int NO_CHECKER = 0;
    private static final int JAVA_CHECKER = 1;
    private static final int WASP_CHECKER = 2;
    private static int checkerType = 0;
    static /* synthetic */ Class class$java$util$Map;

    public UpdateablePolicy(Map map) {
    }

    public static UpdateablePolicy getUpdateablePolicy() {
        if (checkerType == 1) {
            AccessController.checkPermission(CAN_GET_POLICY);
        } else if (checkerType == 2) {
            Current current = Current.getInstance();
            ReceivedCredentials creds = current.getReceivedCredentials();
            WASPAccessController contr = WASPAccessController.getInstance();
            if (creds != null) {
                contr.checkPermission(creds.getSubject(), CAN_GET_POLICY);
            } else {
                contr.checkPermission(null, CAN_GET_POLICY);
            }
        }
        if (CURRENT_POLICY == null) {
            try {
                if (System.getProperty(WASP_POLICY_CHECKER) != null) {
                    UpdateablePolicy.initSingleton(System.getProperties());
                }
            }
            catch (Exception e) {
                throw new RuntimeWrappedException("Unable to initialize Updateable Policy!", (Throwable)e);
            }
        }
        return CURRENT_POLICY;
    }

    public static final UpdateablePolicy initSingleton(Map configurationParameters) throws SecurityException {
        if (CURRENT_POLICY != null) {
            throw new SecurityException("Singleton of WASPAccessController is already initialized!");
        }
        Object checkerStr = configurationParameters.get(WASP_POLICY_CHECKER);
        if (checkerStr != null) {
            if (checkerStr.equals("java")) {
                checkerType = 1;
            } else if (checkerStr.equals("wasp")) {
                checkerType = 2;
            }
        }
        try {
            String implClass = (String)configurationParameters.get(WASP_POLICY_IMPL);
            if (implClass == null) {
                throw new Exception("Unable to get updateatable policy implementation class out of wasp.policy.impl init parameter.");
            }
            Class<?> impl = Class.forName(implClass, true, Config.getImplClassLoader());
            Constructor<?> constr = impl.getConstructor(DEF_CONSTR_PARMS);
            Object obj = constr.newInstance(configurationParameters);
            CURRENT_POLICY = (UpdateablePolicy)((Object)obj);
            return CURRENT_POLICY;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SecurityException("Unable to instantiate updateable policy,\n Root cause:" + e.getClass().getName() + ", " + e.getMessage());
        }
    }

    public static void setUpdateablePolicy(UpdateablePolicy policy) {
        AccessController.checkPermission(CAN_SET_POLICY);
        CURRENT_POLICY = policy;
    }

    public abstract boolean isUpdatable();

    public abstract boolean isRoleManager();

    public abstract void refresh();

    public abstract PermissionCollection getPermissions(Subject var1, CodeSource var2);

    public abstract void addPermissions(CodeSource var1, Principal var2, PermissionCollection var3) throws AccessControlException;

    public abstract boolean addPermission(CodeSource var1, Principal var2, Permission var3) throws AccessControlException;

    public abstract boolean removePermission(CodeSource var1, Principal var2, Permission var3) throws AccessControlException;

    public abstract PermissionCollection getPrincipalPermissions(CodeSource var1, Principal var2) throws AccessControlException;

    public abstract PermissionCollection getPrincipalPermissions(CodeSource var1, Principal var2, boolean var3) throws AccessControlException;

    public abstract PrincipalEntries getPrincipalEntries() throws AccessControlException;

    public abstract PrincipalEntries getPrincipalEntries(Permission var1) throws AccessControlException;

    public abstract Iterator getRoleNames();

    public abstract boolean addPermissionToRole(String var1, Permission var2) throws AccessControlException;

    public boolean createRole(String roleName) throws AccessControlException {
        return this.addPermissionToRole(roleName, null);
    }

    public abstract boolean removePermissionFromRole(String var1, Permission var2) throws AccessControlException;

    public boolean deleteRole(String roleName) throws AccessControlException {
        return this.removePermissionFromRole(roleName, null);
    }

    public abstract PermissionCollection getRolePermissions(String var1) throws AccessControlException;

    public void destroy() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

