/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.security.perm;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.Vector;
import org.systinet.security.perm.WSInvokePermission;

final class WSInvokePermissionCollection
extends PermissionCollection {
    private Vector permissions = new Vector();
    private boolean isAll;

    public void add(Permission permission) {
        if (!(permission instanceof WSInvokePermission)) {
            throw new IllegalArgumentException("invalid permission: " + permission);
        }
        if (this.isReadOnly()) {
            throw new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
        }
        if (permission.getName() == null || permission.getName().equals("*")) {
            this.isAll = true;
        }
        this.permissions.addElement(permission);
    }

    public boolean implies(Permission permission) {
        if (!(permission instanceof WSInvokePermission)) {
            return false;
        }
        WSInvokePermission that = (WSInvokePermission)permission;
        if (this.isAll) {
            return true;
        }
        String thatName = that.getName();
        if (thatName.equals("*")) {
            return false;
        }
        int thatHash = that.hashCode();
        if (that.getMethods() == null) {
            Enumeration perms = this.permissions.elements();
            while (perms.hasMoreElements()) {
                WSInvokePermission wip;
                Object o = perms.nextElement();
                if (o.hashCode() != thatHash || !thatName.equals((wip = (WSInvokePermission)o).getName()) || wip.getMethods() != null) continue;
                return true;
            }
            return false;
        }
        Enumeration perms = this.permissions.elements();
        String[] thatMethods = that.getMethods();
        int toMatch = thatMethods.length;
        boolean[] matched = new boolean[toMatch];
        while (perms.hasMoreElements()) {
            WSInvokePermission wip;
            Object o = perms.nextElement();
            if (o.hashCode() == thatHash && thatName.equals((wip = (WSInvokePermission)o).getName())) {
                if (wip.getMethods() == null) {
                    return true;
                }
                int curPermIndex = 0;
                String[] curPermMethods = wip.getMethods();
                int thatIndex = 0;
                while (curPermIndex < curPermMethods.length && thatIndex < thatMethods.length) {
                    int compRes = curPermMethods[curPermIndex].compareTo(thatMethods[thatIndex]);
                    if (compRes == 0) {
                        if (matched[thatIndex]) continue;
                        matched[thatIndex] = true;
                        ++thatIndex;
                        ++curPermIndex;
                        --toMatch;
                        continue;
                    }
                    if (compRes < 0) {
                        ++curPermIndex;
                        continue;
                    }
                    ++thatIndex;
                }
            }
            if (toMatch != 0) continue;
            return true;
        }
        return false;
    }

    public Enumeration elements() {
        return this.permissions.elements();
    }
}

