/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.security.perm;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.Hashtable;
import org.systinet.security.perm.ACLPermission;

final class ACLPermissionCollection
extends PermissionCollection {
    private Hashtable permissions = new Hashtable();
    private int effective = 0;

    public void add(Permission permission) {
        if (!(permission instanceof ACLPermission)) {
            throw new IllegalArgumentException("invalid permission: " + permission);
        }
        if (this.isReadOnly()) {
            throw new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
        }
        ACLPermission pp = (ACLPermission)permission;
        ACLPermission existing = (ACLPermission)this.permissions.get(pp.getName());
        int newMask = pp.getMask();
        if (existing != null) {
            int oldMask = existing.getMask();
            int effective = oldMask | newMask;
            if (effective != oldMask) {
                this.permissions.put(pp.getName(), new ACLPermission(pp.getName(), effective & 3));
            }
        } else {
            this.permissions.put(pp.getName(), permission);
        }
        this.effective |= newMask;
    }

    public boolean implies(Permission permission) {
        if (!(permission instanceof ACLPermission)) {
            return false;
        }
        ACLPermission pp = (ACLPermission)permission;
        int desired = pp.getMask();
        return (this.effective & desired) == desired;
    }

    public Enumeration elements() {
        return this.permissions.elements();
    }
}

