/*
 * Decompiled with CFR 0.152.
 */
package org.idoox.security.pstore;

import java.lang.reflect.Constructor;
import org.idoox.security.Config;
import org.idoox.security.pstore.BadPasswordException;
import org.idoox.security.pstore.KeyStore;
import org.idoox.security.pstore.KeyStoreSource;
import org.idoox.security.pstore.PropertySerializer;
import org.idoox.security.pstore.UserStore;
import org.idoox.security.pstore.UserStoreSource;
import org.idoox.security.util.RuntimeWrappedException;

public abstract class PStore {
    private static PStore pstore;
    private static String[] _keys;
    private static PropertySerializer[] _serials;
    static /* synthetic */ Class class$org$idoox$security$pstore$PStore;
    static /* synthetic */ Class class$java$lang$String;

    protected PStore(String password) throws BadPasswordException {
    }

    public static synchronized PStore getInstance(String password) throws BadPasswordException {
        if (pstore == null) {
            Class clazz = class$org$idoox$security$pstore$PStore == null ? (class$org$idoox$security$pstore$PStore = PStore.class$("org.idoox.security.pstore.PStore")) : class$org$idoox$security$pstore$PStore;
            synchronized (clazz) {
                if (pstore != null) {
                    PStore pStore = pstore;
                    return pStore;
                }
                try {
                    String pstoreClassName = Config.getProperty("pstore.provider", "com.idoox.security.pstore.PStoreImpl");
                    Class<?> pstoreClass = Class.forName(pstoreClassName, true, Config.getImplClassLoader());
                    Constructor<?> constructor = pstoreClass.getConstructor(class$java$lang$String == null ? (class$java$lang$String = PStore.class$("java.lang.String")) : class$java$lang$String);
                    pstore = (PStore)constructor.newInstance(password);
                }
                catch (Exception e) {
                    if (e instanceof BadPasswordException) {
                        throw (BadPasswordException)((Object)e);
                    }
                    throw new RuntimeWrappedException("Cannot create default protected store provider", (Throwable)e);
                }
            }
        }
        return pstore;
    }

    public abstract KeyStore getKeyStore();

    public abstract UserStore getUserStore();

    protected static KeyStoreSource getKeyStoreSource() throws Exception {
        String sourceClassName = Config.getProperty("pstore.source", null);
        KeyStoreSource keySource = null;
        if (sourceClassName != null) {
            Class<?> sourceClass = Class.forName(sourceClassName, true, Config.getImplClassLoader());
            keySource = (KeyStoreSource)sourceClass.newInstance();
        } else {
            String keySourceClassName = Config.getProperty("pstore.keysource", null);
            Class<?> keySourceClass = Class.forName(keySourceClassName, true, Config.getImplClassLoader());
            keySource = (KeyStoreSource)keySourceClass.newInstance();
        }
        return keySource;
    }

    protected static UserStoreSource getUserStoreSource() throws Exception {
        String sourceClassName = Config.getProperty("pstore.source", null);
        UserStoreSource userSource = null;
        if (sourceClassName != null) {
            Class<?> sourceClass = Class.forName(sourceClassName, true, Config.getImplClassLoader());
            userSource = (UserStoreSource)sourceClass.newInstance();
        } else {
            String userSourceClassName = Config.getProperty("pstore.usersource", null);
            Class<?> userSourceClass = Class.forName(userSourceClassName, true, Config.getImplClassLoader());
            userSource = (UserStoreSource)userSourceClass.newInstance();
        }
        return userSource;
    }

    protected static UserStore getUserStore(String password) throws Exception {
        String sourceClassName = Config.getProperty("userstore.impl", null);
        UserStore userStore = null;
        if (sourceClassName != null) {
            Class<?> storeClass = Class.forName(sourceClassName, true, Config.getImplClassLoader());
            Constructor<?> constructor = storeClass.getConstructor(class$java$lang$String == null ? (class$java$lang$String = PStore.class$("java.lang.String")) : class$java$lang$String);
            userStore = (UserStore)constructor.newInstance(password);
        }
        return userStore;
    }

    protected static KeyStore getKeyStore(String password) throws Exception {
        String sourceClassName = Config.getProperty("keystore.impl", null);
        KeyStore keyStore = null;
        if (sourceClassName != null) {
            Class<?> storeClass = Class.forName(sourceClassName, true, Config.getImplClassLoader());
            Constructor<?> constructor = storeClass.getConstructor(class$java$lang$String == null ? (class$java$lang$String = PStore.class$("java.lang.String")) : class$java$lang$String);
            keyStore = (KeyStore)constructor.newInstance(password);
        }
        return keyStore;
    }

    protected static void registerAdditionalPropertySerializers(UserStore userStore) {
        if (_keys != null) {
            int i = 0;
            while (i < _keys.length) {
                if (userStore.getPropertySerializer(_keys[i]) == null) {
                    userStore.setPropertySerializer(_keys[i], _serials[i]);
                }
                ++i;
            }
        }
    }

    public static synchronized void setAdditionalPropertySerializers(String[] keys, PropertySerializer[] serializers) {
        if (pstore != null) {
            int validCnt = 0;
            if (keys != null && serializers != null) {
                int i = 0;
                while (i < serializers.length && i < keys.length) {
                    if (serializers[i] != null && keys[i] != null) {
                        ++validCnt;
                    }
                    ++i;
                }
                _keys = new String[validCnt];
                _serials = new PropertySerializer[validCnt];
                int i2 = 0;
                while (i2 < serializers.length && i2 < keys.length) {
                    if (serializers[i2] != null && keys[i2] != null) {
                        PStore._serials[i2] = serializers[i2];
                        PStore._keys[i2] = keys[i2];
                    }
                    ++i2;
                }
            } else {
                _keys = null;
                _serials = null;
            }
        } else {
            throw new SecurityException("Unable to set additional property serializers, the getInstance method has been already invoked!");
        }
    }

    public void destroy() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        _keys = null;
        _serials = null;
    }
}

