/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.uddi.security.jaas;

import com.idoox.debug.Category;
import com.systinet.uddi.security.struct.Group;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.idoox.security.WASPPrincipal;
import org.idoox.security.jaas.SmLoginParamsCredential;
import org.idoox.util.RuntimeWrappedException;
import org.systinet.uddi.security.jaas.GroupsCallback;

public class SmLoginModule
implements LoginModule {
    private static Category log = Category.getCategory("com.systinet.uddi.security.jaas.SmLoginModule");
    private CallbackHandler callbackHandler;
    private boolean succeeded = false;
    private Subject subject = null;
    private WASPPrincipal principal = null;
    private boolean commitSucceeded = false;
    private SmLoginParamsCredential cred = null;
    private Set groupPrincipals = new HashSet();
    private static Object accountApi = null;
    private static Method accountSaveAccountMethod = null;
    private static Object defaultAccount = null;
    private static Object accountCoreApi = null;
    private static Method accountCoreGetUserAccountMethod = null;
    private static Method userAccountCloneMethod = null;
    private static Method userAccountSetFullNameMethod = null;
    private static Method userAccountSetLoginNameMethod = null;
    private static Constructor saveUserAccountConstructor = null;
    static /* synthetic */ Class class$java$lang$String;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        try {
            if (accountApi == null || accountSaveAccountMethod == null || userAccountCloneMethod == null) {
                Class<?> accountApiClass = Class.forName("com.systinet.uddi.account.AccountApiImplCore", true, Thread.currentThread().getContextClassLoader());
                accountApi = accountApiClass.getMethod("getApiInstance", new Class[0]).invoke(null, new Object[0]);
                accountSaveAccountMethod = accountApiClass.getMethod("save_userAccount", Class.forName("org.systinet.uddi.account.struct.Save_userAccount", true, Thread.currentThread().getContextClassLoader()));
                Class<?> userAccountClass = Class.forName("org.systinet.uddi.account.struct.UserAccount", true, Thread.currentThread().getContextClassLoader());
                userAccountCloneMethod = userAccountClass.getMethod("clone", new Class[0]);
                userAccountSetFullNameMethod = userAccountClass.getMethod("setFullName", class$java$lang$String == null ? (class$java$lang$String = SmLoginModule.class$("java.lang.String")) : class$java$lang$String);
                userAccountSetLoginNameMethod = userAccountClass.getMethod("setLoginName", class$java$lang$String == null ? (class$java$lang$String = SmLoginModule.class$("java.lang.String")) : class$java$lang$String);
                Class<?> accountCoreClass = Class.forName("com.systinet.uddi.account.AccountCoreApiImpl", true, Thread.currentThread().getContextClassLoader());
                accountCoreApi = accountCoreClass.getMethod("getApiInstance", new Class[0]).invoke(null, new Object[0]);
                accountCoreGetUserAccountMethod = accountCoreClass.getMethod("getUserAccount", class$java$lang$String == null ? (class$java$lang$String = SmLoginModule.class$("java.lang.String")) : class$java$lang$String);
                Class<?> saveUserAccountClass = Class.forName("org.systinet.uddi.account.struct.Save_userAccount", true, Thread.currentThread().getContextClassLoader());
                saveUserAccountConstructor = saveUserAccountClass.getConstructor(userAccountClass);
            }
        }
        catch (Exception e) {
            log.error("Initialization failed", e);
            new RuntimeWrappedException("Initialization failed", (Throwable)e);
        }
    }

    public boolean login() throws LoginException {
        String loginName = null;
        String[] groups = null;
        Callback[] callbacks = new Callback[]{new NameCallback("Enter name"), new GroupsCallback()};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (IOException e) {
            log.error("", e);
            throw new LoginException(e.getMessage());
        }
        catch (UnsupportedCallbackException e) {
            log.error("", e);
            throw new LoginException(e.getMessage());
        }
        loginName = ((NameCallback)callbacks[0]).getName();
        groups = ((GroupsCallback)callbacks[1]).getGroups();
        if (loginName != null) {
            try {
                if (defaultAccount == null) {
                    Class<?> accountConfigurationClass = Class.forName("com.systinet.uddi.account.config.AccountConfiguration", true, Thread.currentThread().getContextClassLoader());
                    Field field = accountConfigurationClass.getField("DEFAULT_ACCOUNT");
                    defaultAccount = field.get(null);
                }
                try {
                    accountCoreGetUserAccountMethod.invoke(accountCoreApi, loginName);
                }
                catch (InvocationTargetException e) {
                    Object account = userAccountCloneMethod.invoke(defaultAccount, new Object[0]);
                    userAccountSetFullNameMethod.invoke(account, loginName);
                    userAccountSetLoginNameMethod.invoke(account, loginName);
                    Object saveUserAccount = saveUserAccountConstructor.newInstance(account);
                    accountSaveAccountMethod.invoke(accountApi, saveUserAccount);
                }
            }
            catch (InvocationTargetException e) {
                throw new LoginException(e.getTargetException().getMessage());
            }
            catch (Exception e) {
                throw new FailedLoginException(e.getMessage());
            }
        } else {
            throw new LoginException("Unable to get siteminder parameters, login fails");
        }
        this.principal = new WASPPrincipal(loginName);
        int i = 0;
        while (i < groups.length) {
            Group groupPrincipal = null;
            try {
                groupPrincipal = new Group(groups[i], "", "", Boolean.FALSE, Boolean.TRUE);
            }
            catch (Exception e) {
                throw new LoginException("Invalid login parameters, login fails (" + e.getMessage() + ")");
            }
            this.groupPrincipals.add(groupPrincipal);
            ++i;
        }
        this.succeeded = true;
        return this.succeeded;
    }

    public boolean commit() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        Set<Principal> principals = this.subject.getPrincipals();
        if (!principals.contains(this.principal)) {
            principals.add((Principal)this.principal);
        }
        principals.addAll(this.groupPrincipals);
        Set<Object> creds = this.subject.getPublicCredentials();
        if (!creds.contains(this.cred)) {
            creds.add(this.cred);
        }
        this.commitSucceeded = true;
        return true;
    }

    public boolean abort() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        if (this.commitSucceeded) {
            this.logout();
        } else {
            this.succeeded = false;
            this.principal = null;
            this.cred = null;
            this.groupPrincipals = null;
        }
        return true;
    }

    public boolean logout() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        if (this.commitSucceeded) {
            Set<Object> creds;
            Set<Principal> principals = this.subject.getPrincipals();
            if (principals.contains(this.principal)) {
                principals.remove(this.principal);
            }
            if ((creds = this.subject.getPublicCredentials()).contains(this.cred)) {
                creds.remove(this.cred);
            }
        }
        this.commitSucceeded = false;
        this.succeeded = false;
        this.principal = null;
        this.groupPrincipals = null;
        this.cred = null;
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

