/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.uddi.security.jaas;

import com.idoox.debug.Category;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.idoox.security.WASPPrincipal;
import org.idoox.security.jaas.NamePasswordCredential;
import org.idoox.util.RuntimeWrappedException;
import org.systinet.uddi.security.SecurityException;
import org.systinet.uddi.security.jaas.AuthTokenCredential;
import org.systinet.uddi.security.token.TokenFactory;

public class NamePasswordLoginModule
implements LoginModule {
    private static Category log = Category.getCategory("security.com.systinet.uddi.security.jaas.NamePasswordLoginModule");
    private CallbackHandler handler;
    private Subject subject;
    private boolean succeeded;
    private boolean commitSucceeded;
    private NamePasswordCredential namePasswordCred = null;
    private AuthTokenCredential authTokenCred = null;
    private static Object accountCoreApi = null;
    private static Method accountCoreLoginMethod = null;
    private static TokenFactory tokenFactory = null;
    private WASPPrincipal principal;
    static /* synthetic */ Class class$java$lang$String;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.handler = callbackHandler;
        this.subject = subject;
        try {
            if (accountCoreApi == null || accountCoreLoginMethod == null) {
                Class<?> accountCoreClass = Class.forName("com.systinet.uddi.account.AccountCoreApiImpl", true, Thread.currentThread().getContextClassLoader());
                accountCoreApi = accountCoreClass.getMethod("getApiInstance", new Class[0]).invoke(null, new Object[0]);
                accountCoreLoginMethod = accountCoreClass.getMethod("login", class$java$lang$String == null ? (class$java$lang$String = NamePasswordLoginModule.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = NamePasswordLoginModule.class$("java.lang.String")) : class$java$lang$String);
            }
            if (tokenFactory == null) {
                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass("com.systinet.uddi.security.token.TokenFactory");
                tokenFactory = (TokenFactory)clazz.newInstance();
            }
        }
        catch (Exception e) {
            log.error("Initialization failed", e);
            new RuntimeWrappedException("Initialization failed", (Throwable)e);
        }
    }

    public boolean login() throws LoginException {
        this.succeeded = false;
        String name = null;
        String password = null;
        try {
            Callback[] callbacks = new Callback[]{new NameCallback("Enter name"), new PasswordCallback("Enter password", false)};
            this.handler.handle(callbacks);
            name = ((NameCallback)callbacks[0]).getName();
            password = new String(((PasswordCallback)callbacks[1]).getPassword());
            try {
                accountCoreLoginMethod.invoke(accountCoreApi, name, password);
            }
            catch (InvocationTargetException e) {
                throw new LoginException(e.getTargetException().getMessage());
            }
            catch (Exception e) {
                throw new FailedLoginException(e.getMessage());
            }
        }
        catch (IOException e) {
            throw new FailedLoginException("Cannot get information from the callback handler");
        }
        catch (UnsupportedCallbackException e) {
            throw new FailedLoginException("Configured callback handler does not handle required callback type");
        }
        this.principal = new WASPPrincipal(name);
        this.namePasswordCred = new NamePasswordCredential(name, new String(password));
        try {
            this.authTokenCred = new AuthTokenCredential(tokenFactory.generateAuthToken(name));
        }
        catch (SecurityException e) {
            throw new FailedLoginException(e.getMessage());
        }
        this.succeeded = true;
        return this.succeeded;
    }

    public boolean commit() throws LoginException {
        Set<Object> creds;
        if (!this.succeeded) {
            return false;
        }
        Set<Principal> principals = this.subject.getPrincipals();
        if (!principals.contains(this.principal)) {
            principals.add((Principal)this.principal);
        }
        if (!(creds = this.subject.getPrivateCredentials()).contains(this.namePasswordCred)) {
            creds.add(this.namePasswordCred);
        }
        if (!creds.contains(this.authTokenCred)) {
            creds.add(this.authTokenCred);
        }
        this.commitSucceeded = true;
        return true;
    }

    public boolean abort() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        if (this.commitSucceeded) {
            this.logout();
        } else {
            this.succeeded = false;
            this.principal = null;
            this.namePasswordCred = null;
            this.authTokenCred = null;
        }
        return true;
    }

    public boolean logout() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        if (this.commitSucceeded) {
            Set<Object> creds;
            Set<Principal> principals = this.subject.getPrincipals();
            if (principals.contains(this.principal)) {
                principals.remove(this.principal);
            }
            if ((creds = this.subject.getPrivateCredentials()).contains(this.namePasswordCred)) {
                creds.remove(this.namePasswordCred);
            }
            if (creds.contains(this.authTokenCred)) {
                creds.remove(this.authTokenCred);
            }
        }
        this.commitSucceeded = false;
        this.succeeded = false;
        this.principal = null;
        this.namePasswordCred = null;
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

