/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.uddi.security.jaas;

import com.idoox.debug.Category;
import java.io.IOException;
import java.security.Principal;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.CredentialExpiredException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.idoox.security.WASPPrincipal;
import org.idoox.util.RuntimeWrappedException;
import org.systinet.uddi.security.SecurityException;
import org.systinet.uddi.security.jaas.AuthTokenCallback;
import org.systinet.uddi.security.token.TokenFactory;

public class AuthTokenLoginModule
implements LoginModule {
    private static Category log = Category.getCategory("security.com.systinet.uddi.security.jaas.AuthTokenLoginModule");
    private CallbackHandler handler;
    private Subject subject;
    private boolean succeeded;
    private boolean commitSucceeded;
    private static TokenFactory tokenFactory = null;
    private WASPPrincipal principal;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.handler = callbackHandler;
        this.subject = subject;
        try {
            if (tokenFactory == null) {
                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass("com.systinet.uddi.security.token.TokenFactory");
                tokenFactory = (TokenFactory)clazz.newInstance();
            }
        }
        catch (Exception e) {
            log.error("Initialization failed", e);
            new RuntimeWrappedException("Initialization failed", (Throwable)e);
        }
    }

    public boolean login() throws LoginException {
        this.succeeded = false;
        String loginName = null;
        try {
            Callback[] callbacks = new Callback[]{new AuthTokenCallback()};
            this.handler.handle(callbacks);
            String authToken = ((AuthTokenCallback)callbacks[0]).getAuthToken();
            loginName = tokenFactory.verifyAuthToken(authToken);
        }
        catch (IOException e) {
            throw new FailedLoginException("Cannot get information from the callback handler");
        }
        catch (UnsupportedCallbackException e) {
            throw new FailedLoginException("Configured callback handler does not handle required callback type");
        }
        catch (SecurityException e) {
            if (e.getErrorCode() == 19003) {
                throw new CredentialExpiredException(e.getMessage());
            }
            throw new FailedLoginException(e.getMessage());
        }
        this.principal = new WASPPrincipal(loginName);
        this.succeeded = true;
        return this.succeeded;
    }

    public boolean commit() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        Set<Principal> principals = this.subject.getPrincipals();
        if (!principals.contains(this.principal)) {
            principals.add((Principal)this.principal);
        }
        this.commitSucceeded = true;
        return true;
    }

    public boolean abort() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        if (this.commitSucceeded) {
            this.logout();
        } else {
            this.succeeded = false;
            this.principal = null;
        }
        return true;
    }

    public boolean logout() throws LoginException {
        Set<Principal> principals;
        if (!this.succeeded) {
            return false;
        }
        if (this.commitSucceeded && (principals = this.subject.getPrincipals()).contains(this.principal)) {
            principals.remove(this.principal);
        }
        this.commitSucceeded = false;
        this.succeeded = false;
        this.principal = null;
        return true;
    }
}

