/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.security.spkm;

import com.idoox.security.asn1.Asn1;
import com.idoox.security.asn1.Asn1Exception;
import com.idoox.security.asn1.BitString;
import com.idoox.security.asn1.Constructed;
import com.idoox.security.asn1.Implicit;
import com.idoox.security.asn1.Integer;
import com.idoox.security.asn1.Sequence;
import com.idoox.security.spkm.SeqNum;
import com.idoox.security.util.OID;
import com.idoox.security.x509.AlgorithmId;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.AlgorithmParameters;

public class WrapHeader
extends Sequence {
    private int tokId = 513;
    private byte[] contextId;
    private AlgorithmId intAlg;
    private AlgorithmId confAlg;
    private SeqNum sndSeq;

    public WrapHeader(byte[] contextId, String intAlgName, AlgorithmParameters intAlgParams, String confAlgName, AlgorithmParameters confAlgParams, SeqNum sndSeq) {
        Implicit imp;
        this.addComponent((Asn1)new Integer(this.tokId));
        this.contextId = contextId;
        this.addComponent((Asn1)new BitString(this.contextId));
        if (intAlgName != null) {
            try {
                this.intAlg = new AlgorithmId(OID.getAlgOid((String)intAlgName), intAlgParams);
            }
            catch (Asn1Exception e) {
                try {
                    this.intAlg = new AlgorithmId(OID.getAlgOid((String)intAlgName));
                }
                catch (Asn1Exception e1) {
                    this.intAlg = null;
                }
            }
            imp = new Implicit(-128, 0);
            imp.addComponent((Asn1)this.intAlg);
            this.addComponent((Asn1)imp);
        }
        if (confAlgName != null) {
            try {
                this.confAlg = new AlgorithmId(OID.getAlgOid((String)confAlgName), confAlgParams);
            }
            catch (Asn1Exception e) {
                try {
                    this.confAlg = new AlgorithmId(OID.getAlgOid((String)confAlgName));
                }
                catch (Asn1Exception e1) {
                    this.confAlg = null;
                }
            }
            imp = new Implicit(-128, 1);
            imp.addComponent((Asn1)this.confAlg);
            this.addComponent((Asn1)imp);
        }
        this.sndSeq = sndSeq;
        if (sndSeq != null) {
            imp = new Implicit(-128, 2);
            imp.addComponent((Asn1)this.sndSeq);
            this.addComponent((Asn1)imp);
        }
    }

    public WrapHeader(byte[] encoded) throws Asn1Exception {
        ByteArrayInputStream bin = new ByteArrayInputStream(encoded);
        this.init(bin);
    }

    public WrapHeader(InputStream encoded) throws Asn1Exception {
        this.init(encoded);
    }

    private void init(InputStream encoded) throws Asn1Exception {
        int i = 0;
        this.doDecode(encoded);
        this.tokId = ((Integer)((Constructed)this).components.get(i++)).getInt();
        if (this.tokId != 513) {
            throw new Asn1Exception("Invalid token id");
        }
        this.contextId = ((BitString)((Constructed)this).components.get(i++)).getBytes();
        if (i == ((Constructed)this).components.size()) {
            return;
        }
        Asn1 comp = (Asn1)((Constructed)this).components.get(i);
        if (comp.getTagNumber() == 0) {
            this.intAlg = new AlgorithmId(comp.encode());
            if (++i == ((Constructed)this).components.size()) {
                return;
            }
        }
        if ((comp = (Asn1)((Constructed)this).components.get(i)).getTagNumber() == 1) {
            this.confAlg = new AlgorithmId(comp.encode());
            if (++i == ((Constructed)this).components.size()) {
                return;
            }
        }
        if ((comp = (Asn1)((Constructed)this).components.get(i)).getTagNumber() != 2) {
            throw new Asn1Exception("Bad tag number");
        }
        this.sndSeq = new SeqNum(comp.encode());
    }

    public byte[] getContextId() {
        return this.contextId;
    }

    public AlgorithmId getIntAlg() {
        return this.intAlg;
    }

    public String getIntAlgName() {
        if (this.intAlg != null) {
            return OID.getAlgName((String)this.intAlg.getOid());
        }
        return null;
    }

    public AlgorithmParameters getIntAlgParams() {
        if (this.intAlg != null) {
            return this.intAlg.getParams();
        }
        return null;
    }

    public AlgorithmId getConfAlg() {
        return this.confAlg;
    }

    public String getConfAlgName() {
        if (this.confAlg != null) {
            return OID.getAlgName((String)this.confAlg.getOid());
        }
        return null;
    }

    public AlgorithmParameters getConfAlgParams() {
        if (this.confAlg != null) {
            return this.confAlg.getParams();
        }
        return null;
    }

    public SeqNum getSndSeq() {
        return this.sndSeq;
    }
}

