/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.security.spkm;

import com.idoox.security.asn1.Asn1;
import com.idoox.security.asn1.Asn1Exception;
import com.idoox.security.asn1.Constructed;
import com.idoox.security.asn1.Implicit;
import com.idoox.security.asn1.Sequence;
import com.idoox.security.spkm.CertificationData;
import com.idoox.security.spkm.ReqToken;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class SpkmReq
extends Sequence {
    private ReqToken requestToken;
    private CertificationData certifData;

    public SpkmReq(ReqToken requestToken, CertificationData certifData) {
        this.requestToken = requestToken;
        this.addComponent((Asn1)this.requestToken);
        this.certifData = certifData;
        if (certifData != null) {
            Implicit imp = new Implicit(-128, 0);
            imp.addComponent((Asn1)this.certifData);
            this.addComponent((Asn1)imp);
        }
    }

    public SpkmReq(byte[] encoded) throws Asn1Exception {
        ByteArrayInputStream bin = new ByteArrayInputStream(encoded);
        this.init(bin);
    }

    public SpkmReq(InputStream encoded) throws Asn1Exception {
        this.init(encoded);
    }

    private void init(InputStream encoded) throws Asn1Exception {
        this.doDecode(encoded);
        this.requestToken = new ReqToken(((Asn1)((Constructed)this).components.get(0)).encode());
        if (((Constructed)this).components.size() > 1) {
            Asn1 comp = (Asn1)((Constructed)this).components.get(1);
            if (comp.getTagNumber() == 0) {
                this.certifData = new CertificationData(comp.encode());
            } else if (comp.getTagNumber() != 1) {
                throw new Asn1Exception("Bad tag number");
            }
        }
    }

    public ReqToken getRequestToken() {
        return this.requestToken;
    }

    public CertificationData getCertifData() {
        return this.certifData;
    }
}

