/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.security.spkm;

import com.idoox.security.asn1.Asn1;
import com.idoox.security.asn1.Asn1Exception;
import com.idoox.security.asn1.BitString;
import com.idoox.security.asn1.Constructed;
import com.idoox.security.asn1.Sequence;
import com.idoox.security.spkm.ErrorToken;
import com.idoox.security.util.OID;
import com.idoox.security.x509.AlgorithmId;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.AlgorithmParameters;

public class SpkmError
extends Sequence {
    private ErrorToken errorToken;
    private AlgorithmId algId;
    private byte[] integrity;

    public SpkmError(ErrorToken errorToken, String algName, AlgorithmParameters algParams, byte[] integrity) {
        this.errorToken = errorToken;
        this.addComponent((Asn1)this.errorToken);
        try {
            this.algId = new AlgorithmId(OID.getAlgOid((String)algName), algParams);
        }
        catch (Asn1Exception e) {
            try {
                this.algId = new AlgorithmId(OID.getAlgOid((String)algName));
            }
            catch (Asn1Exception e1) {
                this.algId = null;
            }
        }
        this.addComponent((Asn1)this.algId);
        this.integrity = integrity;
        this.addComponent((Asn1)new BitString(this.integrity));
    }

    public SpkmError(byte[] encoded) throws Asn1Exception {
        ByteArrayInputStream bin = new ByteArrayInputStream(encoded);
        this.init(bin);
    }

    public SpkmError(InputStream encoded) throws Asn1Exception {
        this.init(encoded);
    }

    private void init(InputStream encoded) throws Asn1Exception {
        this.doDecode(encoded);
        this.errorToken = new ErrorToken(((Asn1)((Constructed)this).components.get(0)).encode());
        this.algId = new AlgorithmId(((Asn1)((Constructed)this).components.get(1)).encode());
        this.integrity = ((BitString)((Constructed)this).components.get(2)).getBytes();
    }

    public ErrorToken getErrorToken() {
        return this.errorToken;
    }

    public AlgorithmId getAlgId() {
        return this.algId;
    }

    public String getAlgName() {
        return OID.getAlgName((String)this.algId.getOid());
    }

    public AlgorithmParameters getAlgParams() {
        return this.algId.getParams();
    }

    public byte[] getIntegrity() {
        return this.integrity;
    }
}

