/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.security.spkm;

import com.idoox.security.asn1.Asn1;
import com.idoox.security.asn1.Asn1Exception;
import com.idoox.security.asn1.BitString;
import com.idoox.security.asn1.Constructed;
import com.idoox.security.asn1.Sequence;
import com.idoox.security.spkm.DelHeader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class SpkmDel
extends Sequence {
    private DelHeader delHeader;
    private byte[] intCksum;

    public SpkmDel(DelHeader delHeader, byte[] intCksum) {
        this.delHeader = delHeader;
        this.addComponent((Asn1)this.delHeader);
        this.intCksum = intCksum;
        this.addComponent((Asn1)new BitString(this.intCksum));
    }

    public SpkmDel(byte[] encoded) throws Asn1Exception {
        ByteArrayInputStream bin = new ByteArrayInputStream(encoded);
        this.init(bin);
    }

    public SpkmDel(InputStream encoded) throws Asn1Exception {
        this.init(encoded);
    }

    private void init(InputStream encoded) throws Asn1Exception {
        this.doDecode(encoded);
        this.delHeader = new DelHeader(((Asn1)((Constructed)this).components.get(0)).encode());
        this.intCksum = ((BitString)((Constructed)this).components.get(1)).getBytes();
    }

    public DelHeader getDelHeader() {
        return this.delHeader;
    }

    public byte[] getIntCksum() {
        return this.intCksum;
    }
}

