/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.security.spkm;

import com.idoox.security.asn1.Asn1;
import com.idoox.security.asn1.Asn1Exception;
import com.idoox.security.asn1.Boolean;
import com.idoox.security.asn1.Constructed;
import com.idoox.security.asn1.Integer;
import com.idoox.security.asn1.Sequence;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigInteger;

public class SeqNum
extends Sequence {
    private BigInteger num;
    private boolean dirInd;

    public SeqNum(BigInteger num, boolean dirInd) {
        this.num = num;
        this.addComponent((Asn1)new Integer(num));
        this.dirInd = dirInd;
        this.addComponent((Asn1)new Boolean(this.dirInd ? 1 : 0));
    }

    public SeqNum(byte[] encoded) throws Asn1Exception {
        ByteArrayInputStream bin = new ByteArrayInputStream(encoded);
        this.init(bin);
    }

    public SeqNum(InputStream encoded) throws Asn1Exception {
        this.init(encoded);
    }

    private void init(InputStream encoded) throws Asn1Exception {
        this.doDecode(encoded);
        this.num = ((Integer)((Constructed)this).components.get(0)).getBigInt();
        this.dirInd = ((Boolean)((Constructed)this).components.get(1)).getTruth();
    }

    public BigInteger getNum() {
        return this.num;
    }

    public long getNumLong() {
        return this.num.longValue();
    }

    public boolean getDirInd() {
        return this.dirInd;
    }
}

