/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.security.spkm;

import com.idoox.security.asn1.Asn1;
import com.idoox.security.asn1.Asn1Exception;
import com.idoox.security.asn1.BitString;
import com.idoox.security.asn1.Constructed;
import com.idoox.security.asn1.Sequence;
import com.idoox.security.spkm.ReqContents;
import com.idoox.security.util.OID;
import com.idoox.security.x509.AlgorithmId;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.AlgorithmParameters;

public class ReqToken
extends Sequence {
    private ReqContents reqContents;
    private AlgorithmId algId;
    private byte[] reqIntegrity;

    public ReqToken(ReqContents reqContents, String algName, AlgorithmParameters algParams, byte[] reqIntegrity) {
        this.reqContents = reqContents;
        this.addComponent((Asn1)this.reqContents);
        try {
            this.algId = new AlgorithmId(OID.getAlgOid((String)algName), algParams);
        }
        catch (Asn1Exception e) {
            try {
                this.algId = new AlgorithmId(OID.getAlgOid((String)algName));
            }
            catch (Asn1Exception e1) {
                this.algId = null;
            }
        }
        this.addComponent((Asn1)this.algId);
        this.reqIntegrity = reqIntegrity;
        this.addComponent((Asn1)new BitString(this.reqIntegrity));
    }

    public ReqToken(byte[] encoded) throws Asn1Exception {
        ByteArrayInputStream bin = new ByteArrayInputStream(encoded);
        this.init(bin);
    }

    public ReqToken(InputStream encoded) throws Asn1Exception {
        this.init(encoded);
    }

    private void init(InputStream encoded) throws Asn1Exception {
        this.doDecode(encoded);
        this.reqContents = new ReqContents(((Asn1)((Constructed)this).components.get(0)).encode());
        this.algId = new AlgorithmId(((Asn1)((Constructed)this).components.get(1)).encode());
        this.reqIntegrity = ((BitString)((Constructed)this).components.get(2)).getBytes();
    }

    public ReqContents getReqContents() {
        return this.reqContents;
    }

    public AlgorithmId getAlgId() {
        return this.algId;
    }

    public String getAlgName() {
        return OID.getAlgName((String)this.algId.getOid());
    }

    public AlgorithmParameters getAlgParams() {
        return this.algId.getParams();
    }

    public byte[] getReqIntegrity() {
        return this.reqIntegrity;
    }
}

