/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.security.spkm;

import com.idoox.security.asn1.Asn1;
import com.idoox.security.asn1.Asn1Exception;
import com.idoox.security.asn1.Asn1String;
import com.idoox.security.asn1.BitString;
import com.idoox.security.asn1.Constructed;
import com.idoox.security.asn1.Implicit;
import com.idoox.security.asn1.Integer;
import com.idoox.security.asn1.Sequence;
import com.idoox.security.asn1.UTCTime;
import com.idoox.security.spkm.Algs;
import com.idoox.security.spkm.ContextData;
import com.idoox.security.x509.Validity;
import com.idoox.security.x509.X500Name;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ReqContents
extends Sequence {
    private int tokId = 256;
    private byte[] contextId;
    private byte[] pvno = new byte[]{1};
    private UTCTime timestamp;
    private byte[] randSrc;
    private X500Name targName;
    private X500Name srcName;
    private ContextData reqData;
    private Validity validity;
    private Algs keyEstbSet;
    private byte[] keyEstbReq;
    private byte[] keySrcBind;

    public ReqContents(byte[] contextId, UTCTime timestamp, byte[] randSrc, X500Name targName, X500Name srcName, ContextData reqData, Validity validity, Algs keyEstbSet, byte[] keyEstbReq, byte[] keySrcBind) {
        Implicit imp;
        this.addComponent((Asn1)new Integer(this.tokId));
        this.contextId = contextId;
        this.addComponent((Asn1)new BitString(this.contextId));
        this.addComponent((Asn1)new BitString(this.pvno));
        this.timestamp = timestamp;
        if (timestamp != null) {
            this.addComponent((Asn1)timestamp);
        }
        this.randSrc = randSrc;
        this.addComponent((Asn1)new BitString(this.randSrc));
        this.targName = targName;
        this.addComponent((Asn1)this.targName);
        this.srcName = srcName;
        if (srcName != null) {
            imp = new Implicit(-128, 0);
            imp.addComponent((Asn1)srcName);
            this.addComponent((Asn1)imp);
        }
        this.reqData = reqData;
        this.addComponent((Asn1)this.reqData);
        this.validity = validity;
        if (validity != null) {
            imp = new Implicit(-128, 1);
            imp.addComponent((Asn1)validity);
            this.addComponent((Asn1)imp);
        }
        this.keyEstbSet = keyEstbSet;
        this.addComponent((Asn1)this.keyEstbSet);
        this.keyEstbReq = keyEstbReq;
        if (keyEstbReq != null) {
            this.addComponent((Asn1)new BitString(this.keyEstbReq));
        }
        this.keySrcBind = keySrcBind;
        if (keySrcBind != null) {
            this.addComponent((Asn1)new Asn1String(this.keySrcBind));
        }
    }

    public ReqContents(byte[] encoded) throws Asn1Exception {
        ByteArrayInputStream bin = new ByteArrayInputStream(encoded);
        this.init(bin);
    }

    public ReqContents(InputStream encoded) throws Asn1Exception {
        this.init(encoded);
    }

    private void init(InputStream encoded) throws Asn1Exception {
        int i = 0;
        this.doDecode(encoded);
        this.tokId = ((Integer)((Constructed)this).components.get(i++)).getInt();
        if (this.tokId != 256) {
            throw new Asn1Exception("Invalid token id");
        }
        this.contextId = ((BitString)((Constructed)this).components.get(i++)).getBytes();
        this.pvno = ((BitString)((Constructed)this).components.get(i++)).getBytes();
        if (this.pvno[0] != 1) {
            throw new Asn1Exception("Invalid protocol version");
        }
        try {
            this.timestamp = (UTCTime)((Constructed)this).components.get(i);
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        int n = ++i;
        this.randSrc = ((BitString)((Constructed)this).components.get(n)).getBytes();
        int n2 = ++i;
        this.targName = new X500Name(((Asn1)((Constructed)this).components.get(n2)).encode());
        Asn1 comp = (Asn1)((Constructed)this).components.get(++i);
        if (comp.getTagNumber() == 0) {
            this.srcName = new X500Name(comp.encode());
        }
        int n3 = ++i;
        this.reqData = new ContextData(((Asn1)((Constructed)this).components.get(n3)).encode());
        if ((comp = (Asn1)((Constructed)this).components.get(++i)).getTagNumber() == 1) {
            this.validity = new Validity(comp.encode());
        }
        int n4 = ++i;
        this.keyEstbSet = new Algs(((Asn1)((Constructed)this).components.get(n4)).encode());
        if (++i == ((Constructed)this).components.size()) {
            return;
        }
        try {
            this.keyEstbReq = ((BitString)((Constructed)this).components.get(i)).getBytes();
            if (++i == ((Constructed)this).components.size()) {
                return;
            }
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        try {
            this.keySrcBind = ((Asn1String)((Constructed)this).components.get(i)).getBytes();
        }
        catch (ClassCastException e) {
            // empty catch block
        }
    }

    public byte[] getContextId() {
        return this.contextId;
    }

    public byte[] getPvno() {
        return this.pvno;
    }

    public UTCTime getTimestamp() {
        return this.timestamp;
    }

    public byte[] getRandSrc() {
        return this.randSrc;
    }

    public X500Name getTargName() {
        return this.targName;
    }

    public X500Name getSrcName() {
        return this.srcName;
    }

    public ContextData getReqData() {
        return this.reqData;
    }

    public Validity getValidity() {
        return this.validity;
    }

    public Algs getKeyEstbSet() {
        return this.keyEstbSet;
    }

    public byte[] getKeyEstbReq() {
        return this.keyEstbReq;
    }

    public byte[] getKeySrcBind() {
        return this.keySrcBind;
    }
}

