/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.security.spkm;

import com.idoox.security.asn1.Asn1;
import com.idoox.security.asn1.Asn1Exception;
import com.idoox.security.asn1.BitString;
import com.idoox.security.asn1.Constructed;
import com.idoox.security.asn1.Implicit;
import com.idoox.security.asn1.Integer;
import com.idoox.security.asn1.Primitive;
import com.idoox.security.asn1.Sequence;
import com.idoox.security.asn1.UTCTime;
import com.idoox.security.spkm.ContextData;
import com.idoox.security.x509.AlgorithmId;
import com.idoox.security.x509.Validity;
import com.idoox.security.x509.X500Name;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class RepTIContents
extends Sequence {
    private int tokId = 512;
    private byte[] contextId;
    private byte[] pvno = new byte[]{1};
    private UTCTime timestamp;
    private byte[] randTarg;
    private X500Name srcName;
    private X500Name targName;
    private byte[] randSrc;
    private ContextData repData;
    private Validity validity;
    private AlgorithmId keyEstbId;
    private byte[] keyEstbStr;

    public RepTIContents(byte[] contextId, byte[] pvno, UTCTime timestamp, byte[] randTarg, X500Name srcName, X500Name targName, byte[] randSrc, ContextData repData, Validity validity, AlgorithmId keyEstbId, byte[] keyEstbStr) {
        Implicit imp;
        this.addComponent((Asn1)new Integer(this.tokId));
        this.contextId = contextId;
        this.addComponent((Asn1)new BitString(this.contextId));
        if (pvno != null) {
            this.pvno = pvno;
            imp = new Implicit(-128, 0);
            imp.addComponent((Asn1)new BitString(pvno));
            this.addComponent((Asn1)imp);
        }
        this.timestamp = timestamp;
        if (timestamp != null) {
            this.addComponent((Asn1)timestamp);
        }
        this.randTarg = randTarg;
        this.addComponent((Asn1)new BitString(this.randTarg));
        this.srcName = srcName;
        if (srcName != null) {
            imp = new Implicit(-128, 1);
            imp.addComponent((Asn1)srcName);
            this.addComponent((Asn1)imp);
        }
        this.targName = targName;
        this.addComponent((Asn1)this.targName);
        this.randSrc = randSrc;
        this.addComponent((Asn1)new BitString(this.randSrc));
        this.repData = repData;
        this.addComponent((Asn1)this.repData);
        this.validity = validity;
        if (validity != null) {
            imp = new Implicit(-128, 2);
            imp.addComponent((Asn1)validity);
            this.addComponent((Asn1)imp);
        }
        this.keyEstbId = keyEstbId;
        if (keyEstbId != null) {
            this.addComponent((Asn1)this.keyEstbId);
        }
        this.keyEstbStr = keyEstbStr;
        if (keyEstbStr != null) {
            this.addComponent((Asn1)new BitString(this.keyEstbStr));
        }
    }

    public RepTIContents(byte[] encoded) throws Asn1Exception {
        ByteArrayInputStream bin = new ByteArrayInputStream(encoded);
        this.init(bin);
    }

    public RepTIContents(InputStream encoded) throws Asn1Exception {
        this.init(encoded);
    }

    private void init(InputStream encoded) throws Asn1Exception {
        int i = 0;
        this.doDecode(encoded);
        this.tokId = ((Integer)((Constructed)this).components.get(i++)).getInt();
        if (this.tokId != 512) {
            throw new Asn1Exception("Invalid token id");
        }
        this.contextId = ((BitString)((Constructed)this).components.get(i++)).getBytes();
        Asn1 comp = (Asn1)((Constructed)this).components.get(i);
        if (comp.getTagNumber() == 0) {
            this.pvno = ((Primitive)comp).getBytes();
            ++i;
        }
        try {
            this.timestamp = (UTCTime)((Constructed)this).components.get(i);
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        int n = ++i;
        this.randTarg = ((BitString)((Constructed)this).components.get(n)).getBytes();
        comp = (Asn1)((Constructed)this).components.get(++i);
        if (comp.getTagNumber() == 1) {
            this.srcName = new X500Name(comp.encode());
        }
        int n2 = ++i;
        this.targName = new X500Name(((Asn1)((Constructed)this).components.get(n2)).encode());
        int n3 = ++i;
        this.randSrc = ((BitString)((Constructed)this).components.get(n3)).getBytes();
        int n4 = ++i;
        this.repData = new ContextData(((Asn1)((Constructed)this).components.get(n4)).encode());
        if (++i == ((Constructed)this).components.size()) {
            return;
        }
        comp = (Asn1)((Constructed)this).components.get(i);
        if (comp.getTagNumber() == 2) {
            this.validity = new Validity(comp.encode());
            if (++i == ((Constructed)this).components.size()) {
                return;
            }
        }
        try {
            Sequence seq = (Sequence)((Constructed)this).components.get(i);
            this.keyEstbId = new AlgorithmId(seq.encode());
            if (++i == ((Constructed)this).components.size()) {
                return;
            }
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        try {
            this.keyEstbStr = ((BitString)((Constructed)this).components.get(i)).getBytes();
        }
        catch (ClassCastException e) {
            // empty catch block
        }
    }

    public byte[] getContextId() {
        return this.contextId;
    }

    public byte[] getPvno() {
        return this.pvno;
    }

    public UTCTime getTimestamp() {
        return this.timestamp;
    }

    public byte[] getRandTarg() {
        return this.randTarg;
    }

    public byte[] getRandSrc() {
        return this.randSrc;
    }

    public X500Name getTargName() {
        return this.targName;
    }

    public X500Name getSrcName() {
        return this.srcName;
    }

    public ContextData getRepData() {
        return this.repData;
    }

    public Validity getValidity() {
        return this.validity;
    }

    public AlgorithmId getKeyEstbId() {
        return this.keyEstbId;
    }

    public byte[] getKeyEstbStr() {
        return this.keyEstbStr;
    }
}

