/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.security.spkm;

import com.idoox.debug.Category;
import com.idoox.security.jaas.GSSCredentialSupport;
import com.idoox.security.spkm.GSSManagerImpl;
import com.idoox.security.spkm.GSSNameImpl;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import org.idoox.security.pstore.BadPasswordException;
import org.idoox.security.pstore.KeyStore;
import org.idoox.security.pstore.KeyStoreException;
import org.idoox.security.pstore.PStore;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class GSSCredentialImpl
implements GSSCredential {
    Category dbg = Category.getCategory((class$com$idoox$security$spkm$GSSCredentialImpl == null ? (class$com$idoox$security$spkm$GSSCredentialImpl = GSSCredentialImpl.class$("com.idoox.security.spkm.GSSCredentialImpl")) : class$com$idoox$security$spkm$GSSCredentialImpl).getName());
    private int lifetime;
    private int usage;
    private GSSNameImpl name;
    private PrivateKey key;
    private X509Certificate[] certs;
    static /* synthetic */ Class class$com$idoox$security$spkm$GSSCredentialImpl;

    public GSSCredentialImpl(GSSNameImpl name, int lifetime, int usage) throws GSSException {
        KeyStore keyStore;
        try {
            keyStore = PStore.getInstance(null).getKeyStore();
        }
        catch (BadPasswordException e) {
            throw new GSSException(13);
        }
        String password = GSSCredentialSupport.getPassword();
        if (password == null) {
            password = System.getProperty("user.password");
        }
        if (password == null) {
            throw new GSSException(13, 4, "No password for public key found");
        }
        if (keyStore.containsAlias(name.getName()) && keyStore.isKeyEntry(name.getName())) {
            try {
                this.key = (PrivateKey)keyStore.getKey(name.getName(), password);
            }
            catch (BadPasswordException e) {
                throw new GSSException(13);
            }
            catch (KeyStoreException e) {
                throw new GSSException(13);
            }
            Certificate[] crts = null;
            try {
                crts = keyStore.getCertificateChain(name.getName());
            }
            catch (KeyStoreException e) {
                throw new GSSException(13);
            }
            this.certs = new X509Certificate[crts.length];
            int i = 0;
            while (i < crts.length) {
                this.certs[i] = (X509Certificate)crts[i];
                ++i;
            }
        } else {
            throw new GSSException(2, 0, "Alias " + name.getName() + " not found in KeyStore.");
        }
        this.name = name;
        this.lifetime = lifetime;
        this.usage = usage;
    }

    public void dispose() throws GSSException {
        this.key = null;
    }

    public GSSName getName() throws GSSException {
        return this.name;
    }

    public GSSName getName(Oid mechOID) throws GSSException {
        return this.name;
    }

    public int getRemainingLifetime() throws GSSException {
        return Integer.MAX_VALUE;
    }

    public int getRemainingInitLifetime(Oid mech) throws GSSException {
        return Integer.MAX_VALUE;
    }

    public int getRemainingAcceptLifetime(Oid mech) throws GSSException {
        return Integer.MAX_VALUE;
    }

    public int getUsage() throws GSSException {
        return this.usage;
    }

    public int getUsage(Oid mechOID) throws GSSException {
        return this.usage;
    }

    public Oid[] getMechs() throws GSSException {
        return GSSManagerImpl.mechs;
    }

    public void add(GSSName aName, int initLifetime, int acceptLifetime, Oid mech, int usage) throws GSSException {
        throw new GSSException(16);
    }

    public boolean equals(Object another) {
        if (another instanceof GSSCredentialImpl) {
            GSSCredentialImpl other = (GSSCredentialImpl)another;
            try {
                if (this.name.equals(other.name) && this.lifetime == other.lifetime && this.usage == other.usage) {
                    return true;
                }
            }
            catch (GSSException gSSException) {
                // empty catch block
            }
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode() + this.lifetime + this.usage;
    }

    public PrivateKey getKey() {
        return this.key;
    }

    public PrivateKey getVerifKey() {
        return this.key;
    }

    public X509Certificate[] getCertificates() {
        return this.certs;
    }

    public X509Certificate getCertificate() {
        return this.certs[0];
    }

    public X509Certificate[] getVerifCertificates() {
        return this.certs;
    }

    public X509Certificate getVerifCertificate() {
        return this.certs[0];
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

