/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.security.spkm;

import com.idoox.security.asn1.Asn1;
import com.idoox.security.asn1.Asn1Exception;
import com.idoox.security.asn1.BitString;
import com.idoox.security.asn1.Constructed;
import com.idoox.security.asn1.Implicit;
import com.idoox.security.asn1.Integer;
import com.idoox.security.asn1.Sequence;
import com.idoox.security.spkm.SeqNum;
import com.idoox.security.util.OID;
import com.idoox.security.x509.AlgorithmId;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.AlgorithmParameters;

public class DelHeader
extends Sequence {
    private int tokId = 769;
    private byte[] contextId;
    private AlgorithmId intAlg;
    private SeqNum sndSeq;

    public DelHeader(byte[] contextId, String algName, AlgorithmParameters algParams, SeqNum sndSeq) {
        Implicit imp;
        this.addComponent((Asn1)new Integer(this.tokId));
        this.contextId = contextId;
        this.addComponent((Asn1)new BitString(this.contextId));
        if (algName != null) {
            try {
                this.intAlg = new AlgorithmId(OID.getAlgOid((String)algName), algParams);
            }
            catch (Asn1Exception e) {
                try {
                    this.intAlg = new AlgorithmId(OID.getAlgOid((String)algName));
                }
                catch (Asn1Exception e1) {
                    this.intAlg = null;
                }
            }
            imp = new Implicit(-128, 0);
            imp.addComponent((Asn1)this.intAlg);
            this.addComponent((Asn1)imp);
        }
        this.sndSeq = sndSeq;
        if (sndSeq != null) {
            imp = new Implicit(-128, 1);
            imp.addComponent((Asn1)this.sndSeq);
            this.addComponent((Asn1)imp);
        }
    }

    public DelHeader(byte[] encoded) throws Asn1Exception {
        ByteArrayInputStream bin = new ByteArrayInputStream(encoded);
        this.init(bin);
    }

    public DelHeader(InputStream encoded) throws Asn1Exception {
        this.init(encoded);
    }

    private void init(InputStream encoded) throws Asn1Exception {
        int i = 0;
        this.doDecode(encoded);
        this.tokId = ((Integer)((Constructed)this).components.get(i++)).getInt();
        if (this.tokId != 769) {
            throw new Asn1Exception("Invalid token id");
        }
        this.contextId = ((BitString)((Constructed)this).components.get(i++)).getBytes();
        if (i == ((Constructed)this).components.size()) {
            return;
        }
        Asn1 comp = (Asn1)((Constructed)this).components.get(i);
        if (comp.getTagNumber() == 0) {
            this.intAlg = new AlgorithmId(comp.encode());
            if (++i == ((Constructed)this).components.size()) {
                return;
            }
        }
        if ((comp = (Asn1)((Constructed)this).components.get(i)).getTagNumber() != 1) {
            throw new Asn1Exception("Bad tag number");
        }
        this.sndSeq = new SeqNum(comp.encode());
    }

    public byte[] getContextId() {
        return this.contextId;
    }

    public AlgorithmId getIntAlg() {
        return this.intAlg;
    }

    public String getAlgName() {
        if (this.intAlg != null) {
            return OID.getAlgName((String)this.intAlg.getOid());
        }
        return null;
    }

    public AlgorithmParameters getAlgParams() {
        if (this.intAlg != null) {
            return this.intAlg.getParams();
        }
        return null;
    }

    public SeqNum getSndSeq() {
        return this.sndSeq;
    }
}

