/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.security.spkm;

import com.idoox.security.asn1.Asn1;
import com.idoox.security.asn1.Asn1Exception;
import com.idoox.security.asn1.Asn1String;
import com.idoox.security.asn1.Constructed;
import com.idoox.security.asn1.Implicit;
import com.idoox.security.asn1.Integer;
import com.idoox.security.asn1.Null;
import com.idoox.security.asn1.Sequence;
import com.idoox.security.spkm.Algs;
import com.idoox.security.spkm.Options;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigInteger;

public class ContextData
extends Sequence {
    private byte[] channelId;
    private BigInteger seqNumber;
    private Options options;
    private Algs confAlgs;
    private Algs intgAlgs;
    private Algs owfAlgs;

    public ContextData(byte[] channelId, BigInteger seqNumber, Options options, Algs confAlgs, Algs intgAlgs, Algs owfAlgs) {
        this.channelId = channelId;
        if (channelId != null) {
            this.addComponent((Asn1)new Asn1String(this.channelId));
        }
        this.seqNumber = seqNumber;
        if (seqNumber != null) {
            this.addComponent((Asn1)new Integer(this.seqNumber));
        }
        this.options = options;
        this.addComponent((Asn1)this.options);
        this.confAlgs = confAlgs;
        if (confAlgs == null) {
            Implicit imp = new Implicit(-128, 1);
            imp.addComponent((Asn1)new Null());
            this.addComponent((Asn1)imp);
        } else {
            Implicit imp = new Implicit(-128, 0);
            imp.addComponent((Asn1)this.confAlgs);
            this.addComponent((Asn1)imp);
        }
        this.intgAlgs = intgAlgs;
        this.addComponent((Asn1)this.intgAlgs);
        this.owfAlgs = owfAlgs;
        this.addComponent((Asn1)this.owfAlgs);
    }

    public ContextData(byte[] channelId, long seqNumber, Options options, Algs confAlgs, Algs intgAlgs, Algs owfAlgs) {
        this(channelId, BigInteger.valueOf(seqNumber), options, confAlgs, intgAlgs, owfAlgs);
    }

    public ContextData(byte[] encoded) throws Asn1Exception {
        ByteArrayInputStream bin = new ByteArrayInputStream(encoded);
        this.init(bin);
    }

    public ContextData(InputStream encoded) throws Asn1Exception {
        this.init(encoded);
    }

    private void init(InputStream encoded) throws Asn1Exception {
        int i = 0;
        this.doDecode(encoded);
        try {
            Asn1String oStr = (Asn1String)((Constructed)this).components.get(i);
            ++i;
            this.channelId = oStr.getBytes();
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        try {
            Integer aInt = (Integer)((Constructed)this).components.get(i);
            this.seqNumber = aInt.getBigInt();
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        int n = ++i;
        this.options = new Options(((Asn1)((Constructed)this).components.get(n)).encode());
        int n2 = ++i;
        ++i;
        Asn1 confA = (Asn1)((Constructed)this).components.get(n2);
        if (confA.getTagNumber() == 0) {
            this.confAlgs = new Algs(confA.encode());
        } else if (confA.getTagNumber() == 1) {
            this.confAlgs = null;
        } else {
            throw new Asn1Exception("Invalid tag number");
        }
        this.intgAlgs = new Algs(((Asn1)((Constructed)this).components.get(i++)).encode());
        this.owfAlgs = new Algs(((Asn1)((Constructed)this).components.get(i)).encode());
    }

    public byte[] getChannelId() {
        return this.channelId;
    }

    public BigInteger getSeqNumber() {
        return this.seqNumber;
    }

    public long getSeqNumberLong() {
        return this.seqNumber.longValue();
    }

    public Options getOptions() {
        return this.options;
    }

    public Algs getConfAlgs() {
        return this.confAlgs;
    }

    public Algs getIntgAlgs() {
        return this.intgAlgs;
    }

    public Algs getOWFAlgs() {
        return this.owfAlgs;
    }
}

