/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.security.server;

import com.idoox.debug.Category;
import com.idoox.security.CredentialsImpl;
import com.idoox.security.jaas.WaspCallbackHandler;
import java.io.UnsupportedEncodingException;
import javax.security.auth.callback.CallbackHandler;
import org.idoox.security.AuthResult;
import org.idoox.security.Config;
import org.idoox.security.Credentials;
import org.idoox.security.PrincipalAuthenticator;
import org.idoox.security.pstore.BadPasswordException;
import org.idoox.security.pstore.PStore;
import org.idoox.security.util.RuntimeWrappedException;

public class PrincipalAuthenticatorImpl
implements PrincipalAuthenticator {
    private Category log = Category.getCategory((class$com$idoox$security$server$PrincipalAuthenticatorImpl == null ? (class$com$idoox$security$server$PrincipalAuthenticatorImpl = PrincipalAuthenticatorImpl.class$("com.idoox.security.server.PrincipalAuthenticatorImpl")) : class$com$idoox$security$server$PrincipalAuthenticatorImpl).getName());
    private String authMech = "SPKM";
    private String loginContextName = "Credentials";
    static /* synthetic */ Class class$com$idoox$security$server$PrincipalAuthenticatorImpl;

    public PrincipalAuthenticatorImpl() {
    }

    public PrincipalAuthenticatorImpl(String authMech, String loginContextName) {
        this.authMech = authMech;
        this.loginContextName = loginContextName;
    }

    public AuthResult authenticate(String securityName, byte[] authData) {
        String configId = Config.getId();
        AuthResult retval = new AuthResult();
        try {
            WaspCallbackHandler handler = new WaspCallbackHandler(securityName, new String(authData, "UTF-8"), configId, PStore.getInstance("").getKeyStore(), PStore.getInstance("").getUserStore());
            CredentialsImpl creds = new CredentialsImpl(securityName, this.authMech, this.loginContextName, (CallbackHandler)handler);
            if (creds.getAuthenticationStatus() != 0) {
                retval.resultCode = 1;
            } else {
                retval.creds = creds;
                retval.resultCode = 0;
            }
            return retval;
        }
        catch (RuntimeWrappedException e) {
            retval.errorReason = e;
            retval.resultCode = 1;
            return retval;
        }
        catch (RuntimeException e) {
            retval.resultCode = 1;
            retval.errorReason = new RuntimeWrappedException("cannot authenticate", (Throwable)e);
            return retval;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeWrappedException((Throwable)e);
        }
        catch (BadPasswordException e) {
            retval.resultCode = 1;
            retval.errorReason = new RuntimeWrappedException("cannot authenticate", (Throwable)e);
            return retval;
        }
    }

    public AuthResult continueAuthentication(byte[] responseData, Credentials creds) {
        AuthResult retval = new AuthResult();
        retval.resultCode = 1;
        retval.errorReason = new RuntimeWrappedException("continueAuthentication action not performed.");
        return retval;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

