/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.security.pstore.ldap;

import com.idoox.debug.Category;
import com.idoox.security.pstore.CipherSerializer;
import com.idoox.security.pstore.PasswordPropertySerializer;
import com.idoox.security.pstore.X509certPropertySerializer;
import com.idoox.security.pstore.X509certchainPropertySerializer;
import java.math.BigInteger;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import org.idoox.security.Config;
import org.idoox.security.pstore.AbstractUserStore;
import org.idoox.security.pstore.PropertySerializer;
import org.idoox.security.pstore.UserEntry;
import org.idoox.security.pstore.UserIterator;
import org.idoox.security.pstore.UserStoreException;
import org.idoox.security.pstore.UserStoreSource;

public class LdapUserStore
extends AbstractUserStore {
    static Category log = Category.getCategory((class$com$idoox$security$pstore$ldap$LdapUserStore == null ? (class$com$idoox$security$pstore$ldap$LdapUserStore = LdapUserStore.class$("com.idoox.security.pstore.ldap.LdapUserStore")) : class$com$idoox$security$pstore$ldap$LdapUserStore).getName());
    private static final Map EMPTY_MAP = new HashMap(1);
    protected static Map propertySerializers = Collections.synchronizedMap(new HashMap());
    protected static final String SEARCH_BASE_KEY = "wasp.ldap.searchbase";
    protected String LDAP_SEARCHBASE = null;
    protected static final String DEFAULT_SN_KEY = "wasp.ldap.defaultsn";
    protected String DEFAULT_SN = "wasp";
    public static final String USER_ID_KEY = "wasp.ldap.userid";
    protected String USER_ID = "uid";
    public static final String DEFAULT_CN_KEY = "wasp.ldap.defaultcnsuffix";
    protected String DEFAULT_CN = null;
    public static final String REUSE_EXISTING_ONLY_KEY = "wasp.ldap.reuseExistingOnly";
    protected boolean REUSE_EXISTING_ONLY;
    public static final String ENCYPT_DESEDE_KEY = "wasp.ldap.DESede.key";
    protected Properties props = null;
    private String[] WASP_PROPS = null;
    private String searchFilter = "(uid=*)";
    protected SearchControls constraints;
    protected InitialLdapContext ctx = null;
    protected Object contextSync = new Object();
    static /* synthetic */ Class class$com$idoox$security$pstore$ldap$LdapUserStore;

    public LdapUserStore() throws Exception {
        this.init();
    }

    public LdapUserStore(String password) throws Exception {
        this.init();
    }

    public LdapUserStore(Properties properties) throws Exception {
        this.props = properties;
        this.init();
    }

    private void init() throws Exception {
        String defaultCn;
        log.info("init()");
        if (this.props == null) {
            this.props = Config.getProperties();
        }
        Object ps = new PasswordPropertySerializer();
        if (this.props.getProperty(ENCYPT_DESEDE_KEY) != null) {
            BigInteger bi = new BigInteger(this.props.getProperty(ENCYPT_DESEDE_KEY).toString(), 16);
            byte[] ba = bi.toByteArray();
            HashMap<String, Object> map = new HashMap<String, Object>(5);
            map.put("DESede.key", ba);
            map.put("nested.prop.serializer", ps);
            ps = new CipherSerializer(map);
        }
        this.LDAP_SEARCHBASE = this.props.getProperty(SEARCH_BASE_KEY);
        if (this.LDAP_SEARCHBASE == null) {
            throw new IllegalArgumentException("Unknown search base");
        }
        String userId = this.props.getProperty(USER_ID_KEY);
        if (userId != null) {
            this.USER_ID = userId;
            this.searchFilter = "(" + this.USER_ID + "=*)";
        }
        if ((defaultCn = this.props.getProperty(DEFAULT_CN_KEY)) != null && !defaultCn.equals("${userid}")) {
            this.DEFAULT_CN = defaultCn;
        }
        if (this.props.getProperty(DEFAULT_SN_KEY) != null) {
            this.DEFAULT_SN = this.props.getProperty(DEFAULT_SN_KEY).toString();
        }
        String reuseExisting = this.props.getProperty(REUSE_EXISTING_ONLY_KEY, "true");
        this.REUSE_EXISTING_ONLY = reuseExisting.equals("true");
        if (((Hashtable)this.props).get("java.naming.provider.url") != null && ((Hashtable)this.props).get("wasp.ldap.printSASLMechs") != null) {
            try {
                InitialDirContext ctx2 = new InitialDirContext();
                Attributes attrs = ctx2.getAttributes(((Hashtable)this.props).get("java.naming.provider.url").toString(), new String[]{"supportedSASLMechanisms"});
                log.info("supportedSASLMechanisms: " + attrs);
            }
            catch (Exception e) {
                log.error("Unable to print supported SASL mechanisms", e);
            }
        }
        propertySerializers.put("password", ps);
        propertySerializers.put("X509Certificate", new X509certPropertySerializer());
        propertySerializers.put("X509CertificateChain", new X509certchainPropertySerializer());
        this.WASP_PROPS = new String[3];
        this.WASP_PROPS[0] = "password";
        this.WASP_PROPS[1] = "X509Certificate";
        this.WASP_PROPS[2] = "X509CertificateChain";
        this.ctx = new InitialLdapContext(this.props, null);
        this.constraints = new SearchControls();
        this.constraints.setCountLimit(0L);
        this.constraints.setSearchScope(1);
    }

    protected void addPropertySerializer(String property, PropertySerializer ps) {
        propertySerializers.put(property, ps);
        String[] newProps = new String[this.WASP_PROPS.length + 1];
        System.arraycopy(this.WASP_PROPS, 0, newProps, 0, this.WASP_PROPS.length);
        newProps[this.WASP_PROPS.length] = property;
        this.WASP_PROPS = newProps;
    }

    public String wasp2LdapKey(Object key) {
        Object ret = ((Hashtable)this.props).get(key);
        return ret != null ? ret.toString() : key.toString();
    }

    private String getLDAPName(Attributes attrs) throws NamingException {
        return "cn=" + this.escape(attrs.get("cn").get().toString()) + "," + this.LDAP_SEARCHBASE;
    }

    protected String getUserFilter(String userId) {
        return "(" + this.USER_ID + "=" + this.escape(userId) + ")";
    }

    private String escape(String val) {
        StringBuffer result = null;
        char[] chars = val.toCharArray();
        int i = 0;
        while (i < chars.length) {
            switch (chars[i]) {
                case '*': {
                    if (result == null) {
                        result = new StringBuffer(new String(chars, 0, i));
                    }
                    result.append("\\2a");
                }
                case '(': {
                    if (result == null) {
                        result = new StringBuffer(new String(chars, 0, i));
                    }
                    result.append("\\28");
                }
                case ')': {
                    if (result == null) {
                        result = new StringBuffer(new String(chars, 0, i));
                    }
                    result.append("\\29");
                }
                case '\\': {
                    if (result == null) {
                        result = new StringBuffer(new String(chars, 0, i));
                    }
                    result.append("\\5c");
                }
                case '\u0000': {
                    if (result == null) {
                        result = new StringBuffer(new String(chars, 0, i));
                    }
                    result.append("\\00");
                }
            }
            if (result != null) {
                result.append(chars[i]);
            }
            ++i;
        }
        if (result != null) {
            return result.toString();
        }
        return val;
    }

    public void deleteUser(String userId) throws UserStoreException {
        block30: {
            Attributes attrs = null;
            boolean moreMatching = false;
            try {
                NamingEnumeration<SearchResult> results;
                String userFilter = this.getUserFilter(userId);
                Object object = this.contextSync;
                synchronized (object) {
                    try {
                        results = this.ctx.search(this.LDAP_SEARCHBASE, userFilter, this.constraints);
                    }
                    catch (NamingException ce) {
                        log.warn("NamingException inside deleteUser/search ... reconnecting");
                        this.ctx.close();
                        this.ctx = new InitialLdapContext(this.props, null);
                        results = this.ctx.search(this.LDAP_SEARCHBASE, userFilter, this.constraints);
                    }
                }
                if (results.hasMoreElements()) {
                    SearchResult si = results.next();
                    attrs = si.getAttributes();
                    moreMatching = results.hasMoreElements();
                }
            }
            catch (Exception e) {
                log.error("Unable to delete user '" + userId + "'", e);
                throw new UserStoreException("Unable to delete user '" + userId + "'", (Throwable)e);
            }
            if (attrs == null || attrs.size() == 0) {
                throw new UserStoreException("The user '" + userId + "' is not found in the database ");
            }
            if (moreMatching) {
                throw new UserStoreException("More then one user found with " + this.USER_ID + "=" + userId);
            }
            try {
                if (this.REUSE_EXISTING_ONLY) {
                    try {
                        ModificationItem[] toModify = new ModificationItem[this.WASP_PROPS.length + 1];
                        int toModifyLength = 0;
                        int i = 0;
                        while (i < this.WASP_PROPS.length - 1) {
                            String ldapKey = this.wasp2LdapKey(this.WASP_PROPS[i]);
                            Attribute attr = attrs.get(ldapKey);
                            ModificationItem item = null;
                            if (attr != null && attr.size() != 0) {
                                toModify[toModifyLength] = item = new ModificationItem(2, new BasicAttribute(ldapKey));
                                ++toModifyLength;
                            }
                            ++i;
                        }
                        if (!this.USER_ID.equals("cn")) {
                            ModificationItem item;
                            toModify[toModifyLength] = item = new ModificationItem(2, new BasicAttribute(this.USER_ID));
                            ++toModifyLength;
                        }
                        if (toModify.length != toModifyLength) {
                            ModificationItem[] toModify2 = new ModificationItem[toModifyLength];
                            System.arraycopy(toModify, 0, toModify2, 0, toModifyLength);
                            toModify = toModify2;
                        }
                        String ldapName = this.getLDAPName(attrs);
                        Object object = this.contextSync;
                        synchronized (object) {
                            try {
                                this.ctx.modifyAttributes(ldapName, toModify);
                            }
                            catch (NamingException ce) {
                                log.warn("NamingException inside deleteUser/modify method ... reconnecting");
                                this.ctx.close();
                                this.ctx = new InitialLdapContext(this.props, null);
                                this.ctx.modifyAttributes(ldapName, toModify);
                            }
                            break block30;
                        }
                    }
                    catch (Exception e) {
                        if (e instanceof UserStoreException) {
                            throw (UserStoreException)e;
                        }
                        throw new UserStoreException("Cannot modify user properties", (Throwable)e);
                    }
                }
                String ldapName = this.getLDAPName(attrs);
                Object object = this.contextSync;
                synchronized (object) {
                    try {
                        this.ctx.destroySubcontext(ldapName);
                    }
                    catch (NamingException ce) {
                        log.warn("NamingException inside deleteUser/destroySubcontext method ... reconnecting");
                        this.ctx.close();
                        this.ctx = new InitialLdapContext(this.props, null);
                        this.ctx.destroySubcontext(ldapName);
                    }
                }
            }
            catch (Exception e) {
                log.error("Unable to delete user '" + userId + "'", e);
                throw new UserStoreException("Unable to delete user '" + userId + "'", (Throwable)e);
            }
        }
        this.fireDeleteUserAction(userId);
    }

    public boolean hasUser(String userId, Map filter) {
        try {
            Attributes attrs = null;
            boolean moreMatching = false;
            try {
                NamingEnumeration<SearchResult> results;
                String userFilter = this.getUserFilter(userId);
                Object object = this.contextSync;
                synchronized (object) {
                    try {
                        results = this.ctx.search(this.LDAP_SEARCHBASE, userFilter, this.constraints);
                    }
                    catch (NamingException ce) {
                        log.warn("NamingException inside hasUser/search ... reconnecting");
                        this.ctx.close();
                        this.ctx = new InitialLdapContext(this.props, null);
                        results = this.ctx.search(this.LDAP_SEARCHBASE, userFilter, this.constraints);
                    }
                }
                if (results.hasMoreElements()) {
                    SearchResult si = results.next();
                    attrs = si.getAttributes();
                    moreMatching = results.hasMore();
                }
            }
            catch (Exception e) {
                log.error("Unable to get user attributes for '" + userId + "'", e);
                throw new UserStoreException("Unable to get user property '" + userId + "'", (Throwable)e);
            }
            if (attrs == null || attrs.size() == 0) {
                throw new UserStoreException("The user '" + userId + "' is not found in the database ");
            }
            if (moreMatching) {
                throw new UserStoreException("More then one user found with " + this.USER_ID + "=" + userId);
            }
            return this.isAttributeMatch(attrs, filter);
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected boolean isAttributeMatch(Attributes attrs, Map filter) throws NamingException {
        if (filter == null) {
            return true;
        }
        Iterator requested = filter.entrySet().iterator();
        while (requested.hasNext()) {
            Map.Entry entry = requested.next();
            Attribute attr = attrs.get(this.wasp2LdapKey(entry.getKey()));
            if (attr == null || attr.size() == 0) {
                return false;
            }
            if (entry.getValue() == null) continue;
            Object value = attr.get();
            if (value instanceof byte[]) {
                value = this.deserialize(entry.getKey().toString(), value);
            }
            if (value instanceof Object[]) {
                if (!(entry.getValue() instanceof Object[])) {
                    return false;
                }
                Object[] myAr = (Object[])value;
                Object[] given = (Object[])entry.getValue();
                if (given.length != myAr.length) {
                    return false;
                }
                int i = 0;
                while (i < myAr.length) {
                    if (given[i] != null && myAr[i] != null) {
                        if (!myAr[i].equals(given[i])) {
                            return false;
                        }
                    } else {
                        return false;
                    }
                    ++i;
                }
                continue;
            }
            if (value.equals(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public Map getUserProperties(String userId) throws UserStoreException {
        Attributes attrs = null;
        boolean moreMatching = false;
        try {
            NamingEnumeration<SearchResult> results;
            String userFilter = this.getUserFilter(userId);
            Object object = this.contextSync;
            synchronized (object) {
                try {
                    results = this.ctx.search(this.LDAP_SEARCHBASE, userFilter, this.constraints);
                }
                catch (NamingException ce) {
                    log.warn("NamingException inside getUserProperties/search ... reconnecting");
                    this.ctx.close();
                    this.ctx = new InitialLdapContext(this.props, null);
                    results = this.ctx.search(this.LDAP_SEARCHBASE, userFilter, this.constraints);
                }
            }
            if (results.hasMore()) {
                SearchResult si = results.next();
                attrs = si.getAttributes();
                moreMatching = results.hasMore();
            }
        }
        catch (Exception e) {
            log.error("Unable to get user properties for '" + userId + "'", e);
            throw new UserStoreException("Unable to get user properties for '" + userId + "'", (Throwable)e);
        }
        if (attrs == null || attrs.size() == 0) {
            throw new UserStoreException("The user '" + userId + "' is not found in the database ");
        }
        if (moreMatching) {
            throw new UserStoreException("More then one user found with " + this.USER_ID + "=" + userId);
        }
        try {
            HashMap<String, Object> map = new HashMap<String, Object>(this.WASP_PROPS.length + 2);
            int i = 0;
            while (i < this.WASP_PROPS.length) {
                Attribute attr = attrs.get(this.wasp2LdapKey(this.WASP_PROPS[i]));
                if (attr != null && attr.size() != 0) {
                    map.put(this.WASP_PROPS[i], this.deserialize(this.WASP_PROPS[i], attr.get()));
                }
                ++i;
            }
            return Collections.unmodifiableMap(map);
        }
        catch (Exception e) {
            if (e instanceof UserStoreException) {
                throw (UserStoreException)e.fillInStackTrace();
            }
            throw new UserStoreException("Cannot get user property", (Throwable)e);
        }
    }

    protected Object deserialize(String propertyKey, Object value) throws UserStoreException {
        PropertySerializer ps = this.getPropertySerializer(propertyKey);
        if (ps == null) {
            throw new UserStoreException("Unable to deserialize '" + propertyKey + "' property!");
        }
        return ps.decode((byte[])value);
    }

    protected Object serialize(String propertyKey, Object value) throws UserStoreException {
        PropertySerializer ps = this.getPropertySerializer(propertyKey);
        if (ps == null) {
            throw new UserStoreException("Unable to serialize '" + propertyKey + "' property!");
        }
        return ps.encode(value);
    }

    public Object getUserProperty(String userId, String key) throws UserStoreException {
        Attributes attrs = null;
        boolean moreMatching = false;
        try {
            NamingEnumeration<SearchResult> results;
            String userFilter = this.getUserFilter(userId);
            Object object = this.contextSync;
            synchronized (object) {
                try {
                    results = this.ctx.search(this.LDAP_SEARCHBASE, userFilter, this.constraints);
                }
                catch (NamingException ce) {
                    log.warn("NamingException inside getUserProperty/search ... reconnecting");
                    this.ctx.close();
                    this.ctx = new InitialLdapContext(this.props, null);
                    results = this.ctx.search(this.LDAP_SEARCHBASE, userFilter, this.constraints);
                }
            }
            if (results.hasMore()) {
                SearchResult si = results.next();
                attrs = si.getAttributes();
                moreMatching = results.hasMore();
            }
        }
        catch (Exception e) {
            log.error("Unable to get user property for '" + userId + "'", e);
            throw new UserStoreException("Unable to get user property for '" + userId + "'", (Throwable)e);
        }
        if (attrs == null || attrs.size() == 0) {
            throw new UserStoreException("The user '" + userId + "' is not found in the database ");
        }
        if (moreMatching) {
            throw new UserStoreException("More then one user found with " + this.USER_ID + "=" + userId);
        }
        try {
            Attribute attr = attrs.get(this.wasp2LdapKey(key));
            if (attr != null && attr.size() != 0) {
                return this.deserialize(key, attr.get());
            }
            return null;
        }
        catch (Exception e) {
            if (e instanceof UserStoreException) {
                throw (UserStoreException)e.fillInStackTrace();
            }
            throw new UserStoreException("Cannot get user property", (Throwable)e);
        }
    }

    public void removeUserProperty(String userId, String key) throws UserStoreException {
        Attributes attrs = null;
        boolean moreMatching = false;
        try {
            NamingEnumeration<SearchResult> results;
            String userFilter = this.getUserFilter(userId);
            Object object = this.contextSync;
            synchronized (object) {
                try {
                    results = this.ctx.search(this.LDAP_SEARCHBASE, userFilter, this.constraints);
                }
                catch (NamingException ce) {
                    log.warn("NamingException inside removeUserProperty/search ... reconnecting");
                    this.ctx.close();
                    this.ctx = new InitialLdapContext(this.props, null);
                    results = this.ctx.search(this.LDAP_SEARCHBASE, userFilter, this.constraints);
                }
            }
            if (results.hasMore()) {
                SearchResult si = results.next();
                attrs = si.getAttributes();
                moreMatching = results.hasMore();
            }
        }
        catch (Exception e) {
            log.error("Unable to remove user property for '" + userId + "'", e);
            throw new UserStoreException("Unable to remove user property for '" + userId + "'", (Throwable)e);
        }
        if (attrs == null || attrs.size() == 0) {
            throw new UserStoreException("The user '" + userId + "' is not found in the database ");
        }
        if (moreMatching) {
            throw new UserStoreException("More then one user found with " + this.USER_ID + "=" + userId);
        }
        try {
            String toRemove = this.wasp2LdapKey(key);
            Attribute attr = attrs.get(toRemove);
            if (attr != null && attr.size() == 0) {
                return;
            }
            ModificationItem[] toModify = new ModificationItem[1];
            toModify[0] = new ModificationItem(2, new BasicAttribute(toRemove));
            String ldapName = this.getLDAPName(attrs);
            Object object = this.contextSync;
            synchronized (object) {
                try {
                    this.ctx.modifyAttributes(ldapName, toModify);
                }
                catch (NamingException ce) {
                    log.warn("NamingException inside removeUserProperty/modifyAttributes ... reconnecting");
                    this.ctx.close();
                    this.ctx = new InitialLdapContext(this.props, null);
                    this.ctx.modifyAttributes(ldapName, toModify);
                }
            }
        }
        catch (Exception e) {
            if (e instanceof UserStoreException) {
                throw (UserStoreException)e.fillInStackTrace();
            }
            throw new UserStoreException("Cannot remove user property", (Throwable)e);
        }
    }

    public void setUserProperties(String userId, Map properties) throws UserStoreException {
        block40: {
            String ldapName;
            Object val;
            if (properties == null) {
                properties = EMPTY_MAP;
            }
            Attributes attrs = null;
            boolean moreMatching = false;
            try {
                NamingEnumeration<SearchResult> results;
                String userFilter = this.getUserFilter(userId);
                Object object = this.contextSync;
                synchronized (object) {
                    try {
                        results = this.ctx.search(this.LDAP_SEARCHBASE, userFilter, this.constraints);
                    }
                    catch (NamingException ce) {
                        log.warn("NamingException inside setUserProperties/search ... reconnecting");
                        this.ctx.close();
                        this.ctx = new InitialLdapContext(this.props, null);
                        results = this.ctx.search(this.LDAP_SEARCHBASE, userFilter, this.constraints);
                    }
                }
                if (results.hasMore()) {
                    SearchResult si = results.next();
                    attrs = si.getAttributes();
                    moreMatching = results.hasMore();
                }
            }
            catch (Exception e) {
                log.error("Unable to set user properties for '" + userId + "'", e);
                throw new UserStoreException("Unable to set user properties for '" + userId + "'", (Throwable)e);
            }
            if (moreMatching) {
                throw new UserStoreException("More then one user found with " + this.USER_ID + "=" + userId);
            }
            if (attrs == null || attrs.size() == 0) {
                if (this.REUSE_EXISTING_ONLY) {
                    throw new UserStoreException("LDAP User Store is only configured to reuse your LDAP data");
                }
                BasicAttributes battrs = new BasicAttributes();
                BasicAttribute objClasses = new BasicAttribute("objectclass");
                objClasses.add("top");
                objClasses.add("person");
                objClasses.add("organizationalPerson");
                objClasses.add("inetOrgPerson");
                battrs.put(objClasses);
                if (properties.get(DEFAULT_SN_KEY) == null) {
                    battrs.put(new BasicAttribute("sn", this.DEFAULT_SN));
                } else {
                    battrs.put(new BasicAttribute("sn", properties.get(DEFAULT_SN_KEY).toString()));
                }
                int i = 0;
                while (i < this.WASP_PROPS.length) {
                    val = properties.get(this.WASP_PROPS[i]);
                    if (val != null) {
                        battrs.put(new BasicAttribute(this.wasp2LdapKey(this.WASP_PROPS[i]), this.serialize(this.WASP_PROPS[i], val)));
                    }
                    ++i;
                }
                battrs.put(new BasicAttribute(this.USER_ID, userId));
                if (!this.USER_ID.equals("cn") && battrs.get("cn") == null) {
                    if (this.DEFAULT_CN == null) {
                        battrs.put(new BasicAttribute("cn", userId));
                    } else {
                        battrs.put(new BasicAttribute("cn", userId + this.DEFAULT_CN));
                    }
                }
                try {
                    ldapName = this.getLDAPName(battrs);
                    Object object = this.contextSync;
                    synchronized (object) {
                        try {
                            this.ctx.createSubcontext(ldapName, (Attributes)battrs);
                        }
                        catch (NamingException ce) {
                            log.warn("NamingException inside setUserProperties/createSubcontext ... reconnecting");
                            this.ctx.close();
                            this.ctx = new InitialLdapContext(this.props, null);
                            this.ctx.createSubcontext(ldapName, (Attributes)battrs);
                        }
                        break block40;
                    }
                }
                catch (Exception e) {
                    if (e instanceof UserStoreException) {
                        throw (UserStoreException)e.fillInStackTrace();
                    }
                    throw new UserStoreException("Cannot create user with specified properties", (Throwable)e);
                }
            }
            try {
                ModificationItem[] toModify = new ModificationItem[this.WASP_PROPS.length];
                int toModifyLength = 0;
                int i = 0;
                while (i < this.WASP_PROPS.length) {
                    ModificationItem item;
                    Attribute attr;
                    String ldapKey;
                    val = properties.get(this.WASP_PROPS[i]);
                    if (val != null) {
                        ldapKey = this.wasp2LdapKey(this.WASP_PROPS[i]);
                        attr = attrs.get(ldapKey);
                        item = null;
                        item = attr != null && attr.size() != 0 ? new ModificationItem(2, new BasicAttribute(ldapKey, this.serialize(this.WASP_PROPS[i], val))) : new ModificationItem(1, new BasicAttribute(ldapKey, this.serialize(this.WASP_PROPS[i], val)));
                        toModify[toModifyLength] = item;
                        ++toModifyLength;
                    } else {
                        ldapKey = this.wasp2LdapKey(this.WASP_PROPS[i]);
                        attr = attrs.get(ldapKey);
                        item = null;
                        if (attr != null && attr.size() != 0) {
                            toModify[toModifyLength] = item = new ModificationItem(2, new BasicAttribute(ldapKey));
                            ++toModifyLength;
                        }
                    }
                    ++i;
                }
                if (toModify.length != toModifyLength) {
                    ModificationItem[] toModify2 = new ModificationItem[toModifyLength];
                    System.arraycopy(toModify, 0, toModify2, 0, toModifyLength);
                    toModify = toModify2;
                }
                ldapName = this.getLDAPName(attrs);
                Object object = this.contextSync;
                synchronized (object) {
                    try {
                        this.ctx.modifyAttributes(ldapName, toModify);
                    }
                    catch (NamingException ce) {
                        log.warn("NamingException inside setUserProperties/modifyAttributes ... reconnecting");
                        this.ctx.close();
                        this.ctx = new InitialLdapContext(this.props, null);
                        this.ctx.modifyAttributes(ldapName, toModify);
                    }
                }
            }
            catch (Exception e) {
                if (e instanceof UserStoreException) {
                    throw (UserStoreException)e;
                }
                throw new UserStoreException("Cannot modify user properties", (Throwable)e);
            }
        }
    }

    public void setUserProperty(String userId, String key, Object value) throws UserStoreException {
        block32: {
            Object si;
            Attributes attrs = null;
            boolean moreMatching = false;
            try {
                NamingEnumeration<SearchResult> results;
                String userFilter = this.getUserFilter(userId);
                Object object = this.contextSync;
                synchronized (object) {
                    try {
                        results = this.ctx.search(this.LDAP_SEARCHBASE, userFilter, this.constraints);
                    }
                    catch (NamingException ce) {
                        log.warn("NamingException inside setUserProperty/search ... reconnecting");
                        this.ctx.close();
                        this.ctx = new InitialLdapContext(this.props, null);
                        results = this.ctx.search(this.LDAP_SEARCHBASE, userFilter, this.constraints);
                    }
                }
                if (results.hasMore()) {
                    si = results.next();
                    attrs = ((SearchResult)si).getAttributes();
                    moreMatching = results.hasMore();
                }
            }
            catch (Exception e) {
                log.error("Unable to set user property for '" + userId + "'", e);
                throw new UserStoreException("Unable to set user property for '" + userId + "'", (Throwable)e);
            }
            if (moreMatching) {
                throw new UserStoreException("More then one user found with " + this.USER_ID + "=" + userId);
            }
            if (attrs == null || attrs.size() == 0) {
                if (this.REUSE_EXISTING_ONLY) {
                    throw new UserStoreException("LDAP User Store is only configured to reuse your LDAP data");
                }
                BasicAttributes battrs = new BasicAttributes();
                BasicAttribute objClasses = new BasicAttribute("objectclass");
                objClasses.add("top");
                objClasses.add("person");
                objClasses.add("organizationalPerson");
                objClasses.add("inetOrgPerson");
                battrs.put(objClasses);
                if (key.equals(DEFAULT_SN_KEY)) {
                    battrs.put(new BasicAttribute("sn", value.toString()));
                } else {
                    battrs.put(new BasicAttribute("sn", this.DEFAULT_SN));
                    battrs.put(new BasicAttribute(this.wasp2LdapKey(key), this.serialize(key, value)));
                }
                battrs.put(new BasicAttribute(this.USER_ID, userId));
                if (!key.equals("cn") && !this.USER_ID.equals("cn")) {
                    if (this.DEFAULT_CN == null) {
                        battrs.put(new BasicAttribute("cn", userId));
                    } else {
                        battrs.put(new BasicAttribute("cn", userId + this.DEFAULT_CN));
                    }
                }
                try {
                    String ldapName = this.getLDAPName(battrs);
                    si = this.contextSync;
                    synchronized (si) {
                        try {
                            this.ctx.createSubcontext(ldapName, (Attributes)battrs);
                        }
                        catch (NamingException ce) {
                            log.warn("NamingException inside setUserProperty/createSubcontext ... reconnecting");
                            this.ctx.close();
                            this.ctx = new InitialLdapContext(this.props, null);
                            this.ctx.createSubcontext(ldapName, (Attributes)battrs);
                        }
                        break block32;
                    }
                }
                catch (Exception e) {
                    if (e instanceof UserStoreException) {
                        throw (UserStoreException)e.fillInStackTrace();
                    }
                    throw new UserStoreException("Cannot create user with specified properties", (Throwable)e);
                }
            }
            try {
                ModificationItem[] toModify = new ModificationItem[1];
                String ldapKey = this.wasp2LdapKey(key);
                Attribute attr = attrs.get(ldapKey);
                ModificationItem item = null;
                item = attr != null && attr.size() != 0 ? new ModificationItem(2, new BasicAttribute(ldapKey, this.serialize(key, value))) : new ModificationItem(1, new BasicAttribute(ldapKey, this.serialize(key, value)));
                toModify[0] = item;
                String ldapName = this.getLDAPName(attrs);
                Object object = this.contextSync;
                synchronized (object) {
                    try {
                        this.ctx.modifyAttributes(ldapName, toModify);
                    }
                    catch (NamingException ce) {
                        log.warn("NamingException inside setUserProperty/modifyAttributes ... reconnecting");
                        this.ctx.close();
                        this.ctx = new InitialLdapContext(this.props, null);
                        this.ctx.modifyAttributes(ldapName, toModify);
                    }
                }
            }
            catch (Exception e) {
                if (e instanceof UserStoreException) {
                    throw (UserStoreException)e.fillInStackTrace();
                }
                throw new UserStoreException("Cannot modify user properties", (Throwable)e);
            }
        }
    }

    public UserIterator getUsers() {
        try {
            NamingEnumeration<SearchResult> results;
            String[] LDAP_PROPS = new String[this.WASP_PROPS.length + 1];
            int i = 0;
            while (i < this.WASP_PROPS.length) {
                String ldapKey;
                LDAP_PROPS[i] = ldapKey = this.wasp2LdapKey(this.WASP_PROPS[i]);
                ++i;
            }
            LDAP_PROPS[LDAP_PROPS.length - 1] = this.USER_ID;
            Object object = this.contextSync;
            synchronized (object) {
                try {
                    results = this.ctx.search(this.LDAP_SEARCHBASE, this.searchFilter, this.constraints);
                }
                catch (NamingException ce) {
                    log.warn("NamingException inside getUsers/search ... reconnecting");
                    this.ctx.close();
                    this.ctx = new InitialLdapContext(this.props, null);
                    results = this.ctx.search(this.LDAP_SEARCHBASE, this.searchFilter, this.constraints);
                }
            }
            return new LDAPUserIterator(results, LDAP_PROPS, (String[])this.WASP_PROPS.clone());
        }
        catch (Exception e) {
            log.error("Unable to search users", e);
            throw new UserStoreException("Unable to search users", (Throwable)e);
        }
    }

    public String[] getUserIds() {
        try {
            NamingEnumeration<SearchResult> results;
            Object object = this.contextSync;
            synchronized (object) {
                try {
                    results = this.ctx.search(this.LDAP_SEARCHBASE, this.searchFilter, this.constraints);
                }
                catch (NamingException ce) {
                    log.warn("NamingException inside getUserIds/search ... reconnecting");
                    this.ctx.close();
                    this.ctx = new InitialLdapContext(this.props, null);
                    results = this.ctx.search(this.LDAP_SEARCHBASE, this.searchFilter, this.constraints);
                }
            }
            String[] retVal = new String[20];
            int i = 0;
            while (results.hasMore()) {
                SearchResult si = results.next();
                Attributes attrs = si.getAttributes();
                Attribute attr = attrs.get(this.USER_ID);
                if (attr == null || attr.size() <= 0) continue;
                if (i == retVal.length) {
                    String[] newVal = new String[retVal.length * 2];
                    System.arraycopy(retVal, 0, newVal, 0, retVal.length);
                    retVal = newVal;
                }
                retVal[i] = attr.get().toString();
                ++i;
            }
            if (i != retVal.length) {
                String[] newVal = new String[i];
                System.arraycopy(retVal, 0, newVal, 0, i);
                retVal = newVal;
            }
            return retVal;
        }
        catch (Exception e) {
            log.error("Unable to search users", e);
            throw new UserStoreException("Unable to search users", (Throwable)e);
        }
    }

    public UserIterator getUsers(Map filter) {
        if (filter == null) {
            return this.getUsers();
        }
        try {
            NamingEnumeration<SearchResult> results;
            Object object = this.contextSync;
            synchronized (object) {
                try {
                    results = this.ctx.search(this.LDAP_SEARCHBASE, this.searchFilter, this.constraints);
                }
                catch (NamingException ce) {
                    log.warn("NamingException inside getUsers/search ... reconnecting");
                    this.ctx.close();
                    this.ctx = new InitialLdapContext(this.props, null);
                    results = this.ctx.search(this.LDAP_SEARCHBASE, this.searchFilter, this.constraints);
                }
            }
            String[] LDAP_PROPS = new String[this.WASP_PROPS.length + 1];
            int i = 0;
            while (i < this.WASP_PROPS.length) {
                String ldapKey;
                LDAP_PROPS[i] = ldapKey = this.wasp2LdapKey(this.WASP_PROPS[i]);
                ++i;
            }
            LDAP_PROPS[LDAP_PROPS.length - 1] = this.USER_ID;
            return new LDAPUserIterator(results, LDAP_PROPS, (String[])this.WASP_PROPS.clone(), filter);
        }
        catch (Exception e) {
            log.error("Unable to search users", e);
            throw new UserStoreException("Unable to search users", (Throwable)e);
        }
    }

    public void setUserStoreSource(UserStoreSource source) {
    }

    public void setPropertySerializer(String propertyKey, PropertySerializer serializer) throws UserStoreException {
        if (this.getPropertySerializer(propertyKey) != null) {
            throw new UserStoreException("Serializer already set!");
        }
        propertySerializers.put(propertyKey, serializer);
    }

    public PropertySerializer getPropertySerializer(String propertyKey) throws UserStoreException {
        return (PropertySerializer)propertySerializers.get(propertyKey);
    }

    public Iterator getSupportedAttributes() {
        return Collections.unmodifiableSet(propertySerializers.keySet()).iterator();
    }

    public void destroy() {
        try {
            if (this.ctx != null) {
                log.debug("Destroying LDAP context...");
                this.ctx.close();
            }
        }
        catch (NamingException e) {
            log.error("Error while destroying LDAP context.", e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class LDAPUserEntry
    implements UserEntry {
        Map props = new HashMap();
        String userId = "";

        private LDAPUserEntry() {
        }

        public String getUserId() {
            return this.userId;
        }

        public Map getProperties() {
            return this.props;
        }

        public Object getProperty(String key) {
            return this.props.get(key);
        }

        public String toString() {
            StringBuffer retVal = new StringBuffer();
            retVal.append("userId:");
            retVal.append(this.userId);
            retVal.append('\n');
            Iterator iter = this.props.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                retVal.append(entry.getKey());
                retVal.append(": ");
                retVal.append(entry.getValue());
                retVal.append('\n');
            }
            return retVal.toString();
        }
    }

    private class LDAPUserIterator
    implements UserIterator {
        private Enumeration results;
        private String[] LDAP_ATTRS;
        private String[] WASP_ATTRS;
        private Map filter = null;
        LDAPUserEntry toRet = null;
        boolean checkStart = false;
        boolean checkEnd = false;
        String pureFilterString = null;

        LDAPUserIterator(Enumeration results, String[] LDAP_ATTRS, String[] WASP_ATTRS) throws UserStoreException {
            this.LDAP_ATTRS = LDAP_ATTRS;
            this.WASP_ATTRS = WASP_ATTRS;
            this.results = results;
            this.filter = null;
            this.initNext();
        }

        LDAPUserIterator(Enumeration results, String[] LDAP_ATTRS, String[] WASP_ATTRS, Map filter) throws UserStoreException {
            this.LDAP_ATTRS = LDAP_ATTRS;
            this.WASP_ATTRS = WASP_ATTRS;
            this.results = results;
            this.filter = filter;
            this.filter = filter.isEmpty() ? null : filter;
            this.pureFilterString = (String)filter.get("FILTER_STRING");
            if (this.pureFilterString != null) {
                HashMap newFilter = new HashMap(filter);
                newFilter.remove("FILTER_STRING");
                this.filter = newFilter;
                if (this.pureFilterString.startsWith("*")) {
                    this.pureFilterString = this.pureFilterString.substring(1);
                    this.checkEnd = true;
                }
                if (this.pureFilterString.length() == 0) {
                    this.pureFilterString = null;
                } else if (this.pureFilterString.endsWith("*")) {
                    this.checkStart = true;
                    this.pureFilterString = this.pureFilterString.substring(0, this.pureFilterString.length() - 1);
                } else {
                    boolean bl = this.checkStart = !this.checkEnd;
                }
            }
            if (this.results != null) {
                this.initNext();
            }
        }

        private void initNext() throws UserStoreException {
            if (this.results.hasMoreElements()) {
                Attribute attr;
                Attributes attrs;
                block14: {
                    SearchResult si = (SearchResult)this.results.nextElement();
                    attrs = si.getAttributes();
                    this.toRet = null;
                    if (this.filter != null) {
                        while (true) {
                            block13: {
                                try {
                                    if (this.pureFilterString != null && !LdapUserStore.super.match((attr = attrs.get(LdapUserStore.this.USER_ID)).get().toString(), this.pureFilterString, this.checkStart, this.checkEnd) || !LdapUserStore.this.isAttributeMatch(attrs, this.filter)) break block13;
                                    this.toRet = new LDAPUserEntry();
                                    break block14;
                                }
                                catch (NamingException ne) {
                                    throw new UserStoreException("Unable to compare attribute values", (Throwable)ne);
                                }
                            }
                            if (!this.results.hasMoreElements()) break;
                            si = (SearchResult)this.results.nextElement();
                            attrs = si.getAttributes();
                        }
                        return;
                    }
                    this.toRet = new LDAPUserEntry();
                }
                if (this.toRet != null) {
                    try {
                        attr = attrs.get(LdapUserStore.this.USER_ID);
                        this.toRet.userId = attr.get().toString();
                        int i = 0;
                        while (i < this.WASP_ATTRS.length) {
                            Object value;
                            attr = attrs.get(this.LDAP_ATTRS[i]);
                            if (attr != null && attr.size() > 0 && (value = attr.get()) != null) {
                                if (value instanceof byte[]) {
                                    this.toRet.props.put(this.WASP_ATTRS[i], LdapUserStore.this.deserialize(this.WASP_ATTRS[i], value));
                                } else {
                                    this.toRet.props.put(this.WASP_ATTRS[i], value);
                                }
                            }
                            ++i;
                        }
                    }
                    catch (Exception e) {
                        this.toRet = null;
                        log.error("Unable perform next operation", e);
                        throw new UserStoreException("Unable perform next operation", (Throwable)e);
                    }
                }
            } else {
                this.toRet = null;
            }
        }

        public boolean hasNext() {
            try {
                return this.toRet != null;
            }
            catch (Exception e) {
                log.error("Unable perform hasMore operation", e);
                throw new UserStoreException("Unable perform hasMore operation", (Throwable)e);
            }
        }

        public UserEntry next() throws NoSuchElementException {
            if (this.toRet == null) {
                throw new NoSuchElementException();
            }
            LDAPUserEntry retVal = this.toRet;
            this.initNext();
            return retVal;
        }
    }
}

