/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.security.pstore;

import com.idoox.debug.Category;
import com.idoox.security.pstore.KeyStoreImpl;
import com.idoox.security.pstore.UserStoreImpl;
import org.idoox.security.pstore.AbstractUserStore;
import org.idoox.security.pstore.BadPasswordException;
import org.idoox.security.pstore.KeyStore;
import org.idoox.security.pstore.KeyStoreSource;
import org.idoox.security.pstore.PStore;
import org.idoox.security.pstore.UserStore;
import org.idoox.security.pstore.UserStoreSource;
import org.idoox.security.util.RuntimeWrappedException;

public class PStoreImpl
extends PStore {
    private static final Category cat = Category.getCategory((class$com$idoox$security$pstore$PStoreImpl == null ? (class$com$idoox$security$pstore$PStoreImpl = PStoreImpl.class$("com.idoox.security.pstore.PStoreImpl")) : class$com$idoox$security$pstore$PStoreImpl).getName());
    private KeyStoreSource keySource = null;
    private UserStoreSource userSource = null;
    private KeyStore keyStore;
    private UserStore userStore;
    private String password = null;
    static /* synthetic */ Class class$com$idoox$security$pstore$PStoreImpl;

    public PStoreImpl(String password) throws BadPasswordException {
        super(password);
        try {
            KeyStoreSource keySource = null;
            UserStoreSource userSource = null;
            this.keyStore = PStore.getKeyStore(password);
            if (this.keyStore == null) {
                this.keyStore = new KeyStoreImpl();
                keySource = PStore.getKeyStoreSource();
            }
            this.userStore = PStore.getUserStore(password);
            if (this.userStore == null) {
                this.userStore = new UserStoreImpl();
                userSource = PStore.getUserStoreSource();
            }
            this.init(password, keySource, userSource);
        }
        catch (Exception e) {
            if (e instanceof BadPasswordException) {
                throw (BadPasswordException)e.fillInStackTrace();
            }
            throw new RuntimeWrappedException("Cannot create default protected store provider", (Throwable)e);
        }
    }

    public PStoreImpl(String password, KeyStoreSource keySource, UserStoreSource userSource) throws BadPasswordException {
        super(password);
        this.keyStore = new KeyStoreImpl();
        this.userStore = new UserStoreImpl();
        this.init(password, keySource, userSource);
    }

    private void init(String password, KeyStoreSource keySource, UserStoreSource userSource) throws BadPasswordException {
        this.keySource = keySource;
        this.userSource = userSource;
        this.password = password;
        this.keyStore.setKeyStoreSoure(keySource);
        this.userStore.setUserStoreSource(userSource);
        this.load();
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public UserStore getUserStore() {
        return this.userStore;
    }

    public void load() throws BadPasswordException {
        if (this.keySource != null) {
            this.keySource.load(this.keyStore, this.password);
        }
        PStore.registerAdditionalPropertySerializers(this.userStore);
        if (this.userSource != null) {
            this.userSource.load(this.userStore, this.password);
        }
    }

    public void destroy() {
        UserStore userStore = this.getUserStore();
        if (userStore instanceof AbstractUserStore) {
            ((AbstractUserStore)userStore).destroy();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

