/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.security.pstore;

import com.idoox.security.pstore.AliasEntryImpl;
import com.idoox.security.pstore.KeyEntryImpl;
import com.idoox.security.pstore.KeyEntryManager;
import java.security.Key;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.idoox.security.pstore.AliasEntry;
import org.idoox.security.pstore.BadPasswordException;
import org.idoox.security.pstore.KeyEntry;
import org.idoox.security.pstore.KeyStore;
import org.idoox.security.pstore.KeyStoreException;
import org.idoox.security.pstore.KeyStoreSource;

public class KeyStoreImpl
implements KeyStore {
    private Map keys = Collections.synchronizedMap(new HashMap());
    private KeyStoreSource source = null;

    public KeyStoreImpl() {
    }

    public KeyStoreImpl(String password) {
    }

    public boolean containsAlias(String alias) {
        return this.keys.containsKey(alias);
    }

    public void deleteEntry(String alias) throws KeyStoreException {
        this.keys.remove(alias);
        if (this.source != null) {
            KeyStoreSource keyStoreSource = this.source;
            synchronized (keyStoreSource) {
                this.source.deleteKey(alias);
            }
        }
    }

    public Certificate[] getCertificateChain(String alias) throws KeyStoreException {
        this.checkAlias(alias);
        KeyEntry entry = this.getKeyEntry(alias);
        if (entry == null) {
            return null;
        }
        return entry.getCertificateChain();
    }

    private void checkAlias(String alias) throws KeyStoreException {
        if (!this.containsAlias(alias)) {
            throw new KeyStoreException("alias " + alias + " doesn't exist.");
        }
    }

    public String getAlias(Certificate cert) {
        Iterator it = this.keys.keySet().iterator();
        while (it.hasNext()) {
            String alias = (String)it.next();
            Certificate[] certs = ((KeyEntry)this.keys.get(alias)).getCertificateChain();
            if (certs == null) continue;
            int i = 0;
            while (i < certs.length) {
                if (certs[i] != null && certs[i].equals(cert)) {
                    return alias;
                }
                ++i;
            }
        }
        return null;
    }

    public String[] getAliases() {
        String[] aliases = new String[this.keys.size()];
        this.keys.keySet().toArray(aliases);
        return aliases;
    }

    public AliasEntry[] getAliasEntries() {
        Set set = this.keys.entrySet();
        AliasEntry[] retVal = new AliasEntry[set.size()];
        Iterator iter = set.iterator();
        int vals = 0;
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (entry == null) continue;
            AliasEntryImpl val = new AliasEntryImpl(entry.getKey().toString(), (KeyEntryImpl)entry.getValue());
            retVal[vals] = val;
            ++vals;
        }
        if (vals != retVal.length) {
            AliasEntry[] newVal = new AliasEntry[vals];
            System.arraycopy(retVal, 0, newVal, 0, vals);
            retVal = newVal;
        }
        return retVal;
    }

    public Key getKey(String alias, String password) throws BadPasswordException, KeyStoreException {
        this.checkAlias(alias);
        KeyEntry entry = this.getKeyEntry(alias);
        if (entry == null) {
            return null;
        }
        return KeyEntryManager.getKey(entry, password);
    }

    public boolean isKeyEntry(String alias) {
        if (!this.keys.containsKey(alias)) {
            return false;
        }
        KeyEntry entry = (KeyEntry)this.keys.get(alias);
        if (entry == null) {
            return false;
        }
        return KeyEntryManager.isKeyEntry(entry);
    }

    public void setCertificateEntry(String alias, Certificate[] chain) throws BadPasswordException, KeyStoreException {
        KeyEntry newEntry = KeyEntryManager.modifyEntry((KeyEntry)this.keys.get(alias), chain);
        this.setKeyEntry(alias, newEntry);
    }

    private void editKey(String alias, KeyEntry entry) throws KeyStoreException, BadPasswordException {
        if (this.source == null) {
            return;
        }
        KeyStoreSource keyStoreSource = this.source;
        synchronized (keyStoreSource) {
            this.source.editKey(alias, entry);
        }
    }

    private void addKey(String alias, KeyEntry entry) throws KeyStoreException, BadPasswordException {
        if (this.source == null) {
            return;
        }
        KeyStoreSource keyStoreSource = this.source;
        synchronized (keyStoreSource) {
            this.source.addKey(alias, entry);
        }
    }

    public KeyEntry getKeyEntry(String alias) throws KeyStoreException {
        this.checkAlias(alias);
        return (KeyEntry)this.keys.get(alias);
    }

    public void setKeyEntry(String alias, String password, Key key, Certificate[] chain) throws BadPasswordException, KeyStoreException {
        KeyEntry newEntry = KeyEntryManager.modifyEntry((KeyEntry)this.keys.get(alias), password, key, chain);
        this.setKeyEntry(alias, newEntry);
    }

    private void setKeyEntry(String alias, KeyEntry entry) throws BadPasswordException, KeyStoreException {
        boolean toModify = false;
        if (this.keys.containsKey(alias)) {
            toModify = true;
        }
        this.keys.put(alias, entry);
        if (toModify) {
            this.editKey(alias, entry);
        } else {
            this.addKey(alias, entry);
        }
    }

    public void setKeyEntry(String alias, byte[] encKey, byte[] keyAlg, byte[] keyFormat, byte[] salt, Certificate[] chain) throws BadPasswordException, KeyStoreException {
        KeyEntry newEntry = KeyEntryManager.modifyEntry((KeyEntry)this.keys.get(alias), encKey, keyAlg, keyFormat, salt, chain);
        this.setKeyEntry(alias, newEntry);
    }

    public void setKeyStoreSoure(KeyStoreSource source) {
        this.source = source;
    }
}

