/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.security.pstore;

import com.idoox.security.pstore.CryptoTool;
import com.idoox.security.pstore.KeyEntryImpl;
import java.security.Key;
import java.security.cert.Certificate;
import org.idoox.security.pstore.BadPasswordException;
import org.idoox.security.pstore.KeyEntry;

class KeyEntryManager {
    KeyEntryManager() {
    }

    public static KeyEntry modifyEntry(KeyEntry keyEntry, Certificate[] certChain) {
        KeyEntryImpl.Data data = KeyEntryManager.getKeyData(keyEntry);
        data.certChain = certChain;
        return new KeyEntryImpl(data);
    }

    public static KeyEntry modifyEntry(KeyEntry keyEntry, String password, Key key, Certificate[] chain) {
        KeyEntryImpl.Data data = KeyEntryManager.getKeyData(keyEntry);
        CryptoTool.modifyKeyData(data, key, password, chain);
        return new KeyEntryImpl(data);
    }

    public static KeyEntry modifyEntry(KeyEntry keyEntry, byte[] encKey, byte[] keyAlg, byte[] keyFormat, byte[] salt, Certificate[] chain) {
        KeyEntryImpl.Data data = KeyEntryManager.getKeyData(keyEntry);
        data.encodedKey = encKey;
        data.algorithm = keyAlg;
        data.format = keyFormat;
        data.salt = salt;
        data.certChain = chain;
        return new KeyEntryImpl(data);
    }

    public static KeyEntryImpl.Data getKeyData(KeyEntry keyEntry) {
        KeyEntryImpl.Data data = new KeyEntryImpl.Data();
        if (keyEntry != null) {
            data.algorithm = keyEntry.getAlgorithm();
            data.encodedKey = keyEntry.getEncodedKey();
            data.format = keyEntry.getFormat();
            data.salt = keyEntry.getSalt();
            data.certChain = keyEntry.getCertificateChain();
        }
        return data;
    }

    public static Key getKey(KeyEntry keyEntry, String password) throws BadPasswordException {
        return CryptoTool.getKey(keyEntry, password);
    }

    public static boolean isKeyEntry(KeyEntry keyEntry) {
        return keyEntry.getEncodedKey() != null;
    }
}

