/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.security.pstore;

import java.security.cert.Certificate;
import org.idoox.security.pstore.KeyEntry;

public class KeyEntryImpl
implements KeyEntry {
    private Data data;

    public KeyEntryImpl(Data data) {
        this.data = data;
    }

    public byte[] getEncodedKey() {
        return this.data.encodedKey;
    }

    public byte[] getFormat() {
        return this.data.format;
    }

    public byte[] getAlgorithm() {
        return this.data.algorithm;
    }

    public byte[] getSalt() {
        return this.data.salt;
    }

    public Certificate[] getCertificateChain() {
        return this.data.certChain;
    }

    int entryType() {
        if (this.data.encodedKey != null) {
            return 1;
        }
        return 2;
    }

    public KeyEntryImpl() {
        this.data = new Data();
    }

    public void setEncodedKey(byte[] encodedKey) {
        this.data.encodedKey = encodedKey;
    }

    public void setFormat(byte[] format) {
        this.data.format = format;
    }

    public void setAlgorithm(byte[] algorithm) {
        this.data.algorithm = algorithm;
    }

    public void setSalt(byte[] salt) {
        this.data.salt = salt;
    }

    public void setCertificateChain(Certificate[] certChain) {
        this.data.certChain = certChain;
    }

    public static class Data {
        public byte[] encodedKey;
        public byte[] format;
        public byte[] algorithm;
        public byte[] salt = new byte[8];
        public Certificate[] certChain;
    }
}

