/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.security.pstore;

import com.idoox.security.pstore.KeyEntryImpl;
import com.idoox.security.util.PBEWithSHAAnd3_KeyTripleDES_CBC;
import com.idoox.security.util.Random;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.security.Key;
import java.security.KeyFactory;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.spec.EncodedKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.util.Hashtable;
import java.util.Properties;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import org.idoox.security.pstore.BadPasswordException;
import org.idoox.security.pstore.KeyEntry;
import org.idoox.security.util.RuntimeWrappedException;

class CryptoTool {
    private static Properties keyFormats = null;
    private static boolean initialized = false;
    private static SecureRandom rand = Random.getRandom();
    private static PBEWithSHAAnd3_KeyTripleDES_CBC cipher = null;
    static /* synthetic */ Class array$B;

    CryptoTool() {
    }

    private static void initCrypto() {
        if (initialized) {
            return;
        }
        initialized = true;
        try {
            cipher = new PBEWithSHAAnd3_KeyTripleDES_CBC();
            keyFormats = new Properties();
            ((Hashtable)keyFormats).put("PKCS8", "java.security.spec.PKCS8EncodedKeySpec");
            ((Hashtable)keyFormats).put("PKCS#8", "java.security.spec.PKCS8EncodedKeySpec");
            ((Hashtable)keyFormats).put("X.509", "java.security.spec.X509EncodedKeySpec");
        }
        catch (Exception e) {
            throw new RuntimeWrappedException("Initialization of cryptography failed: ", (Throwable)e);
        }
    }

    public static void modifyKeyData(KeyEntryImpl.Data data, Key key, String password, Certificate[] chain) {
        block9: {
            if (key != null) {
                try {
                    rand.nextBytes(data.salt);
                    if (password == null) {
                        password = "";
                    }
                    PBEWithSHAAnd3_KeyTripleDES_CBC pBEWithSHAAnd3_KeyTripleDES_CBC = cipher;
                    synchronized (pBEWithSHAAnd3_KeyTripleDES_CBC) {
                        Cipher c = cipher.init(1, password, data.salt, 1024);
                        data.encodedKey = c.doFinal(key.getEncoded());
                        data.algorithm = c.doFinal(key.getAlgorithm().getBytes("UTF-8"));
                        data.format = c.doFinal(key.getFormat().getBytes("UTF-8"));
                        break block9;
                    }
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeWrappedException("The standard encoding UTF-8 isn't supported: ", (Throwable)e);
                }
                catch (Exception e) {
                    throw new RuntimeWrappedException("Key encoding corrupted: ", (Throwable)e);
                }
            }
            data.encodedKey = null;
            data.algorithm = null;
            data.format = null;
        }
        if (chain != null) {
            data.certChain = chain;
        }
    }

    public static Key getKey(KeyEntry entry, String password) throws BadPasswordException {
        if (entry.getEncodedKey() == null) {
            return null;
        }
        if (password == null) {
            password = "";
        }
        try {
            Key key;
            PBEWithSHAAnd3_KeyTripleDES_CBC pBEWithSHAAnd3_KeyTripleDES_CBC = cipher;
            synchronized (pBEWithSHAAnd3_KeyTripleDES_CBC) {
                Cipher c = cipher.init(2, password, entry.getSalt(), 1024);
                KeyFactory kf = KeyFactory.getInstance(new String(c.doFinal(entry.getAlgorithm()), "UTF-8"));
                String keyFormatStr = new String(c.doFinal(entry.getFormat()), "UTF-8");
                String specClassName = (String)((Hashtable)keyFormats).get(keyFormatStr);
                Class<?> specClass = Class.forName(specClassName);
                Class[] params = new Class[]{array$B == null ? (array$B = CryptoTool.class$("[B")) : array$B};
                Constructor<?> cons = specClass.getConstructor(params);
                Object[] consParams = new Object[]{c.doFinal(entry.getEncodedKey())};
                EncodedKeySpec encKeySpec = (EncodedKeySpec)cons.newInstance(consParams);
                try {
                    key = kf.generatePrivate(encKeySpec);
                }
                catch (InvalidKeySpecException e) {
                    key = kf.generatePublic(encKeySpec);
                }
            }
            return key;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeWrappedException((Throwable)e);
        }
        catch (InvalidKeySpecException e) {
            throw new BadPasswordException("Bad password: " + e.getMessage());
        }
        catch (IllegalBlockSizeException e) {
            throw new BadPasswordException("Bad password: " + e.getMessage());
        }
        catch (BadPaddingException e) {
            throw new BadPasswordException("Bad password: " + e.getMessage());
        }
        catch (Exception e) {
            throw new RuntimeWrappedException((Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        CryptoTool.initCrypto();
    }
}

