/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.security.pstore;

import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import org.idoox.security.pstore.PropertySerializer;
import org.idoox.security.util.RuntimeWrappedException;

public class CipherSerializer
implements PropertySerializer {
    public static final String KEY_FOR_DESede_Key = "DESede.key";
    public static final String KEY_FOR_Nested_Serializer = "nested.prop.serializer";
    private Cipher cipher;
    private SecretKey key;
    private PropertySerializer nested;

    public CipherSerializer(Map map) throws RuntimeWrappedException {
        Object obj = map.get(KEY_FOR_Nested_Serializer);
        if (obj == null || !(obj instanceof PropertySerializer)) {
            throw new RuntimeWrappedException("nested.prop.serializer property must be associated with property serialize instance");
        }
        this.nested = (PropertySerializer)obj;
        obj = map.get(KEY_FOR_DESede_Key);
        if (obj == null || !(obj instanceof byte[]) || ((byte[])obj).length != 24) {
            throw new RuntimeWrappedException("DESede.key property must be associated with byte array of the 24 bytes length");
        }
        try {
            DESedeKeySpec keySpec = new DESedeKeySpec((byte[])obj);
            SecretKeyFactory keyFac = SecretKeyFactory.getInstance("DESede");
            this.key = keyFac.generateSecret(keySpec);
            this.cipher = Cipher.getInstance("DESede/ECB/PKCS5Padding");
        }
        catch (Exception e) {
            throw new RuntimeWrappedException("Unable to initialize cipher serializer", (Throwable)e);
        }
    }

    public CipherSerializer(Cipher cipher, SecretKey key, PropertySerializer nested) {
        this.cipher = cipher;
        this.key = key;
        this.nested = nested;
    }

    public byte[] encode(Object property) {
        try {
            CipherSerializer cipherSerializer = this;
            synchronized (cipherSerializer) {
                this.cipher.init(1, this.key);
                byte[] byArray = this.cipher.doFinal(this.nested.encode(property));
                return byArray;
            }
        }
        catch (Exception e) {
            throw new RuntimeWrappedException("Unable to encrypt property", (Throwable)e);
        }
    }

    public Object decode(byte[] encoded) {
        try {
            CipherSerializer cipherSerializer = this;
            synchronized (cipherSerializer) {
                this.cipher.init(2, this.key);
                Object object = this.nested.decode(this.cipher.doFinal(encoded));
                return object;
            }
        }
        catch (Exception e) {
            throw new RuntimeWrappedException("Unable to decrypt property", (Throwable)e);
        }
    }

    public String getPropertyDescription() {
        return this.nested.getPropertyDescription();
    }

    public Class getAcceptingClass() {
        return this.nested.getAcceptingClass();
    }

    public String getType() {
        return this.nested.getType();
    }
}

