/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.debug;

import com.idoox.debug.CategoryFake;
import com.idoox.debug.CategoryListener;
import com.idoox.debug.ICategory;
import com.idoox.debug.LogListener;
import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class Category {
    public static final int DEBUG = 4;
    public static final int INFO = 3;
    public static final int WARN = 2;
    public static final int ERROR = 1;
    public static final int NONE = 0;
    private static Map properties;
    private static String categoryClassName;
    private static Integer level;
    public static final int defaultLevel = 2;
    private ICategory categoryImpl;
    private String localCategoryClassName;
    private String name;
    private boolean fireUserEvent = false;
    private static final String DEFAULT_CATEGORY_CLASSNAME = "com.idoox.debug.CategoryFake";
    private static final String LOG4J_CATEGORY_CLASSNAME = "com.idoox.debug.CategoryLog4J";
    static List logListeners;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$lang$String;

    public static void initialize(Map props) {
        String txtLogger;
        properties = props;
        String txtLevel = (String)props.get("idoox.debug.level");
        if (txtLevel != null) {
            try {
                level = Integer.valueOf(txtLevel);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        categoryClassName = (txtLogger = (String)props.get("idoox.debug.logger")) == null ? DEFAULT_CATEGORY_CLASSNAME : ("log4j".equals(txtLogger) ? LOG4J_CATEGORY_CLASSNAME : txtLogger);
        try {
            Class<?> clazz = Class.forName(categoryClassName);
            Method m = clazz.getMethod("initialize", class$java$util$Map == null ? (class$java$util$Map = Category.class$("java.util.Map")) : class$java$util$Map);
            m.invoke(null, props);
        }
        catch (ClassNotFoundException e) {
            categoryClassName = DEFAULT_CATEGORY_CLASSNAME;
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public static void destroy() {
        logListeners.clear();
    }

    public static void initialize() {
        Category.initialize(System.getProperties());
    }

    private Category(String name) {
        this.name = name;
    }

    private ICategory getImplementation() {
        if (this.categoryImpl != null && categoryClassName.equals(this.localCategoryClassName)) {
            return this.categoryImpl;
        }
        if (categoryClassName == null) {
            throw new IllegalStateException();
        }
        try {
            Class<?> clazz = Class.forName(categoryClassName);
            Method method = clazz.getMethod("getCategory", class$java$lang$String == null ? (class$java$lang$String = Category.class$("java.lang.String")) : class$java$lang$String);
            this.categoryImpl = (ICategory)method.invoke(null, (Object[])new String[]{this.name});
            this.localCategoryClassName = new String(categoryClassName);
        }
        catch (Exception e) {
            categoryClassName = DEFAULT_CATEGORY_CLASSNAME;
            this.localCategoryClassName = DEFAULT_CATEGORY_CLASSNAME;
            this.categoryImpl = CategoryFake.getCategory(this.name, level);
        }
        return this.categoryImpl;
    }

    public static Category getCategory(String name) {
        return new Category(name);
    }

    public static Integer getDebugLevel() {
        return level;
    }

    public static void setDebugLevel(int level) {
        Category.level = new Integer(level);
    }

    public void assertLog(boolean assertion, String msg) {
        if (!assertion) {
            this.callLogListeners(1, msg, null);
        }
        this.getImplementation().assertLog(assertion, msg);
    }

    public void debug(Object message) {
        if (message != null) {
            this.callLogListeners(4, message.toString(), null);
        }
        this.getImplementation().debug(message);
    }

    public void debug(String message) {
        this.callLogListeners(4, message, null);
        this.getImplementation().debug(message);
    }

    public void debug(String message, Throwable t) {
        this.callLogListeners(4, message, t);
        this.getImplementation().debug(message, t);
    }

    public void error(Object message) {
        if (message != null) {
            this.callLogListeners(1, message.toString(), null);
        }
        this.getImplementation().error(message);
    }

    public void error(String message) {
        this.callLogListeners(1, message, null);
        this.getImplementation().error(message);
    }

    public void error(String message, Throwable t) {
        this.callLogListeners(1, message, t);
        this.getImplementation().error(message, t);
    }

    public final String getName() {
        return this.getImplementation().getName();
    }

    public void info(Object message) {
        if (message != null) {
            this.callLogListeners(3, message.toString(), null);
        }
        this.getImplementation().info(message);
    }

    public void info(String message) {
        this.callLogListeners(3, message, null);
        this.getImplementation().info(message);
    }

    public void info(String message, Throwable t) {
        this.callLogListeners(3, message, t);
        this.getImplementation().info(message, t);
    }

    public boolean isDebugEnabled() {
        return this.getImplementation().isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.getImplementation().isInfoEnabled();
    }

    public void warn(Object message) {
        if (message != null) {
            this.callLogListeners(2, message.toString(), null);
        }
        this.getImplementation().warn(message);
    }

    public void warn(String message) {
        this.callLogListeners(2, message, null);
        this.getImplementation().warn(message);
    }

    public void warn(String message, Throwable t) {
        this.callLogListeners(2, message, t);
        this.getImplementation().warn(message, t);
    }

    public void todo(String message) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        new Exception().printStackTrace(pw);
        StringBuffer sBuf = sw.getBuffer();
        BufferedReader br = new BufferedReader(new StringReader(sBuf.toString()));
        String line = null;
        try {
            while ((line = br.readLine()) != null && line.indexOf("Category.todo") == -1) {
            }
            line = br.readLine();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.getImplementation().error("TODO: " + message + (line != null ? "  " + line.trim() : ""));
    }

    public static Map getProperties() {
        return properties;
    }

    public static void setProperties(Properties properties) {
        Category.properties = properties;
    }

    public static void addLogListener(LogListener listener) {
        if (listener == null) {
            return;
        }
        logListeners.add(listener);
    }

    public static List getLogListener() {
        return logListeners;
    }

    public static boolean removeLogListener(LogListener listener) {
        if (listener == null) {
            return false;
        }
        return logListeners.remove(listener);
    }

    private void callLogListeners(int priority, String message, Throwable t) {
        Iterator iterator = logListeners.iterator();
        while (iterator.hasNext()) {
            LogListener logListener = (LogListener)iterator.next();
            try {
                if (logListener instanceof CategoryListener) {
                    ((CategoryListener)logListener).handle(this.fireUserEvent, priority, this.name, message, t);
                    continue;
                }
                logListener.handleLog(priority, this.name, message, t);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public int getInstanceDebugLevel() {
        return this.getImplementation().getDebugLevel();
    }

    public void setInstanceDebugLevel(int level) {
        this.getImplementation().setDebugLevel(level);
    }

    public void setFireUserEvent(boolean fireUserEvent) {
        this.fireUserEvent = fireUserEvent;
    }

    public boolean isFireUserEvent() {
        return this.fireUserEvent;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        level = null;
        logListeners = new ArrayList();
        Category.initialize();
    }
}

