/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.uddi.client.v3.struct;

import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.Map;
import org.idoox.util.WrappedException;
import org.idoox.xml.TokenWriter;
import org.idoox.xml.Tokenizer;
import org.systinet.uddi.InvalidParameterErrorCodes;
import org.systinet.uddi.InvalidParameterException;
import org.systinet.uddi.ResourceBundle;
import org.systinet.uddi.client.base.UDDIObject;
import org.systinet.uddi.client.serialization.Deserializer;
import org.systinet.uddi.client.serialization.Serializer;
import org.systinet.uddi.client.util.StringHelper;
import org.systinet.uddi.client.v3.serialization.TModelInfoDeserializer;
import org.systinet.uddi.client.v3.serialization.TModelInfoSerializer;
import org.systinet.uddi.client.v3.struct.Description;
import org.systinet.uddi.client.v3.struct.DescriptionArrayList;
import org.systinet.uddi.client.v3.struct.Name;
import org.systinet.uddi.client.v3.util.Helper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TModelInfo
extends UDDIObject
implements Cloneable,
Serializable {
    protected Name name;
    protected DescriptionArrayList descriptionArrayList;
    protected String tModelKey;

    public TModelInfo() {
    }

    public TModelInfo(Name name, String tModelKey) throws InvalidParameterException {
        this.setName(name);
        this.setTModelKey(tModelKey);
    }

    public TModelInfo(Name name, String tModelKey, DescriptionArrayList descriptionArrayList) throws InvalidParameterException {
        this.setName(name);
        this.setTModelKey(tModelKey);
        this.setDescriptionArrayList(descriptionArrayList);
    }

    public Name getName() {
        return this.name;
    }

    public void setName(Name name) throws InvalidParameterException {
        if (name == null) {
            throw new InvalidParameterException(InvalidParameterErrorCodes.E_MISSING_REQUIRED_ELEMENT, ResourceBundle.getString("EXC_IsNull_P1", "TModelInfo.name"));
        }
        if (name != null) {
            // empty if block
        }
        this.name = name;
    }

    public void addDescription(Description item) {
        if (this.descriptionArrayList == null) {
            this.descriptionArrayList = new DescriptionArrayList();
        }
        this.descriptionArrayList.add(item);
    }

    public DescriptionArrayList getDescriptionArrayList() {
        return this.descriptionArrayList;
    }

    public void setDescriptionArrayList(DescriptionArrayList descriptionArrayList) throws InvalidParameterException {
        this.descriptionArrayList = descriptionArrayList;
    }

    public String getTModelKey() {
        return this.tModelKey;
    }

    public void setTModelKey(String tModelKey) throws InvalidParameterException {
        if (tModelKey == null) {
            throw new InvalidParameterException(InvalidParameterErrorCodes.E_MISSING_REQUIRED_ELEMENT, ResourceBundle.getString("EXC_IsNull_P1", "TModelInfo.tModelKey"));
        }
        if (tModelKey != null && (tModelKey = StringHelper.whitespaceCollapse(tModelKey)).length() > 255) {
            throw new InvalidParameterException(InvalidParameterErrorCodes.E_NAME_TOO_LONG, ResourceBundle.getString("EXC_ValueTooLong_P1", new Object[]{"255"}));
        }
        this.tModelKey = tModelKey;
    }

    public String toXML() {
        return Helper.serialize(this, "urn:uddi-org:api_v3", "tModelInfo", TModelInfoSerializer.getInstance());
    }

    public void toXML(StringBuffer stringBuffer) {
        Helper.serialize((Object)this, "urn:uddi-org:api_v3", "tModelInfo", (Serializer)TModelInfoSerializer.getInstance(), stringBuffer);
    }

    public Element toXML(Document document) {
        return Helper.serialize((Object)this, "urn:uddi-org:api_v3", "tModelInfo", (Serializer)TModelInfoSerializer.getInstance(), document);
    }

    public void toXML(Writer writer) {
        Helper.serialize((Object)this, "urn:uddi-org:api_v3", "tModelInfo", (Serializer)TModelInfoSerializer.getInstance(), writer);
    }

    public void toXML(TokenWriter tokenWriter) {
        Helper.serialize((Object)this, "urn:uddi-org:api_v3", "tModelInfo", (Serializer)TModelInfoSerializer.getInstance(), tokenWriter);
    }

    public void toXML(TokenWriter tokenWriter, Map mapping) {
        Helper.serialize(this, "urn:uddi-org:api_v3", "tModelInfo", TModelInfoSerializer.getInstance(), tokenWriter, mapping);
    }

    public static TModelInfo fromXML(String string) throws InvalidParameterException, WrappedException {
        return (TModelInfo)Helper.deserialize("urn:uddi-org:api_v3", "tModelInfo", (Deserializer)TModelInfoDeserializer.getInstance(), string);
    }

    public static TModelInfo fromXML(Element element) throws InvalidParameterException, WrappedException {
        return (TModelInfo)Helper.deserialize("urn:uddi-org:api_v3", "tModelInfo", (Deserializer)TModelInfoDeserializer.getInstance(), element);
    }

    public static TModelInfo fromXML(Reader reader) throws InvalidParameterException, WrappedException {
        return (TModelInfo)Helper.deserialize("urn:uddi-org:api_v3", "tModelInfo", (Deserializer)TModelInfoDeserializer.getInstance(), reader);
    }

    public static TModelInfo fromXML(Tokenizer tokenizer) throws InvalidParameterException, WrappedException {
        return (TModelInfo)Helper.deserialize("urn:uddi-org:api_v3", "tModelInfo", (Deserializer)TModelInfoDeserializer.getInstance(), tokenizer);
    }

    public static TModelInfo fromXML(Tokenizer tokenizer, Map mapping) throws InvalidParameterException, WrappedException {
        return (TModelInfo)Helper.deserialize("urn:uddi-org:api_v3", "tModelInfo", TModelInfoDeserializer.getInstance(), tokenizer, mapping);
    }

    public void check() throws InvalidParameterException {
        super.check();
        if (this.name == null) {
            throw new InvalidParameterException(InvalidParameterErrorCodes.E_MISSING_REQUIRED_ELEMENT, ResourceBundle.getString("EXC_IsNull_P1", "TModelInfo.name"));
        }
        this.name.check();
        if (this.descriptionArrayList != null) {
            this.descriptionArrayList.check();
        }
        if (this.tModelKey == null) {
            throw new InvalidParameterException(InvalidParameterErrorCodes.E_MISSING_REQUIRED_ELEMENT, ResourceBundle.getString("EXC_IsNull_P1", "TModelInfo.tModelKey"));
        }
    }

    public boolean normalize() {
        boolean result = true;
        if (this.name != null) {
            this.name.normalize();
            result = false;
        }
        if (this.descriptionArrayList != null) {
            if (this.descriptionArrayList.normalize()) {
                this.descriptionArrayList = null;
            } else {
                result = false;
            }
        }
        if (this.tModelKey != null) {
            result = false;
        }
        return result;
    }

    public Object clone() throws CloneNotSupportedException {
        TModelInfo theClone = (TModelInfo)super.clone();
        if (this.name != null) {
            theClone.name = (Name)this.name.clone();
        }
        if (this.descriptionArrayList != null) {
            theClone.descriptionArrayList = (DescriptionArrayList)this.descriptionArrayList.clone();
        }
        return theClone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TModelInfo)) {
            return false;
        }
        TModelInfo org_systinet_uddi_client_v3_struct_TModelInfo = (TModelInfo)o;
        boolean bl = this.name != null ? !this.name.equals(org_systinet_uddi_client_v3_struct_TModelInfo.name) : org_systinet_uddi_client_v3_struct_TModelInfo.name != null;
        if (bl) {
            return false;
        }
        boolean bl2 = this.descriptionArrayList != null ? !this.descriptionArrayList.equals(org_systinet_uddi_client_v3_struct_TModelInfo.descriptionArrayList) : org_systinet_uddi_client_v3_struct_TModelInfo.descriptionArrayList != null;
        if (bl2) {
            return false;
        }
        return !(this.tModelKey != null ? !this.tModelKey.equals(org_systinet_uddi_client_v3_struct_TModelInfo.tModelKey) : org_systinet_uddi_client_v3_struct_TModelInfo.tModelKey != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 29 * result + (this.descriptionArrayList != null ? this.descriptionArrayList.hashCode() : 0);
        result = 29 * result + (this.tModelKey != null ? this.tModelKey.hashCode() : 0);
        return result;
    }
}

