/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.uddi.client.v3.struct;

import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.Map;
import org.idoox.util.WrappedException;
import org.idoox.xml.TokenWriter;
import org.idoox.xml.Tokenizer;
import org.systinet.uddi.InvalidParameterErrorCodes;
import org.systinet.uddi.InvalidParameterException;
import org.systinet.uddi.ResourceBundle;
import org.systinet.uddi.client.base.ElementArrayList;
import org.systinet.uddi.client.base.UDDIObject;
import org.systinet.uddi.client.serialization.Deserializer;
import org.systinet.uddi.client.serialization.Serializer;
import org.systinet.uddi.client.util.StringHelper;
import org.systinet.uddi.client.v3.serialization.TModelDeserializer;
import org.systinet.uddi.client.v3.serialization.TModelSerializer;
import org.systinet.uddi.client.v3.struct.CategoryBag;
import org.systinet.uddi.client.v3.struct.Description;
import org.systinet.uddi.client.v3.struct.DescriptionArrayList;
import org.systinet.uddi.client.v3.struct.IdentifierBag;
import org.systinet.uddi.client.v3.struct.Name;
import org.systinet.uddi.client.v3.struct.OverviewDoc;
import org.systinet.uddi.client.v3.struct.OverviewDocArrayList;
import org.systinet.uddi.client.v3.util.Helper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TModel
extends UDDIObject
implements Cloneable,
Serializable {
    protected Name name;
    protected DescriptionArrayList descriptionArrayList;
    protected OverviewDocArrayList overviewDocArrayList;
    protected IdentifierBag identifierBag;
    protected CategoryBag categoryBag;
    protected ElementArrayList SignatureArrayList;
    protected String tModelKey;
    protected Boolean deleted = new Boolean(false);

    public TModel() {
    }

    public TModel(Name name) throws InvalidParameterException {
        this.setName(name);
    }

    public TModel(Name name, DescriptionArrayList descriptionArrayList, OverviewDocArrayList overviewDocArrayList, IdentifierBag identifierBag, CategoryBag categoryBag, ElementArrayList SignatureArrayList, String tModelKey, Boolean deleted) throws InvalidParameterException {
        this.setName(name);
        this.setDescriptionArrayList(descriptionArrayList);
        this.setOverviewDocArrayList(overviewDocArrayList);
        this.setIdentifierBag(identifierBag);
        this.setCategoryBag(categoryBag);
        this.setSignatureArrayList(SignatureArrayList);
        this.setTModelKey(tModelKey);
        this.setDeleted(deleted);
    }

    public Name getName() {
        return this.name;
    }

    public void setName(Name name) throws InvalidParameterException {
        if (name == null) {
            throw new InvalidParameterException(InvalidParameterErrorCodes.E_MISSING_REQUIRED_ELEMENT, ResourceBundle.getString("EXC_IsNull_P1", "TModel.name"));
        }
        if (name != null) {
            // empty if block
        }
        this.name = name;
    }

    public void addDescription(Description item) {
        if (this.descriptionArrayList == null) {
            this.descriptionArrayList = new DescriptionArrayList();
        }
        this.descriptionArrayList.add(item);
    }

    public DescriptionArrayList getDescriptionArrayList() {
        return this.descriptionArrayList;
    }

    public void setDescriptionArrayList(DescriptionArrayList descriptionArrayList) throws InvalidParameterException {
        this.descriptionArrayList = descriptionArrayList;
    }

    public void addOverviewDoc(OverviewDoc item) {
        if (this.overviewDocArrayList == null) {
            this.overviewDocArrayList = new OverviewDocArrayList();
        }
        this.overviewDocArrayList.add(item);
    }

    public OverviewDocArrayList getOverviewDocArrayList() {
        return this.overviewDocArrayList;
    }

    public void setOverviewDocArrayList(OverviewDocArrayList overviewDocArrayList) throws InvalidParameterException {
        this.overviewDocArrayList = overviewDocArrayList;
    }

    public IdentifierBag getIdentifierBag() {
        return this.identifierBag;
    }

    public void setIdentifierBag(IdentifierBag identifierBag) {
        if (identifierBag != null) {
            // empty if block
        }
        this.identifierBag = identifierBag;
    }

    public CategoryBag getCategoryBag() {
        return this.categoryBag;
    }

    public void setCategoryBag(CategoryBag categoryBag) {
        if (categoryBag != null) {
            // empty if block
        }
        this.categoryBag = categoryBag;
    }

    public void addSignature(Element item) {
        if (this.SignatureArrayList == null) {
            this.SignatureArrayList = new ElementArrayList();
        }
        this.SignatureArrayList.add(item);
    }

    public ElementArrayList getSignatureArrayList() {
        return this.SignatureArrayList;
    }

    public void setSignatureArrayList(ElementArrayList SignatureArrayList) throws InvalidParameterException {
        this.SignatureArrayList = SignatureArrayList;
    }

    public String getTModelKey() {
        return this.tModelKey;
    }

    public void setTModelKey(String tModelKey) throws InvalidParameterException {
        if (tModelKey != null && (tModelKey = StringHelper.whitespaceCollapse(tModelKey)).length() > 255) {
            throw new InvalidParameterException(InvalidParameterErrorCodes.E_NAME_TOO_LONG, ResourceBundle.getString("EXC_ValueTooLong_P1", new Object[]{"255"}));
        }
        this.tModelKey = tModelKey;
    }

    public Boolean getDeleted() {
        return this.deleted;
    }

    public void setDeleted(Boolean deleted) {
        if (deleted != null) {
            // empty if block
        }
        this.deleted = deleted;
    }

    public String toXML() {
        return Helper.serialize(this, "urn:uddi-org:api_v3", "tModel", TModelSerializer.getInstance());
    }

    public void toXML(StringBuffer stringBuffer) {
        Helper.serialize((Object)this, "urn:uddi-org:api_v3", "tModel", (Serializer)TModelSerializer.getInstance(), stringBuffer);
    }

    public Element toXML(Document document) {
        return Helper.serialize((Object)this, "urn:uddi-org:api_v3", "tModel", (Serializer)TModelSerializer.getInstance(), document);
    }

    public void toXML(Writer writer) {
        Helper.serialize((Object)this, "urn:uddi-org:api_v3", "tModel", (Serializer)TModelSerializer.getInstance(), writer);
    }

    public void toXML(TokenWriter tokenWriter) {
        Helper.serialize((Object)this, "urn:uddi-org:api_v3", "tModel", (Serializer)TModelSerializer.getInstance(), tokenWriter);
    }

    public void toXML(TokenWriter tokenWriter, Map mapping) {
        Helper.serialize(this, "urn:uddi-org:api_v3", "tModel", TModelSerializer.getInstance(), tokenWriter, mapping);
    }

    public static TModel fromXML(String string) throws InvalidParameterException, WrappedException {
        return (TModel)Helper.deserialize("urn:uddi-org:api_v3", "tModel", (Deserializer)TModelDeserializer.getInstance(), string);
    }

    public static TModel fromXML(Element element) throws InvalidParameterException, WrappedException {
        return (TModel)Helper.deserialize("urn:uddi-org:api_v3", "tModel", (Deserializer)TModelDeserializer.getInstance(), element);
    }

    public static TModel fromXML(Reader reader) throws InvalidParameterException, WrappedException {
        return (TModel)Helper.deserialize("urn:uddi-org:api_v3", "tModel", (Deserializer)TModelDeserializer.getInstance(), reader);
    }

    public static TModel fromXML(Tokenizer tokenizer) throws InvalidParameterException, WrappedException {
        return (TModel)Helper.deserialize("urn:uddi-org:api_v3", "tModel", (Deserializer)TModelDeserializer.getInstance(), tokenizer);
    }

    public static TModel fromXML(Tokenizer tokenizer, Map mapping) throws InvalidParameterException, WrappedException {
        return (TModel)Helper.deserialize("urn:uddi-org:api_v3", "tModel", TModelDeserializer.getInstance(), tokenizer, mapping);
    }

    public void check() throws InvalidParameterException {
        super.check();
        if (this.name == null) {
            throw new InvalidParameterException(InvalidParameterErrorCodes.E_MISSING_REQUIRED_ELEMENT, ResourceBundle.getString("EXC_IsNull_P1", "TModel.name"));
        }
        this.name.check();
        if (this.descriptionArrayList != null) {
            this.descriptionArrayList.check();
        }
        if (this.overviewDocArrayList != null) {
            this.overviewDocArrayList.check();
        }
        if (this.identifierBag != null) {
            this.identifierBag.check();
        }
        if (this.categoryBag != null) {
            this.categoryBag.check();
        }
        if (this.SignatureArrayList != null) {
            this.SignatureArrayList.check();
        }
    }

    public boolean normalize() {
        boolean result = true;
        if (this.name != null) {
            this.name.normalize();
            result = false;
        }
        if (this.descriptionArrayList != null) {
            if (this.descriptionArrayList.normalize()) {
                this.descriptionArrayList = null;
            } else {
                result = false;
            }
        }
        if (this.overviewDocArrayList != null) {
            if (this.overviewDocArrayList.normalize()) {
                this.overviewDocArrayList = null;
            } else {
                result = false;
            }
        }
        if (this.identifierBag != null) {
            if (this.identifierBag.normalize()) {
                this.identifierBag = null;
            } else {
                result = false;
            }
        }
        if (this.categoryBag != null) {
            if (this.categoryBag.normalize()) {
                this.categoryBag = null;
            } else {
                result = false;
            }
        }
        if (this.SignatureArrayList != null) {
            if (this.SignatureArrayList.normalize()) {
                this.SignatureArrayList = null;
            } else {
                result = false;
            }
        }
        if (this.tModelKey != null) {
            result = false;
        }
        if (this.deleted != null) {
            result = false;
        }
        return result;
    }

    public Object clone() throws CloneNotSupportedException {
        TModel theClone = (TModel)super.clone();
        if (this.name != null) {
            theClone.name = (Name)this.name.clone();
        }
        if (this.descriptionArrayList != null) {
            theClone.descriptionArrayList = (DescriptionArrayList)this.descriptionArrayList.clone();
        }
        if (this.overviewDocArrayList != null) {
            theClone.overviewDocArrayList = (OverviewDocArrayList)this.overviewDocArrayList.clone();
        }
        if (this.identifierBag != null) {
            theClone.identifierBag = (IdentifierBag)this.identifierBag.clone();
        }
        if (this.categoryBag != null) {
            theClone.categoryBag = (CategoryBag)this.categoryBag.clone();
        }
        if (this.SignatureArrayList != null) {
            theClone.SignatureArrayList = (ElementArrayList)this.SignatureArrayList.clone();
        }
        if (this.deleted != null) {
            theClone.deleted = new Boolean(this.deleted);
        }
        return theClone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TModel)) {
            return false;
        }
        TModel org_systinet_uddi_client_v3_struct_TModel = (TModel)o;
        boolean bl = this.name != null ? !this.name.equals(org_systinet_uddi_client_v3_struct_TModel.name) : org_systinet_uddi_client_v3_struct_TModel.name != null;
        if (bl) {
            return false;
        }
        boolean bl2 = this.descriptionArrayList != null ? !this.descriptionArrayList.equals(org_systinet_uddi_client_v3_struct_TModel.descriptionArrayList) : org_systinet_uddi_client_v3_struct_TModel.descriptionArrayList != null;
        if (bl2) {
            return false;
        }
        boolean bl3 = this.overviewDocArrayList != null ? !this.overviewDocArrayList.equals(org_systinet_uddi_client_v3_struct_TModel.overviewDocArrayList) : org_systinet_uddi_client_v3_struct_TModel.overviewDocArrayList != null;
        if (bl3) {
            return false;
        }
        boolean bl4 = this.identifierBag != null ? !this.identifierBag.equals(org_systinet_uddi_client_v3_struct_TModel.identifierBag) : org_systinet_uddi_client_v3_struct_TModel.identifierBag != null;
        if (bl4) {
            return false;
        }
        boolean bl5 = this.categoryBag != null ? !this.categoryBag.equals(org_systinet_uddi_client_v3_struct_TModel.categoryBag) : org_systinet_uddi_client_v3_struct_TModel.categoryBag != null;
        if (bl5) {
            return false;
        }
        boolean bl6 = this.SignatureArrayList != null ? !this.SignatureArrayList.equals(org_systinet_uddi_client_v3_struct_TModel.SignatureArrayList) : org_systinet_uddi_client_v3_struct_TModel.SignatureArrayList != null;
        if (bl6) {
            return false;
        }
        boolean bl7 = this.tModelKey != null ? !this.tModelKey.equals(org_systinet_uddi_client_v3_struct_TModel.tModelKey) : org_systinet_uddi_client_v3_struct_TModel.tModelKey != null;
        if (bl7) {
            return false;
        }
        return !(this.deleted != null ? !this.deleted.equals(org_systinet_uddi_client_v3_struct_TModel.deleted) : org_systinet_uddi_client_v3_struct_TModel.deleted != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 29 * result + (this.descriptionArrayList != null ? this.descriptionArrayList.hashCode() : 0);
        result = 29 * result + (this.overviewDocArrayList != null ? this.overviewDocArrayList.hashCode() : 0);
        result = 29 * result + (this.identifierBag != null ? this.identifierBag.hashCode() : 0);
        result = 29 * result + (this.categoryBag != null ? this.categoryBag.hashCode() : 0);
        result = 29 * result + (this.SignatureArrayList != null ? this.SignatureArrayList.hashCode() : 0);
        result = 29 * result + (this.tModelKey != null ? this.tModelKey.hashCode() : 0);
        result = 29 * result + (this.deleted != null ? this.deleted.hashCode() : 0);
        return result;
    }
}

