/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.uddi.client.v3.struct;

import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.Map;
import org.idoox.util.WrappedException;
import org.idoox.xml.TokenWriter;
import org.idoox.xml.Tokenizer;
import org.systinet.uddi.InvalidParameterErrorCodes;
import org.systinet.uddi.InvalidParameterException;
import org.systinet.uddi.ResourceBundle;
import org.systinet.uddi.client.base.UDDIObject;
import org.systinet.uddi.client.serialization.Deserializer;
import org.systinet.uddi.client.serialization.Serializer;
import org.systinet.uddi.client.v3.serialization.ServiceListDeserializer;
import org.systinet.uddi.client.v3.serialization.ServiceListSerializer;
import org.systinet.uddi.client.v3.struct.ListDescription;
import org.systinet.uddi.client.v3.struct.ServiceInfo;
import org.systinet.uddi.client.v3.struct.ServiceInfoArrayList;
import org.systinet.uddi.client.v3.util.Helper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ServiceList
extends UDDIObject
implements Cloneable,
Serializable {
    protected ListDescription listDescription;
    protected ServiceInfoArrayList serviceInfoArrayList;
    protected Boolean truncated;

    public ServiceList() {
    }

    public ServiceList(ListDescription listDescription, ServiceInfoArrayList serviceInfoArrayList, Boolean truncated) throws InvalidParameterException {
        this.setListDescription(listDescription);
        this.setServiceInfoArrayList(serviceInfoArrayList);
        this.setTruncated(truncated);
    }

    public ListDescription getListDescription() {
        return this.listDescription;
    }

    public void setListDescription(ListDescription listDescription) {
        if (listDescription != null) {
            // empty if block
        }
        this.listDescription = listDescription;
    }

    public void addServiceInfo(ServiceInfo item) {
        if (this.serviceInfoArrayList == null) {
            this.serviceInfoArrayList = new ServiceInfoArrayList();
        }
        this.serviceInfoArrayList.add(item);
    }

    public ServiceInfoArrayList getServiceInfoArrayList() {
        return this.serviceInfoArrayList;
    }

    public void setServiceInfoArrayList(ServiceInfoArrayList serviceInfoArrayList) {
        this.serviceInfoArrayList = serviceInfoArrayList;
    }

    public Boolean getTruncated() {
        return this.truncated;
    }

    public void setTruncated(Boolean truncated) {
        if (truncated != null) {
            // empty if block
        }
        this.truncated = truncated;
    }

    public String toXML() {
        return Helper.serialize(this, "urn:uddi-org:api_v3", "serviceList", ServiceListSerializer.getInstance());
    }

    public void toXML(StringBuffer stringBuffer) {
        Helper.serialize((Object)this, "urn:uddi-org:api_v3", "serviceList", (Serializer)ServiceListSerializer.getInstance(), stringBuffer);
    }

    public Element toXML(Document document) {
        return Helper.serialize((Object)this, "urn:uddi-org:api_v3", "serviceList", (Serializer)ServiceListSerializer.getInstance(), document);
    }

    public void toXML(Writer writer) {
        Helper.serialize((Object)this, "urn:uddi-org:api_v3", "serviceList", (Serializer)ServiceListSerializer.getInstance(), writer);
    }

    public void toXML(TokenWriter tokenWriter) {
        Helper.serialize((Object)this, "urn:uddi-org:api_v3", "serviceList", (Serializer)ServiceListSerializer.getInstance(), tokenWriter);
    }

    public void toXML(TokenWriter tokenWriter, Map mapping) {
        Helper.serialize(this, "urn:uddi-org:api_v3", "serviceList", ServiceListSerializer.getInstance(), tokenWriter, mapping);
    }

    public static ServiceList fromXML(String string) throws InvalidParameterException, WrappedException {
        return (ServiceList)Helper.deserialize("urn:uddi-org:api_v3", "serviceList", (Deserializer)ServiceListDeserializer.getInstance(), string);
    }

    public static ServiceList fromXML(Element element) throws InvalidParameterException, WrappedException {
        return (ServiceList)Helper.deserialize("urn:uddi-org:api_v3", "serviceList", (Deserializer)ServiceListDeserializer.getInstance(), element);
    }

    public static ServiceList fromXML(Reader reader) throws InvalidParameterException, WrappedException {
        return (ServiceList)Helper.deserialize("urn:uddi-org:api_v3", "serviceList", (Deserializer)ServiceListDeserializer.getInstance(), reader);
    }

    public static ServiceList fromXML(Tokenizer tokenizer) throws InvalidParameterException, WrappedException {
        return (ServiceList)Helper.deserialize("urn:uddi-org:api_v3", "serviceList", (Deserializer)ServiceListDeserializer.getInstance(), tokenizer);
    }

    public static ServiceList fromXML(Tokenizer tokenizer, Map mapping) throws InvalidParameterException, WrappedException {
        return (ServiceList)Helper.deserialize("urn:uddi-org:api_v3", "serviceList", ServiceListDeserializer.getInstance(), tokenizer, mapping);
    }

    public void check() throws InvalidParameterException {
        super.check();
        if (this.listDescription != null) {
            this.listDescription.check();
        }
        if (this.serviceInfoArrayList != null) {
            if (this.serviceInfoArrayList.size() < 1) {
                throw new InvalidParameterException(InvalidParameterErrorCodes.E_MISSING_REQUIRED_ELEMENT, ResourceBundle.getString("EXC_IsNull_P1", "ServiceList.serviceInfoArrayList"));
            }
            this.serviceInfoArrayList.check();
        }
    }

    public boolean normalize() {
        boolean result = true;
        if (this.listDescription != null) {
            if (this.listDescription.normalize()) {
                this.listDescription = null;
            } else {
                result = false;
            }
        }
        if (this.serviceInfoArrayList != null) {
            if (this.serviceInfoArrayList.normalize()) {
                this.serviceInfoArrayList = null;
            } else {
                result = false;
            }
        }
        if (this.truncated != null) {
            result = false;
        }
        return result;
    }

    public Object clone() throws CloneNotSupportedException {
        ServiceList theClone = (ServiceList)super.clone();
        if (this.listDescription != null) {
            theClone.listDescription = (ListDescription)this.listDescription.clone();
        }
        if (this.serviceInfoArrayList != null) {
            theClone.serviceInfoArrayList = (ServiceInfoArrayList)this.serviceInfoArrayList.clone();
        }
        if (this.truncated != null) {
            theClone.truncated = new Boolean(this.truncated);
        }
        return theClone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ServiceList)) {
            return false;
        }
        ServiceList org_systinet_uddi_client_v3_struct_ServiceList = (ServiceList)o;
        boolean bl = this.listDescription != null ? !this.listDescription.equals(org_systinet_uddi_client_v3_struct_ServiceList.listDescription) : org_systinet_uddi_client_v3_struct_ServiceList.listDescription != null;
        if (bl) {
            return false;
        }
        boolean bl2 = this.serviceInfoArrayList != null ? !this.serviceInfoArrayList.equals(org_systinet_uddi_client_v3_struct_ServiceList.serviceInfoArrayList) : org_systinet_uddi_client_v3_struct_ServiceList.serviceInfoArrayList != null;
        if (bl2) {
            return false;
        }
        return !(this.truncated != null ? !this.truncated.equals(org_systinet_uddi_client_v3_struct_ServiceList.truncated) : org_systinet_uddi_client_v3_struct_ServiceList.truncated != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + (this.listDescription != null ? this.listDescription.hashCode() : 0);
        result = 29 * result + (this.serviceInfoArrayList != null ? this.serviceInfoArrayList.hashCode() : 0);
        result = 29 * result + (this.truncated != null ? this.truncated.hashCode() : 0);
        return result;
    }
}

