/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.uddi.client.v3.struct;

import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.Map;
import org.idoox.util.WrappedException;
import org.idoox.xml.TokenWriter;
import org.idoox.xml.Tokenizer;
import org.systinet.uddi.InvalidParameterErrorCodes;
import org.systinet.uddi.InvalidParameterException;
import org.systinet.uddi.ResourceBundle;
import org.systinet.uddi.client.base.UDDIObject;
import org.systinet.uddi.client.serialization.Deserializer;
import org.systinet.uddi.client.serialization.Serializer;
import org.systinet.uddi.client.util.StringHelper;
import org.systinet.uddi.client.v3.serialization.ServiceInfoDeserializer;
import org.systinet.uddi.client.v3.serialization.ServiceInfoSerializer;
import org.systinet.uddi.client.v3.struct.Name;
import org.systinet.uddi.client.v3.struct.NameArrayList;
import org.systinet.uddi.client.v3.util.Helper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ServiceInfo
extends UDDIObject
implements Cloneable,
Serializable {
    protected NameArrayList nameArrayList;
    protected String serviceKey;
    protected String businessKey;

    public ServiceInfo() {
    }

    public ServiceInfo(String serviceKey, String businessKey) throws InvalidParameterException {
        this.setServiceKey(serviceKey);
        this.setBusinessKey(businessKey);
    }

    public ServiceInfo(String serviceKey, String businessKey, NameArrayList nameArrayList) throws InvalidParameterException {
        this.setServiceKey(serviceKey);
        this.setBusinessKey(businessKey);
        this.setNameArrayList(nameArrayList);
    }

    public void addName(Name item) {
        if (this.nameArrayList == null) {
            this.nameArrayList = new NameArrayList();
        }
        this.nameArrayList.add(item);
    }

    public NameArrayList getNameArrayList() {
        return this.nameArrayList;
    }

    public void setNameArrayList(NameArrayList nameArrayList) throws InvalidParameterException {
        this.nameArrayList = nameArrayList;
    }

    public String getServiceKey() {
        return this.serviceKey;
    }

    public void setServiceKey(String serviceKey) throws InvalidParameterException {
        if (serviceKey == null) {
            throw new InvalidParameterException(InvalidParameterErrorCodes.E_MISSING_REQUIRED_ELEMENT, ResourceBundle.getString("EXC_IsNull_P1", "ServiceInfo.serviceKey"));
        }
        if (serviceKey != null && (serviceKey = StringHelper.whitespaceCollapse(serviceKey)).length() > 255) {
            throw new InvalidParameterException(InvalidParameterErrorCodes.E_NAME_TOO_LONG, ResourceBundle.getString("EXC_ValueTooLong_P1", new Object[]{"255"}));
        }
        this.serviceKey = serviceKey;
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public void setBusinessKey(String businessKey) throws InvalidParameterException {
        if (businessKey == null) {
            throw new InvalidParameterException(InvalidParameterErrorCodes.E_MISSING_REQUIRED_ELEMENT, ResourceBundle.getString("EXC_IsNull_P1", "ServiceInfo.businessKey"));
        }
        if (businessKey != null && (businessKey = StringHelper.whitespaceCollapse(businessKey)).length() > 255) {
            throw new InvalidParameterException(InvalidParameterErrorCodes.E_NAME_TOO_LONG, ResourceBundle.getString("EXC_ValueTooLong_P1", new Object[]{"255"}));
        }
        this.businessKey = businessKey;
    }

    public String toXML() {
        return Helper.serialize(this, "urn:uddi-org:api_v3", "serviceInfo", ServiceInfoSerializer.getInstance());
    }

    public void toXML(StringBuffer stringBuffer) {
        Helper.serialize((Object)this, "urn:uddi-org:api_v3", "serviceInfo", (Serializer)ServiceInfoSerializer.getInstance(), stringBuffer);
    }

    public Element toXML(Document document) {
        return Helper.serialize((Object)this, "urn:uddi-org:api_v3", "serviceInfo", (Serializer)ServiceInfoSerializer.getInstance(), document);
    }

    public void toXML(Writer writer) {
        Helper.serialize((Object)this, "urn:uddi-org:api_v3", "serviceInfo", (Serializer)ServiceInfoSerializer.getInstance(), writer);
    }

    public void toXML(TokenWriter tokenWriter) {
        Helper.serialize((Object)this, "urn:uddi-org:api_v3", "serviceInfo", (Serializer)ServiceInfoSerializer.getInstance(), tokenWriter);
    }

    public void toXML(TokenWriter tokenWriter, Map mapping) {
        Helper.serialize(this, "urn:uddi-org:api_v3", "serviceInfo", ServiceInfoSerializer.getInstance(), tokenWriter, mapping);
    }

    public static ServiceInfo fromXML(String string) throws InvalidParameterException, WrappedException {
        return (ServiceInfo)Helper.deserialize("urn:uddi-org:api_v3", "serviceInfo", (Deserializer)ServiceInfoDeserializer.getInstance(), string);
    }

    public static ServiceInfo fromXML(Element element) throws InvalidParameterException, WrappedException {
        return (ServiceInfo)Helper.deserialize("urn:uddi-org:api_v3", "serviceInfo", (Deserializer)ServiceInfoDeserializer.getInstance(), element);
    }

    public static ServiceInfo fromXML(Reader reader) throws InvalidParameterException, WrappedException {
        return (ServiceInfo)Helper.deserialize("urn:uddi-org:api_v3", "serviceInfo", (Deserializer)ServiceInfoDeserializer.getInstance(), reader);
    }

    public static ServiceInfo fromXML(Tokenizer tokenizer) throws InvalidParameterException, WrappedException {
        return (ServiceInfo)Helper.deserialize("urn:uddi-org:api_v3", "serviceInfo", (Deserializer)ServiceInfoDeserializer.getInstance(), tokenizer);
    }

    public static ServiceInfo fromXML(Tokenizer tokenizer, Map mapping) throws InvalidParameterException, WrappedException {
        return (ServiceInfo)Helper.deserialize("urn:uddi-org:api_v3", "serviceInfo", ServiceInfoDeserializer.getInstance(), tokenizer, mapping);
    }

    public void check() throws InvalidParameterException {
        super.check();
        if (this.nameArrayList != null) {
            this.nameArrayList.check();
        }
        if (this.serviceKey == null) {
            throw new InvalidParameterException(InvalidParameterErrorCodes.E_MISSING_REQUIRED_ELEMENT, ResourceBundle.getString("EXC_IsNull_P1", "ServiceInfo.serviceKey"));
        }
        if (this.businessKey == null) {
            throw new InvalidParameterException(InvalidParameterErrorCodes.E_MISSING_REQUIRED_ELEMENT, ResourceBundle.getString("EXC_IsNull_P1", "ServiceInfo.businessKey"));
        }
    }

    public boolean normalize() {
        boolean result = true;
        if (this.nameArrayList != null) {
            if (this.nameArrayList.normalize()) {
                this.nameArrayList = null;
            } else {
                result = false;
            }
        }
        if (this.serviceKey != null) {
            result = false;
        }
        if (this.businessKey != null) {
            result = false;
        }
        return result;
    }

    public Object clone() throws CloneNotSupportedException {
        ServiceInfo theClone = (ServiceInfo)super.clone();
        if (this.nameArrayList != null) {
            theClone.nameArrayList = (NameArrayList)this.nameArrayList.clone();
        }
        return theClone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ServiceInfo)) {
            return false;
        }
        ServiceInfo org_systinet_uddi_client_v3_struct_ServiceInfo = (ServiceInfo)o;
        boolean bl = this.nameArrayList != null ? !this.nameArrayList.equals(org_systinet_uddi_client_v3_struct_ServiceInfo.nameArrayList) : org_systinet_uddi_client_v3_struct_ServiceInfo.nameArrayList != null;
        if (bl) {
            return false;
        }
        boolean bl2 = this.serviceKey != null ? !this.serviceKey.equals(org_systinet_uddi_client_v3_struct_ServiceInfo.serviceKey) : org_systinet_uddi_client_v3_struct_ServiceInfo.serviceKey != null;
        if (bl2) {
            return false;
        }
        return !(this.businessKey != null ? !this.businessKey.equals(org_systinet_uddi_client_v3_struct_ServiceInfo.businessKey) : org_systinet_uddi_client_v3_struct_ServiceInfo.businessKey != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + (this.nameArrayList != null ? this.nameArrayList.hashCode() : 0);
        result = 29 * result + (this.serviceKey != null ? this.serviceKey.hashCode() : 0);
        result = 29 * result + (this.businessKey != null ? this.businessKey.hashCode() : 0);
        return result;
    }
}

