/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.uddi.client.v3.struct;

import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.Map;
import org.idoox.util.WrappedException;
import org.idoox.xml.TokenWriter;
import org.idoox.xml.Tokenizer;
import org.systinet.uddi.InvalidParameterException;
import org.systinet.uddi.client.base.UDDIObject;
import org.systinet.uddi.client.serialization.Deserializer;
import org.systinet.uddi.client.serialization.Serializer;
import org.systinet.uddi.client.v3.serialization.ResultDeserializer;
import org.systinet.uddi.client.v3.serialization.ResultSerializer;
import org.systinet.uddi.client.v3.struct.ErrInfo;
import org.systinet.uddi.client.v3.struct.KeyType;
import org.systinet.uddi.client.v3.util.Helper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Result
extends UDDIObject
implements Cloneable,
Serializable {
    protected ErrInfo errInfo;
    protected KeyType keyType;
    protected int errno;

    public Result() {
    }

    public Result(int errno) throws InvalidParameterException {
        this.setErrno(errno);
    }

    public Result(int errno, ErrInfo errInfo, KeyType keyType) throws InvalidParameterException {
        this.setErrno(errno);
        this.setErrInfo(errInfo);
        this.setKeyType(keyType);
    }

    public ErrInfo getErrInfo() {
        return this.errInfo;
    }

    public void setErrInfo(ErrInfo errInfo) {
        if (errInfo != null) {
            // empty if block
        }
        this.errInfo = errInfo;
    }

    public KeyType getKeyType() {
        return this.keyType;
    }

    public void setKeyType(KeyType keyType) {
        if (keyType != null) {
            // empty if block
        }
        this.keyType = keyType;
    }

    public int getErrno() {
        return this.errno;
    }

    public void setErrno(int errno) {
        this.errno = errno;
    }

    public String toXML() {
        return Helper.serialize(this, "urn:uddi-org:api_v3", "result", ResultSerializer.getInstance());
    }

    public void toXML(StringBuffer stringBuffer) {
        Helper.serialize((Object)this, "urn:uddi-org:api_v3", "result", (Serializer)ResultSerializer.getInstance(), stringBuffer);
    }

    public Element toXML(Document document) {
        return Helper.serialize((Object)this, "urn:uddi-org:api_v3", "result", (Serializer)ResultSerializer.getInstance(), document);
    }

    public void toXML(Writer writer) {
        Helper.serialize((Object)this, "urn:uddi-org:api_v3", "result", (Serializer)ResultSerializer.getInstance(), writer);
    }

    public void toXML(TokenWriter tokenWriter) {
        Helper.serialize((Object)this, "urn:uddi-org:api_v3", "result", (Serializer)ResultSerializer.getInstance(), tokenWriter);
    }

    public void toXML(TokenWriter tokenWriter, Map mapping) {
        Helper.serialize(this, "urn:uddi-org:api_v3", "result", ResultSerializer.getInstance(), tokenWriter, mapping);
    }

    public static Result fromXML(String string) throws InvalidParameterException, WrappedException {
        return (Result)Helper.deserialize("urn:uddi-org:api_v3", "result", (Deserializer)ResultDeserializer.getInstance(), string);
    }

    public static Result fromXML(Element element) throws InvalidParameterException, WrappedException {
        return (Result)Helper.deserialize("urn:uddi-org:api_v3", "result", (Deserializer)ResultDeserializer.getInstance(), element);
    }

    public static Result fromXML(Reader reader) throws InvalidParameterException, WrappedException {
        return (Result)Helper.deserialize("urn:uddi-org:api_v3", "result", (Deserializer)ResultDeserializer.getInstance(), reader);
    }

    public static Result fromXML(Tokenizer tokenizer) throws InvalidParameterException, WrappedException {
        return (Result)Helper.deserialize("urn:uddi-org:api_v3", "result", (Deserializer)ResultDeserializer.getInstance(), tokenizer);
    }

    public static Result fromXML(Tokenizer tokenizer, Map mapping) throws InvalidParameterException, WrappedException {
        return (Result)Helper.deserialize("urn:uddi-org:api_v3", "result", ResultDeserializer.getInstance(), tokenizer, mapping);
    }

    public void check() throws InvalidParameterException {
        super.check();
        if (this.errInfo != null) {
            this.errInfo.check();
        }
        if (this.keyType != null) {
            this.keyType.check();
        }
    }

    public boolean normalize() {
        boolean result = true;
        if (this.errInfo != null) {
            if (this.errInfo.normalize()) {
                this.errInfo = null;
            } else {
                result = false;
            }
        }
        if (this.keyType != null) {
            if (this.keyType.normalize()) {
                this.keyType = null;
            } else {
                result = false;
            }
        }
        result = false;
        return result;
    }

    public Object clone() throws CloneNotSupportedException {
        Result theClone = (Result)super.clone();
        if (this.errInfo != null) {
            theClone.errInfo = (ErrInfo)this.errInfo.clone();
        }
        if (this.keyType != null) {
            theClone.keyType = (KeyType)this.keyType.clone();
        }
        return theClone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Result)) {
            return false;
        }
        Result org_systinet_uddi_client_v3_struct_Result = (Result)o;
        boolean bl = this.errInfo != null ? !this.errInfo.equals(org_systinet_uddi_client_v3_struct_Result.errInfo) : org_systinet_uddi_client_v3_struct_Result.errInfo != null;
        if (bl) {
            return false;
        }
        boolean bl2 = this.keyType != null ? !this.keyType.equals(org_systinet_uddi_client_v3_struct_Result.keyType) : org_systinet_uddi_client_v3_struct_Result.keyType != null;
        if (bl2) {
            return false;
        }
        return this.errno == org_systinet_uddi_client_v3_struct_Result.errno;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + (this.errInfo != null ? this.errInfo.hashCode() : 0);
        result = 29 * result + (this.keyType != null ? this.keyType.hashCode() : 0);
        result = 29 * result + this.errno;
        return result;
    }
}

