/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.uddi.client.v3.struct;

import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.Map;
import org.idoox.util.WrappedException;
import org.idoox.xml.TokenWriter;
import org.idoox.xml.Tokenizer;
import org.systinet.uddi.InvalidParameterErrorCodes;
import org.systinet.uddi.InvalidParameterException;
import org.systinet.uddi.ResourceBundle;
import org.systinet.uddi.client.base.UDDIObject;
import org.systinet.uddi.client.serialization.Deserializer;
import org.systinet.uddi.client.serialization.Serializer;
import org.systinet.uddi.client.util.StringHelper;
import org.systinet.uddi.client.v3.serialization.RelatedBusinessesListDeserializer;
import org.systinet.uddi.client.v3.serialization.RelatedBusinessesListSerializer;
import org.systinet.uddi.client.v3.struct.ListDescription;
import org.systinet.uddi.client.v3.struct.RelatedBusinessInfo;
import org.systinet.uddi.client.v3.struct.RelatedBusinessInfoArrayList;
import org.systinet.uddi.client.v3.util.Helper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RelatedBusinessesList
extends UDDIObject
implements Cloneable,
Serializable {
    protected ListDescription listDescription;
    protected String businessKey;
    protected RelatedBusinessInfoArrayList relatedBusinessInfoArrayList;
    protected Boolean truncated;

    public RelatedBusinessesList() {
    }

    public RelatedBusinessesList(String businessKey) throws InvalidParameterException {
        this.setBusinessKey(businessKey);
    }

    public RelatedBusinessesList(String businessKey, ListDescription listDescription, RelatedBusinessInfoArrayList relatedBusinessInfoArrayList, Boolean truncated) throws InvalidParameterException {
        this.setBusinessKey(businessKey);
        this.setListDescription(listDescription);
        this.setRelatedBusinessInfoArrayList(relatedBusinessInfoArrayList);
        this.setTruncated(truncated);
    }

    public ListDescription getListDescription() {
        return this.listDescription;
    }

    public void setListDescription(ListDescription listDescription) {
        if (listDescription != null) {
            // empty if block
        }
        this.listDescription = listDescription;
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public void setBusinessKey(String businessKey) throws InvalidParameterException {
        if (businessKey == null) {
            throw new InvalidParameterException(InvalidParameterErrorCodes.E_MISSING_REQUIRED_ELEMENT, ResourceBundle.getString("EXC_IsNull_P1", "RelatedBusinessesList.businessKey"));
        }
        if (businessKey != null && (businessKey = StringHelper.whitespaceCollapse(businessKey)).length() > 255) {
            throw new InvalidParameterException(InvalidParameterErrorCodes.E_NAME_TOO_LONG, ResourceBundle.getString("EXC_ValueTooLong_P1", new Object[]{"255"}));
        }
        this.businessKey = businessKey;
    }

    public void addRelatedBusinessInfo(RelatedBusinessInfo item) {
        if (this.relatedBusinessInfoArrayList == null) {
            this.relatedBusinessInfoArrayList = new RelatedBusinessInfoArrayList();
        }
        this.relatedBusinessInfoArrayList.add(item);
    }

    public RelatedBusinessInfoArrayList getRelatedBusinessInfoArrayList() {
        return this.relatedBusinessInfoArrayList;
    }

    public void setRelatedBusinessInfoArrayList(RelatedBusinessInfoArrayList relatedBusinessInfoArrayList) {
        this.relatedBusinessInfoArrayList = relatedBusinessInfoArrayList;
    }

    public Boolean getTruncated() {
        return this.truncated;
    }

    public void setTruncated(Boolean truncated) {
        if (truncated != null) {
            // empty if block
        }
        this.truncated = truncated;
    }

    public String toXML() {
        return Helper.serialize(this, "urn:uddi-org:api_v3", "relatedBusinessesList", RelatedBusinessesListSerializer.getInstance());
    }

    public void toXML(StringBuffer stringBuffer) {
        Helper.serialize((Object)this, "urn:uddi-org:api_v3", "relatedBusinessesList", (Serializer)RelatedBusinessesListSerializer.getInstance(), stringBuffer);
    }

    public Element toXML(Document document) {
        return Helper.serialize((Object)this, "urn:uddi-org:api_v3", "relatedBusinessesList", (Serializer)RelatedBusinessesListSerializer.getInstance(), document);
    }

    public void toXML(Writer writer) {
        Helper.serialize((Object)this, "urn:uddi-org:api_v3", "relatedBusinessesList", (Serializer)RelatedBusinessesListSerializer.getInstance(), writer);
    }

    public void toXML(TokenWriter tokenWriter) {
        Helper.serialize((Object)this, "urn:uddi-org:api_v3", "relatedBusinessesList", (Serializer)RelatedBusinessesListSerializer.getInstance(), tokenWriter);
    }

    public void toXML(TokenWriter tokenWriter, Map mapping) {
        Helper.serialize(this, "urn:uddi-org:api_v3", "relatedBusinessesList", RelatedBusinessesListSerializer.getInstance(), tokenWriter, mapping);
    }

    public static RelatedBusinessesList fromXML(String string) throws InvalidParameterException, WrappedException {
        return (RelatedBusinessesList)Helper.deserialize("urn:uddi-org:api_v3", "relatedBusinessesList", (Deserializer)RelatedBusinessesListDeserializer.getInstance(), string);
    }

    public static RelatedBusinessesList fromXML(Element element) throws InvalidParameterException, WrappedException {
        return (RelatedBusinessesList)Helper.deserialize("urn:uddi-org:api_v3", "relatedBusinessesList", (Deserializer)RelatedBusinessesListDeserializer.getInstance(), element);
    }

    public static RelatedBusinessesList fromXML(Reader reader) throws InvalidParameterException, WrappedException {
        return (RelatedBusinessesList)Helper.deserialize("urn:uddi-org:api_v3", "relatedBusinessesList", (Deserializer)RelatedBusinessesListDeserializer.getInstance(), reader);
    }

    public static RelatedBusinessesList fromXML(Tokenizer tokenizer) throws InvalidParameterException, WrappedException {
        return (RelatedBusinessesList)Helper.deserialize("urn:uddi-org:api_v3", "relatedBusinessesList", (Deserializer)RelatedBusinessesListDeserializer.getInstance(), tokenizer);
    }

    public static RelatedBusinessesList fromXML(Tokenizer tokenizer, Map mapping) throws InvalidParameterException, WrappedException {
        return (RelatedBusinessesList)Helper.deserialize("urn:uddi-org:api_v3", "relatedBusinessesList", RelatedBusinessesListDeserializer.getInstance(), tokenizer, mapping);
    }

    public void check() throws InvalidParameterException {
        super.check();
        if (this.listDescription != null) {
            this.listDescription.check();
        }
        if (this.businessKey == null) {
            throw new InvalidParameterException(InvalidParameterErrorCodes.E_MISSING_REQUIRED_ELEMENT, ResourceBundle.getString("EXC_IsNull_P1", "RelatedBusinessesList.businessKey"));
        }
        if (this.relatedBusinessInfoArrayList != null) {
            if (this.relatedBusinessInfoArrayList.size() < 1) {
                throw new InvalidParameterException(InvalidParameterErrorCodes.E_MISSING_REQUIRED_ELEMENT, ResourceBundle.getString("EXC_IsNull_P1", "RelatedBusinessesList.relatedBusinessInfoArrayList"));
            }
            this.relatedBusinessInfoArrayList.check();
        }
    }

    public boolean normalize() {
        boolean result = true;
        if (this.listDescription != null) {
            if (this.listDescription.normalize()) {
                this.listDescription = null;
            } else {
                result = false;
            }
        }
        if (this.businessKey != null) {
            result = false;
        }
        if (this.relatedBusinessInfoArrayList != null) {
            if (this.relatedBusinessInfoArrayList.normalize()) {
                this.relatedBusinessInfoArrayList = null;
            } else {
                result = false;
            }
        }
        if (this.truncated != null) {
            result = false;
        }
        return result;
    }

    public Object clone() throws CloneNotSupportedException {
        RelatedBusinessesList theClone = (RelatedBusinessesList)super.clone();
        if (this.listDescription != null) {
            theClone.listDescription = (ListDescription)this.listDescription.clone();
        }
        if (this.relatedBusinessInfoArrayList != null) {
            theClone.relatedBusinessInfoArrayList = (RelatedBusinessInfoArrayList)this.relatedBusinessInfoArrayList.clone();
        }
        if (this.truncated != null) {
            theClone.truncated = new Boolean(this.truncated);
        }
        return theClone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RelatedBusinessesList)) {
            return false;
        }
        RelatedBusinessesList org_systinet_uddi_client_v3_struct_RelatedBusinessesList = (RelatedBusinessesList)o;
        boolean bl = this.listDescription != null ? !this.listDescription.equals(org_systinet_uddi_client_v3_struct_RelatedBusinessesList.listDescription) : org_systinet_uddi_client_v3_struct_RelatedBusinessesList.listDescription != null;
        if (bl) {
            return false;
        }
        boolean bl2 = this.businessKey != null ? !this.businessKey.equals(org_systinet_uddi_client_v3_struct_RelatedBusinessesList.businessKey) : org_systinet_uddi_client_v3_struct_RelatedBusinessesList.businessKey != null;
        if (bl2) {
            return false;
        }
        boolean bl3 = this.relatedBusinessInfoArrayList != null ? !this.relatedBusinessInfoArrayList.equals(org_systinet_uddi_client_v3_struct_RelatedBusinessesList.relatedBusinessInfoArrayList) : org_systinet_uddi_client_v3_struct_RelatedBusinessesList.relatedBusinessInfoArrayList != null;
        if (bl3) {
            return false;
        }
        return !(this.truncated != null ? !this.truncated.equals(org_systinet_uddi_client_v3_struct_RelatedBusinessesList.truncated) : org_systinet_uddi_client_v3_struct_RelatedBusinessesList.truncated != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + (this.listDescription != null ? this.listDescription.hashCode() : 0);
        result = 29 * result + (this.businessKey != null ? this.businessKey.hashCode() : 0);
        result = 29 * result + (this.relatedBusinessInfoArrayList != null ? this.relatedBusinessInfoArrayList.hashCode() : 0);
        result = 29 * result + (this.truncated != null ? this.truncated.hashCode() : 0);
        return result;
    }
}

