/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.uddi.client.v3.struct;

import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.Map;
import org.idoox.util.WrappedException;
import org.idoox.xml.TokenWriter;
import org.idoox.xml.Tokenizer;
import org.systinet.uddi.InvalidParameterErrorCodes;
import org.systinet.uddi.InvalidParameterException;
import org.systinet.uddi.ResourceBundle;
import org.systinet.uddi.client.base.UDDIObject;
import org.systinet.uddi.client.serialization.Deserializer;
import org.systinet.uddi.client.serialization.Serializer;
import org.systinet.uddi.client.util.StringHelper;
import org.systinet.uddi.client.v3.serialization.RelatedBusinessInfoDeserializer;
import org.systinet.uddi.client.v3.serialization.RelatedBusinessInfoSerializer;
import org.systinet.uddi.client.v3.struct.Description;
import org.systinet.uddi.client.v3.struct.DescriptionArrayList;
import org.systinet.uddi.client.v3.struct.Name;
import org.systinet.uddi.client.v3.struct.NameArrayList;
import org.systinet.uddi.client.v3.struct.SharedRelationships;
import org.systinet.uddi.client.v3.struct.SharedRelationshipsArrayList;
import org.systinet.uddi.client.v3.util.Helper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RelatedBusinessInfo
extends UDDIObject
implements Cloneable,
Serializable {
    protected String businessKey;
    protected NameArrayList nameArrayList;
    protected DescriptionArrayList descriptionArrayList;
    protected SharedRelationshipsArrayList sharedRelationshipsArrayList;

    public RelatedBusinessInfo() {
    }

    public RelatedBusinessInfo(String businessKey, NameArrayList nameArrayList, SharedRelationshipsArrayList sharedRelationshipsArrayList) throws InvalidParameterException {
        this.setBusinessKey(businessKey);
        this.setNameArrayList(nameArrayList);
        this.setSharedRelationshipsArrayList(sharedRelationshipsArrayList);
    }

    public RelatedBusinessInfo(String businessKey, NameArrayList nameArrayList, SharedRelationshipsArrayList sharedRelationshipsArrayList, DescriptionArrayList descriptionArrayList) throws InvalidParameterException {
        this.setBusinessKey(businessKey);
        this.setNameArrayList(nameArrayList);
        this.setSharedRelationshipsArrayList(sharedRelationshipsArrayList);
        this.setDescriptionArrayList(descriptionArrayList);
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public void setBusinessKey(String businessKey) throws InvalidParameterException {
        if (businessKey == null) {
            throw new InvalidParameterException(InvalidParameterErrorCodes.E_MISSING_REQUIRED_ELEMENT, ResourceBundle.getString("EXC_IsNull_P1", "RelatedBusinessInfo.businessKey"));
        }
        if (businessKey != null && (businessKey = StringHelper.whitespaceCollapse(businessKey)).length() > 255) {
            throw new InvalidParameterException(InvalidParameterErrorCodes.E_NAME_TOO_LONG, ResourceBundle.getString("EXC_ValueTooLong_P1", new Object[]{"255"}));
        }
        this.businessKey = businessKey;
    }

    public void addName(Name item) {
        if (this.nameArrayList == null) {
            this.nameArrayList = new NameArrayList();
        }
        this.nameArrayList.add(item);
    }

    public NameArrayList getNameArrayList() {
        return this.nameArrayList;
    }

    public void setNameArrayList(NameArrayList nameArrayList) throws InvalidParameterException {
        if (nameArrayList == null) {
            throw new InvalidParameterException(InvalidParameterErrorCodes.E_MISSING_REQUIRED_ELEMENT, ResourceBundle.getString("EXC_IsNull_P1", "nameArrayList"));
        }
        this.nameArrayList = nameArrayList;
    }

    public void addDescription(Description item) {
        if (this.descriptionArrayList == null) {
            this.descriptionArrayList = new DescriptionArrayList();
        }
        this.descriptionArrayList.add(item);
    }

    public DescriptionArrayList getDescriptionArrayList() {
        return this.descriptionArrayList;
    }

    public void setDescriptionArrayList(DescriptionArrayList descriptionArrayList) throws InvalidParameterException {
        this.descriptionArrayList = descriptionArrayList;
    }

    public void addSharedRelationships(SharedRelationships item) {
        if (this.sharedRelationshipsArrayList == null) {
            this.sharedRelationshipsArrayList = new SharedRelationshipsArrayList();
        }
        this.sharedRelationshipsArrayList.add(item);
    }

    public SharedRelationshipsArrayList getSharedRelationshipsArrayList() {
        return this.sharedRelationshipsArrayList;
    }

    public void setSharedRelationshipsArrayList(SharedRelationshipsArrayList sharedRelationshipsArrayList) throws InvalidParameterException {
        if (sharedRelationshipsArrayList == null) {
            throw new InvalidParameterException(InvalidParameterErrorCodes.E_MISSING_REQUIRED_ELEMENT, ResourceBundle.getString("EXC_IsNull_P1", "sharedRelationshipsArrayList"));
        }
        this.sharedRelationshipsArrayList = sharedRelationshipsArrayList;
    }

    public String toXML() {
        return Helper.serialize(this, "urn:uddi-org:api_v3", "relatedBusinessInfo", RelatedBusinessInfoSerializer.getInstance());
    }

    public void toXML(StringBuffer stringBuffer) {
        Helper.serialize((Object)this, "urn:uddi-org:api_v3", "relatedBusinessInfo", (Serializer)RelatedBusinessInfoSerializer.getInstance(), stringBuffer);
    }

    public Element toXML(Document document) {
        return Helper.serialize((Object)this, "urn:uddi-org:api_v3", "relatedBusinessInfo", (Serializer)RelatedBusinessInfoSerializer.getInstance(), document);
    }

    public void toXML(Writer writer) {
        Helper.serialize((Object)this, "urn:uddi-org:api_v3", "relatedBusinessInfo", (Serializer)RelatedBusinessInfoSerializer.getInstance(), writer);
    }

    public void toXML(TokenWriter tokenWriter) {
        Helper.serialize((Object)this, "urn:uddi-org:api_v3", "relatedBusinessInfo", (Serializer)RelatedBusinessInfoSerializer.getInstance(), tokenWriter);
    }

    public void toXML(TokenWriter tokenWriter, Map mapping) {
        Helper.serialize(this, "urn:uddi-org:api_v3", "relatedBusinessInfo", RelatedBusinessInfoSerializer.getInstance(), tokenWriter, mapping);
    }

    public static RelatedBusinessInfo fromXML(String string) throws InvalidParameterException, WrappedException {
        return (RelatedBusinessInfo)Helper.deserialize("urn:uddi-org:api_v3", "relatedBusinessInfo", (Deserializer)RelatedBusinessInfoDeserializer.getInstance(), string);
    }

    public static RelatedBusinessInfo fromXML(Element element) throws InvalidParameterException, WrappedException {
        return (RelatedBusinessInfo)Helper.deserialize("urn:uddi-org:api_v3", "relatedBusinessInfo", (Deserializer)RelatedBusinessInfoDeserializer.getInstance(), element);
    }

    public static RelatedBusinessInfo fromXML(Reader reader) throws InvalidParameterException, WrappedException {
        return (RelatedBusinessInfo)Helper.deserialize("urn:uddi-org:api_v3", "relatedBusinessInfo", (Deserializer)RelatedBusinessInfoDeserializer.getInstance(), reader);
    }

    public static RelatedBusinessInfo fromXML(Tokenizer tokenizer) throws InvalidParameterException, WrappedException {
        return (RelatedBusinessInfo)Helper.deserialize("urn:uddi-org:api_v3", "relatedBusinessInfo", (Deserializer)RelatedBusinessInfoDeserializer.getInstance(), tokenizer);
    }

    public static RelatedBusinessInfo fromXML(Tokenizer tokenizer, Map mapping) throws InvalidParameterException, WrappedException {
        return (RelatedBusinessInfo)Helper.deserialize("urn:uddi-org:api_v3", "relatedBusinessInfo", RelatedBusinessInfoDeserializer.getInstance(), tokenizer, mapping);
    }

    public void check() throws InvalidParameterException {
        super.check();
        if (this.businessKey == null) {
            throw new InvalidParameterException(InvalidParameterErrorCodes.E_MISSING_REQUIRED_ELEMENT, ResourceBundle.getString("EXC_IsNull_P1", "RelatedBusinessInfo.businessKey"));
        }
        if (this.nameArrayList == null || this.nameArrayList.size() < 1) {
            throw new InvalidParameterException(InvalidParameterErrorCodes.E_MISSING_REQUIRED_ELEMENT, ResourceBundle.getString("EXC_IsNull_P1", "RelatedBusinessInfo.nameArrayList"));
        }
        this.nameArrayList.check();
        if (this.descriptionArrayList != null) {
            this.descriptionArrayList.check();
        }
        if (this.sharedRelationshipsArrayList == null || this.sharedRelationshipsArrayList.size() < 1) {
            throw new InvalidParameterException(InvalidParameterErrorCodes.E_MISSING_REQUIRED_ELEMENT, ResourceBundle.getString("EXC_IsNull_P1", "RelatedBusinessInfo.sharedRelationshipsArrayList"));
        }
        this.sharedRelationshipsArrayList.check();
    }

    public boolean normalize() {
        boolean result = true;
        if (this.businessKey != null) {
            result = false;
        }
        if (this.nameArrayList != null) {
            if (this.nameArrayList.normalize()) {
                this.nameArrayList = null;
            } else {
                result = false;
            }
        }
        if (this.descriptionArrayList != null) {
            if (this.descriptionArrayList.normalize()) {
                this.descriptionArrayList = null;
            } else {
                result = false;
            }
        }
        if (this.sharedRelationshipsArrayList != null) {
            if (this.sharedRelationshipsArrayList.normalize()) {
                this.sharedRelationshipsArrayList = null;
            } else {
                result = false;
            }
        }
        return result;
    }

    public Object clone() throws CloneNotSupportedException {
        RelatedBusinessInfo theClone = (RelatedBusinessInfo)super.clone();
        if (this.nameArrayList != null) {
            theClone.nameArrayList = (NameArrayList)this.nameArrayList.clone();
        }
        if (this.descriptionArrayList != null) {
            theClone.descriptionArrayList = (DescriptionArrayList)this.descriptionArrayList.clone();
        }
        if (this.sharedRelationshipsArrayList != null) {
            theClone.sharedRelationshipsArrayList = (SharedRelationshipsArrayList)this.sharedRelationshipsArrayList.clone();
        }
        return theClone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RelatedBusinessInfo)) {
            return false;
        }
        RelatedBusinessInfo org_systinet_uddi_client_v3_struct_RelatedBusinessInfo = (RelatedBusinessInfo)o;
        boolean bl = this.businessKey != null ? !this.businessKey.equals(org_systinet_uddi_client_v3_struct_RelatedBusinessInfo.businessKey) : org_systinet_uddi_client_v3_struct_RelatedBusinessInfo.businessKey != null;
        if (bl) {
            return false;
        }
        boolean bl2 = this.nameArrayList != null ? !this.nameArrayList.equals(org_systinet_uddi_client_v3_struct_RelatedBusinessInfo.nameArrayList) : org_systinet_uddi_client_v3_struct_RelatedBusinessInfo.nameArrayList != null;
        if (bl2) {
            return false;
        }
        boolean bl3 = this.descriptionArrayList != null ? !this.descriptionArrayList.equals(org_systinet_uddi_client_v3_struct_RelatedBusinessInfo.descriptionArrayList) : org_systinet_uddi_client_v3_struct_RelatedBusinessInfo.descriptionArrayList != null;
        if (bl3) {
            return false;
        }
        return !(this.sharedRelationshipsArrayList != null ? !this.sharedRelationshipsArrayList.equals(org_systinet_uddi_client_v3_struct_RelatedBusinessInfo.sharedRelationshipsArrayList) : org_systinet_uddi_client_v3_struct_RelatedBusinessInfo.sharedRelationshipsArrayList != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + (this.businessKey != null ? this.businessKey.hashCode() : 0);
        result = 29 * result + (this.nameArrayList != null ? this.nameArrayList.hashCode() : 0);
        result = 29 * result + (this.descriptionArrayList != null ? this.descriptionArrayList.hashCode() : 0);
        result = 29 * result + (this.sharedRelationshipsArrayList != null ? this.sharedRelationshipsArrayList.hashCode() : 0);
        return result;
    }
}

