/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.uddi.client.v3.struct;

import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.Map;
import org.idoox.util.WrappedException;
import org.idoox.xml.TokenWriter;
import org.idoox.xml.Tokenizer;
import org.systinet.uddi.InvalidParameterErrorCodes;
import org.systinet.uddi.InvalidParameterException;
import org.systinet.uddi.ResourceBundle;
import org.systinet.uddi.client.base.ElementArrayList;
import org.systinet.uddi.client.base.UDDIObject;
import org.systinet.uddi.client.serialization.Deserializer;
import org.systinet.uddi.client.serialization.Serializer;
import org.systinet.uddi.client.util.StringHelper;
import org.systinet.uddi.client.v3.serialization.PublisherAssertionDeserializer;
import org.systinet.uddi.client.v3.serialization.PublisherAssertionSerializer;
import org.systinet.uddi.client.v3.struct.KeyedReference;
import org.systinet.uddi.client.v3.util.Helper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PublisherAssertion
extends UDDIObject
implements Cloneable,
Serializable {
    protected String fromKey;
    protected String toKey;
    protected KeyedReference keyedReference;
    protected ElementArrayList SignatureArrayList;

    public PublisherAssertion() {
    }

    public PublisherAssertion(String fromKey, String toKey, KeyedReference keyedReference) throws InvalidParameterException {
        this.setFromKey(fromKey);
        this.setToKey(toKey);
        this.setKeyedReference(keyedReference);
    }

    public PublisherAssertion(String fromKey, String toKey, KeyedReference keyedReference, ElementArrayList SignatureArrayList) throws InvalidParameterException {
        this.setFromKey(fromKey);
        this.setToKey(toKey);
        this.setKeyedReference(keyedReference);
        this.setSignatureArrayList(SignatureArrayList);
    }

    public String getFromKey() {
        return this.fromKey;
    }

    public void setFromKey(String fromKey) throws InvalidParameterException {
        if (fromKey == null) {
            throw new InvalidParameterException(InvalidParameterErrorCodes.E_MISSING_REQUIRED_ELEMENT, ResourceBundle.getString("EXC_IsNull_P1", "PublisherAssertion.fromKey"));
        }
        if (fromKey != null && (fromKey = StringHelper.whitespaceCollapse(fromKey)).length() > 255) {
            throw new InvalidParameterException(InvalidParameterErrorCodes.E_NAME_TOO_LONG, ResourceBundle.getString("EXC_ValueTooLong_P1", new Object[]{"255"}));
        }
        this.fromKey = fromKey;
    }

    public String getToKey() {
        return this.toKey;
    }

    public void setToKey(String toKey) throws InvalidParameterException {
        if (toKey == null) {
            throw new InvalidParameterException(InvalidParameterErrorCodes.E_MISSING_REQUIRED_ELEMENT, ResourceBundle.getString("EXC_IsNull_P1", "PublisherAssertion.toKey"));
        }
        if (toKey != null && (toKey = StringHelper.whitespaceCollapse(toKey)).length() > 255) {
            throw new InvalidParameterException(InvalidParameterErrorCodes.E_NAME_TOO_LONG, ResourceBundle.getString("EXC_ValueTooLong_P1", new Object[]{"255"}));
        }
        this.toKey = toKey;
    }

    public KeyedReference getKeyedReference() {
        return this.keyedReference;
    }

    public void setKeyedReference(KeyedReference keyedReference) throws InvalidParameterException {
        if (keyedReference == null) {
            throw new InvalidParameterException(InvalidParameterErrorCodes.E_MISSING_REQUIRED_ELEMENT, ResourceBundle.getString("EXC_IsNull_P1", "PublisherAssertion.keyedReference"));
        }
        if (keyedReference != null) {
            // empty if block
        }
        this.keyedReference = keyedReference;
    }

    public void addSignature(Element item) {
        if (this.SignatureArrayList == null) {
            this.SignatureArrayList = new ElementArrayList();
        }
        this.SignatureArrayList.add(item);
    }

    public ElementArrayList getSignatureArrayList() {
        return this.SignatureArrayList;
    }

    public void setSignatureArrayList(ElementArrayList SignatureArrayList) throws InvalidParameterException {
        this.SignatureArrayList = SignatureArrayList;
    }

    public String toXML() {
        return Helper.serialize(this, "urn:uddi-org:api_v3", "publisherAssertion", PublisherAssertionSerializer.getInstance());
    }

    public void toXML(StringBuffer stringBuffer) {
        Helper.serialize((Object)this, "urn:uddi-org:api_v3", "publisherAssertion", (Serializer)PublisherAssertionSerializer.getInstance(), stringBuffer);
    }

    public Element toXML(Document document) {
        return Helper.serialize((Object)this, "urn:uddi-org:api_v3", "publisherAssertion", (Serializer)PublisherAssertionSerializer.getInstance(), document);
    }

    public void toXML(Writer writer) {
        Helper.serialize((Object)this, "urn:uddi-org:api_v3", "publisherAssertion", (Serializer)PublisherAssertionSerializer.getInstance(), writer);
    }

    public void toXML(TokenWriter tokenWriter) {
        Helper.serialize((Object)this, "urn:uddi-org:api_v3", "publisherAssertion", (Serializer)PublisherAssertionSerializer.getInstance(), tokenWriter);
    }

    public void toXML(TokenWriter tokenWriter, Map mapping) {
        Helper.serialize(this, "urn:uddi-org:api_v3", "publisherAssertion", PublisherAssertionSerializer.getInstance(), tokenWriter, mapping);
    }

    public static PublisherAssertion fromXML(String string) throws InvalidParameterException, WrappedException {
        return (PublisherAssertion)Helper.deserialize("urn:uddi-org:api_v3", "publisherAssertion", (Deserializer)PublisherAssertionDeserializer.getInstance(), string);
    }

    public static PublisherAssertion fromXML(Element element) throws InvalidParameterException, WrappedException {
        return (PublisherAssertion)Helper.deserialize("urn:uddi-org:api_v3", "publisherAssertion", (Deserializer)PublisherAssertionDeserializer.getInstance(), element);
    }

    public static PublisherAssertion fromXML(Reader reader) throws InvalidParameterException, WrappedException {
        return (PublisherAssertion)Helper.deserialize("urn:uddi-org:api_v3", "publisherAssertion", (Deserializer)PublisherAssertionDeserializer.getInstance(), reader);
    }

    public static PublisherAssertion fromXML(Tokenizer tokenizer) throws InvalidParameterException, WrappedException {
        return (PublisherAssertion)Helper.deserialize("urn:uddi-org:api_v3", "publisherAssertion", (Deserializer)PublisherAssertionDeserializer.getInstance(), tokenizer);
    }

    public static PublisherAssertion fromXML(Tokenizer tokenizer, Map mapping) throws InvalidParameterException, WrappedException {
        return (PublisherAssertion)Helper.deserialize("urn:uddi-org:api_v3", "publisherAssertion", PublisherAssertionDeserializer.getInstance(), tokenizer, mapping);
    }

    public void check() throws InvalidParameterException {
        super.check();
        if (this.fromKey == null) {
            throw new InvalidParameterException(InvalidParameterErrorCodes.E_MISSING_REQUIRED_ELEMENT, ResourceBundle.getString("EXC_IsNull_P1", "PublisherAssertion.fromKey"));
        }
        if (this.toKey == null) {
            throw new InvalidParameterException(InvalidParameterErrorCodes.E_MISSING_REQUIRED_ELEMENT, ResourceBundle.getString("EXC_IsNull_P1", "PublisherAssertion.toKey"));
        }
        if (this.keyedReference == null) {
            throw new InvalidParameterException(InvalidParameterErrorCodes.E_MISSING_REQUIRED_ELEMENT, ResourceBundle.getString("EXC_IsNull_P1", "PublisherAssertion.keyedReference"));
        }
        this.keyedReference.check();
        if (this.SignatureArrayList != null) {
            this.SignatureArrayList.check();
        }
    }

    public boolean normalize() {
        boolean result = true;
        if (this.fromKey != null) {
            result = false;
        }
        if (this.toKey != null) {
            result = false;
        }
        if (this.keyedReference != null) {
            this.keyedReference.normalize();
            result = false;
        }
        if (this.SignatureArrayList != null) {
            if (this.SignatureArrayList.normalize()) {
                this.SignatureArrayList = null;
            } else {
                result = false;
            }
        }
        return result;
    }

    public Object clone() throws CloneNotSupportedException {
        PublisherAssertion theClone = (PublisherAssertion)super.clone();
        if (this.keyedReference != null) {
            theClone.keyedReference = (KeyedReference)this.keyedReference.clone();
        }
        if (this.SignatureArrayList != null) {
            theClone.SignatureArrayList = (ElementArrayList)this.SignatureArrayList.clone();
        }
        return theClone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PublisherAssertion)) {
            return false;
        }
        PublisherAssertion org_systinet_uddi_client_v3_struct_PublisherAssertion = (PublisherAssertion)o;
        boolean bl = this.fromKey != null ? !this.fromKey.equals(org_systinet_uddi_client_v3_struct_PublisherAssertion.fromKey) : org_systinet_uddi_client_v3_struct_PublisherAssertion.fromKey != null;
        if (bl) {
            return false;
        }
        boolean bl2 = this.toKey != null ? !this.toKey.equals(org_systinet_uddi_client_v3_struct_PublisherAssertion.toKey) : org_systinet_uddi_client_v3_struct_PublisherAssertion.toKey != null;
        if (bl2) {
            return false;
        }
        boolean bl3 = this.keyedReference != null ? !this.keyedReference.equals(org_systinet_uddi_client_v3_struct_PublisherAssertion.keyedReference) : org_systinet_uddi_client_v3_struct_PublisherAssertion.keyedReference != null;
        if (bl3) {
            return false;
        }
        return !(this.SignatureArrayList != null ? !this.SignatureArrayList.equals(org_systinet_uddi_client_v3_struct_PublisherAssertion.SignatureArrayList) : org_systinet_uddi_client_v3_struct_PublisherAssertion.SignatureArrayList != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + (this.fromKey != null ? this.fromKey.hashCode() : 0);
        result = 29 * result + (this.toKey != null ? this.toKey.hashCode() : 0);
        result = 29 * result + (this.keyedReference != null ? this.keyedReference.hashCode() : 0);
        result = 29 * result + (this.SignatureArrayList != null ? this.SignatureArrayList.hashCode() : 0);
        return result;
    }
}

