/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.uddi.client.v3.struct;

import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.Map;
import org.idoox.util.WrappedException;
import org.idoox.xml.TokenWriter;
import org.idoox.xml.Tokenizer;
import org.systinet.uddi.InvalidParameterErrorCodes;
import org.systinet.uddi.InvalidParameterException;
import org.systinet.uddi.ResourceBundle;
import org.systinet.uddi.client.base.UDDIObject;
import org.systinet.uddi.client.serialization.Deserializer;
import org.systinet.uddi.client.serialization.Serializer;
import org.systinet.uddi.client.util.StringHelper;
import org.systinet.uddi.client.v3.serialization.PersonNameDeserializer;
import org.systinet.uddi.client.v3.serialization.PersonNameSerializer;
import org.systinet.uddi.client.v3.util.Helper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PersonName
extends UDDIObject
implements Cloneable,
Serializable {
    private String lang;
    private String value;

    public PersonName() {
    }

    public PersonName(String value) throws InvalidParameterException {
        this.setValue(value);
    }

    public PersonName(String value, String lang) throws InvalidParameterException {
        this.setValue(value);
        this.setLang(lang);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) throws InvalidParameterException {
        if (value != null) {
            if ((value = StringHelper.whitespaceCollapse(value)).length() < 1) {
                throw new InvalidParameterException(InvalidParameterErrorCodes.E_NAME_TOO_SHORT, ResourceBundle.getString("EXC_ValueTooShort_P1", new Object[]{"1"}));
            }
            if (value.length() > 255) {
                throw new InvalidParameterException(InvalidParameterErrorCodes.E_NAME_TOO_LONG, ResourceBundle.getString("EXC_ValueTooLong_P1", new Object[]{"255"}));
            }
        }
        this.value = value;
    }

    public String getLang() {
        return this.lang;
    }

    public void setLang(String lang) {
        if (lang != null) {
            // empty if block
        }
        this.lang = lang;
    }

    public String toXML() {
        return Helper.serialize(this, "urn:uddi-org:api_v3", "personName", PersonNameSerializer.getInstance());
    }

    public void toXML(StringBuffer stringBuffer) {
        Helper.serialize((Object)this, "urn:uddi-org:api_v3", "personName", (Serializer)PersonNameSerializer.getInstance(), stringBuffer);
    }

    public Element toXML(Document document) {
        return Helper.serialize((Object)this, "urn:uddi-org:api_v3", "personName", (Serializer)PersonNameSerializer.getInstance(), document);
    }

    public void toXML(Writer writer) {
        Helper.serialize((Object)this, "urn:uddi-org:api_v3", "personName", (Serializer)PersonNameSerializer.getInstance(), writer);
    }

    public void toXML(TokenWriter tokenWriter) {
        Helper.serialize((Object)this, "urn:uddi-org:api_v3", "personName", (Serializer)PersonNameSerializer.getInstance(), tokenWriter);
    }

    public void toXML(TokenWriter tokenWriter, Map mapping) {
        Helper.serialize(this, "urn:uddi-org:api_v3", "personName", PersonNameSerializer.getInstance(), tokenWriter, mapping);
    }

    public static PersonName fromXML(String string) throws InvalidParameterException, WrappedException {
        return (PersonName)Helper.deserialize("urn:uddi-org:api_v3", "personName", (Deserializer)PersonNameDeserializer.getInstance(), string);
    }

    public static PersonName fromXML(Element element) throws InvalidParameterException, WrappedException {
        return (PersonName)Helper.deserialize("urn:uddi-org:api_v3", "personName", (Deserializer)PersonNameDeserializer.getInstance(), element);
    }

    public static PersonName fromXML(Reader reader) throws InvalidParameterException, WrappedException {
        return (PersonName)Helper.deserialize("urn:uddi-org:api_v3", "personName", (Deserializer)PersonNameDeserializer.getInstance(), reader);
    }

    public static PersonName fromXML(Tokenizer tokenizer) throws InvalidParameterException, WrappedException {
        return (PersonName)Helper.deserialize("urn:uddi-org:api_v3", "personName", (Deserializer)PersonNameDeserializer.getInstance(), tokenizer);
    }

    public static PersonName fromXML(Tokenizer tokenizer, Map mapping) throws InvalidParameterException, WrappedException {
        return (PersonName)Helper.deserialize("urn:uddi-org:api_v3", "personName", PersonNameDeserializer.getInstance(), tokenizer, mapping);
    }

    public void check() throws InvalidParameterException {
        super.check();
        if (this.value == null) {
            throw new InvalidParameterException(InvalidParameterErrorCodes.E_MISSING_REQUIRED_ELEMENT, ResourceBundle.getString("EXC_IsNull_P1", "PersonName.value"));
        }
    }

    public boolean normalize() {
        boolean result = true;
        if (this.value != null) {
            result = false;
        }
        if (this.lang != null) {
            result = false;
        }
        return result;
    }

    public Object clone() throws CloneNotSupportedException {
        PersonName theClone = (PersonName)super.clone();
        return theClone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PersonName)) {
            return false;
        }
        PersonName org_systinet_uddi_client_v3_struct_PersonName = (PersonName)o;
        boolean bl = this.value != null ? !this.value.equals(org_systinet_uddi_client_v3_struct_PersonName.value) : org_systinet_uddi_client_v3_struct_PersonName.value != null;
        if (bl) {
            return false;
        }
        return !(this.lang != null ? !this.lang.equals(org_systinet_uddi_client_v3_struct_PersonName.lang) : org_systinet_uddi_client_v3_struct_PersonName.lang != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 29 * result + (this.lang != null ? this.lang.hashCode() : 0);
        return result;
    }
}

