/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.uddi.client.v3.struct;

import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.Map;
import org.idoox.util.WrappedException;
import org.idoox.xml.TokenWriter;
import org.idoox.xml.Tokenizer;
import org.systinet.uddi.InvalidParameterErrorCodes;
import org.systinet.uddi.InvalidParameterException;
import org.systinet.uddi.ResourceBundle;
import org.systinet.uddi.client.base.UDDIObject;
import org.systinet.uddi.client.serialization.Deserializer;
import org.systinet.uddi.client.serialization.Serializer;
import org.systinet.uddi.client.util.StringHelper;
import org.systinet.uddi.client.v3.serialization.OverviewURLDeserializer;
import org.systinet.uddi.client.v3.serialization.OverviewURLSerializer;
import org.systinet.uddi.client.v3.util.Helper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class OverviewURL
extends UDDIObject
implements Cloneable,
Serializable {
    private String useType;
    private String value;

    public OverviewURL() {
    }

    public OverviewURL(String value) throws InvalidParameterException {
        this.setValue(value);
    }

    public OverviewURL(String value, String useType) throws InvalidParameterException {
        this.setValue(value);
        this.setUseType(useType);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) throws InvalidParameterException {
        if (value != null) {
            if ((value = StringHelper.whitespaceCollapse(value)).length() < 1) {
                throw new InvalidParameterException(InvalidParameterErrorCodes.E_NAME_TOO_SHORT, ResourceBundle.getString("EXC_ValueTooShort_P1", new Object[]{"1"}));
            }
            if (value.length() > 4096) {
                throw new InvalidParameterException(InvalidParameterErrorCodes.E_NAME_TOO_LONG, ResourceBundle.getString("EXC_ValueTooLong_P1", new Object[]{"4096"}));
            }
        }
        this.value = value;
    }

    public String getUseType() {
        return this.useType;
    }

    public void setUseType(String useType) throws InvalidParameterException {
        if (useType != null && (useType = StringHelper.whitespaceCollapse(useType)).length() > 255) {
            throw new InvalidParameterException(InvalidParameterErrorCodes.E_NAME_TOO_LONG, ResourceBundle.getString("EXC_ValueTooLong_P1", new Object[]{"255"}));
        }
        this.useType = useType;
    }

    public String toXML() {
        return Helper.serialize(this, "urn:uddi-org:api_v3", "overviewURL", OverviewURLSerializer.getInstance());
    }

    public void toXML(StringBuffer stringBuffer) {
        Helper.serialize((Object)this, "urn:uddi-org:api_v3", "overviewURL", (Serializer)OverviewURLSerializer.getInstance(), stringBuffer);
    }

    public Element toXML(Document document) {
        return Helper.serialize((Object)this, "urn:uddi-org:api_v3", "overviewURL", (Serializer)OverviewURLSerializer.getInstance(), document);
    }

    public void toXML(Writer writer) {
        Helper.serialize((Object)this, "urn:uddi-org:api_v3", "overviewURL", (Serializer)OverviewURLSerializer.getInstance(), writer);
    }

    public void toXML(TokenWriter tokenWriter) {
        Helper.serialize((Object)this, "urn:uddi-org:api_v3", "overviewURL", (Serializer)OverviewURLSerializer.getInstance(), tokenWriter);
    }

    public void toXML(TokenWriter tokenWriter, Map mapping) {
        Helper.serialize(this, "urn:uddi-org:api_v3", "overviewURL", OverviewURLSerializer.getInstance(), tokenWriter, mapping);
    }

    public static OverviewURL fromXML(String string) throws InvalidParameterException, WrappedException {
        return (OverviewURL)Helper.deserialize("urn:uddi-org:api_v3", "overviewURL", (Deserializer)OverviewURLDeserializer.getInstance(), string);
    }

    public static OverviewURL fromXML(Element element) throws InvalidParameterException, WrappedException {
        return (OverviewURL)Helper.deserialize("urn:uddi-org:api_v3", "overviewURL", (Deserializer)OverviewURLDeserializer.getInstance(), element);
    }

    public static OverviewURL fromXML(Reader reader) throws InvalidParameterException, WrappedException {
        return (OverviewURL)Helper.deserialize("urn:uddi-org:api_v3", "overviewURL", (Deserializer)OverviewURLDeserializer.getInstance(), reader);
    }

    public static OverviewURL fromXML(Tokenizer tokenizer) throws InvalidParameterException, WrappedException {
        return (OverviewURL)Helper.deserialize("urn:uddi-org:api_v3", "overviewURL", (Deserializer)OverviewURLDeserializer.getInstance(), tokenizer);
    }

    public static OverviewURL fromXML(Tokenizer tokenizer, Map mapping) throws InvalidParameterException, WrappedException {
        return (OverviewURL)Helper.deserialize("urn:uddi-org:api_v3", "overviewURL", OverviewURLDeserializer.getInstance(), tokenizer, mapping);
    }

    public void check() throws InvalidParameterException {
        super.check();
        if (this.value == null) {
            throw new InvalidParameterException(InvalidParameterErrorCodes.E_MISSING_REQUIRED_ELEMENT, ResourceBundle.getString("EXC_IsNull_P1", "OverviewURL.value"));
        }
    }

    public boolean normalize() {
        boolean result = true;
        if (this.value != null) {
            result = false;
        }
        if (this.useType != null) {
            result = false;
        }
        return result;
    }

    public Object clone() throws CloneNotSupportedException {
        OverviewURL theClone = (OverviewURL)super.clone();
        return theClone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OverviewURL)) {
            return false;
        }
        OverviewURL org_systinet_uddi_client_v3_struct_OverviewURL = (OverviewURL)o;
        boolean bl = this.value != null ? !this.value.equals(org_systinet_uddi_client_v3_struct_OverviewURL.value) : org_systinet_uddi_client_v3_struct_OverviewURL.value != null;
        if (bl) {
            return false;
        }
        return !(this.useType != null ? !this.useType.equals(org_systinet_uddi_client_v3_struct_OverviewURL.useType) : org_systinet_uddi_client_v3_struct_OverviewURL.useType != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 29 * result + (this.useType != null ? this.useType.hashCode() : 0);
        return result;
    }
}

