/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.uddi.client.v3.struct;

import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.Date;
import java.util.Map;
import org.idoox.util.WrappedException;
import org.idoox.xml.TokenWriter;
import org.idoox.xml.Tokenizer;
import org.systinet.uddi.InvalidParameterErrorCodes;
import org.systinet.uddi.InvalidParameterException;
import org.systinet.uddi.ResourceBundle;
import org.systinet.uddi.client.base.UDDIObject;
import org.systinet.uddi.client.serialization.Deserializer;
import org.systinet.uddi.client.serialization.Serializer;
import org.systinet.uddi.client.util.StringHelper;
import org.systinet.uddi.client.v3.serialization.OperationalInfoDeserializer;
import org.systinet.uddi.client.v3.serialization.OperationalInfoSerializer;
import org.systinet.uddi.client.v3.util.Helper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class OperationalInfo
extends UDDIObject
implements Cloneable,
Serializable {
    protected Date created;
    protected Date modified;
    protected Date modifiedIncludingChildren;
    protected String nodeID;
    protected String authorizedName;
    protected String entityKey;

    public OperationalInfo() {
    }

    public OperationalInfo(String entityKey) throws InvalidParameterException {
        this.setEntityKey(entityKey);
    }

    public OperationalInfo(String entityKey, Date created, Date modified, Date modifiedIncludingChildren, String nodeID, String authorizedName) throws InvalidParameterException {
        this.setEntityKey(entityKey);
        this.setCreated(created);
        this.setModified(modified);
        this.setModifiedIncludingChildren(modifiedIncludingChildren);
        this.setNodeID(nodeID);
        this.setAuthorizedName(authorizedName);
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        if (created != null) {
            // empty if block
        }
        this.created = created;
    }

    public Date getModified() {
        return this.modified;
    }

    public void setModified(Date modified) {
        if (modified != null) {
            // empty if block
        }
        this.modified = modified;
    }

    public Date getModifiedIncludingChildren() {
        return this.modifiedIncludingChildren;
    }

    public void setModifiedIncludingChildren(Date modifiedIncludingChildren) {
        if (modifiedIncludingChildren != null) {
            // empty if block
        }
        this.modifiedIncludingChildren = modifiedIncludingChildren;
    }

    public String getNodeID() {
        return this.nodeID;
    }

    public void setNodeID(String nodeID) throws InvalidParameterException {
        if (nodeID != null && (nodeID = StringHelper.whitespaceCollapse(nodeID)).length() > 255) {
            throw new InvalidParameterException(InvalidParameterErrorCodes.E_NAME_TOO_LONG, ResourceBundle.getString("EXC_ValueTooLong_P1", new Object[]{"255"}));
        }
        this.nodeID = nodeID;
    }

    public String getAuthorizedName() {
        return this.authorizedName;
    }

    public void setAuthorizedName(String authorizedName) throws InvalidParameterException {
        if (authorizedName != null && authorizedName.length() > 255) {
            throw new InvalidParameterException(InvalidParameterErrorCodes.E_NAME_TOO_LONG, ResourceBundle.getString("EXC_ValueTooLong_P1", new Object[]{"255"}));
        }
        this.authorizedName = authorizedName;
    }

    public String getEntityKey() {
        return this.entityKey;
    }

    public void setEntityKey(String entityKey) throws InvalidParameterException {
        if (entityKey == null) {
            throw new InvalidParameterException(InvalidParameterErrorCodes.E_MISSING_REQUIRED_ELEMENT, ResourceBundle.getString("EXC_IsNull_P1", "OperationalInfo.entityKey"));
        }
        if (entityKey != null) {
            if ((entityKey = StringHelper.whitespaceCollapse(entityKey)).length() > 255) {
                throw new InvalidParameterException(InvalidParameterErrorCodes.E_NAME_TOO_LONG, ResourceBundle.getString("EXC_ValueTooLong_P1", new Object[]{"255"}));
            }
            if (entityKey.length() == 0) {
                throw new InvalidParameterException(InvalidParameterErrorCodes.E_NAME_TOO_SHORT, ResourceBundle.getString("EXC_ValueTooShort_P1", new Object[]{"1"}));
            }
        }
        this.entityKey = entityKey;
    }

    public String toXML() {
        return Helper.serialize(this, "urn:uddi-org:api_v3", "operationalInfo", OperationalInfoSerializer.getInstance());
    }

    public void toXML(StringBuffer stringBuffer) {
        Helper.serialize((Object)this, "urn:uddi-org:api_v3", "operationalInfo", (Serializer)OperationalInfoSerializer.getInstance(), stringBuffer);
    }

    public Element toXML(Document document) {
        return Helper.serialize((Object)this, "urn:uddi-org:api_v3", "operationalInfo", (Serializer)OperationalInfoSerializer.getInstance(), document);
    }

    public void toXML(Writer writer) {
        Helper.serialize((Object)this, "urn:uddi-org:api_v3", "operationalInfo", (Serializer)OperationalInfoSerializer.getInstance(), writer);
    }

    public void toXML(TokenWriter tokenWriter) {
        Helper.serialize((Object)this, "urn:uddi-org:api_v3", "operationalInfo", (Serializer)OperationalInfoSerializer.getInstance(), tokenWriter);
    }

    public void toXML(TokenWriter tokenWriter, Map mapping) {
        Helper.serialize(this, "urn:uddi-org:api_v3", "operationalInfo", OperationalInfoSerializer.getInstance(), tokenWriter, mapping);
    }

    public static OperationalInfo fromXML(String string) throws InvalidParameterException, WrappedException {
        return (OperationalInfo)Helper.deserialize("urn:uddi-org:api_v3", "operationalInfo", (Deserializer)OperationalInfoDeserializer.getInstance(), string);
    }

    public static OperationalInfo fromXML(Element element) throws InvalidParameterException, WrappedException {
        return (OperationalInfo)Helper.deserialize("urn:uddi-org:api_v3", "operationalInfo", (Deserializer)OperationalInfoDeserializer.getInstance(), element);
    }

    public static OperationalInfo fromXML(Reader reader) throws InvalidParameterException, WrappedException {
        return (OperationalInfo)Helper.deserialize("urn:uddi-org:api_v3", "operationalInfo", (Deserializer)OperationalInfoDeserializer.getInstance(), reader);
    }

    public static OperationalInfo fromXML(Tokenizer tokenizer) throws InvalidParameterException, WrappedException {
        return (OperationalInfo)Helper.deserialize("urn:uddi-org:api_v3", "operationalInfo", (Deserializer)OperationalInfoDeserializer.getInstance(), tokenizer);
    }

    public static OperationalInfo fromXML(Tokenizer tokenizer, Map mapping) throws InvalidParameterException, WrappedException {
        return (OperationalInfo)Helper.deserialize("urn:uddi-org:api_v3", "operationalInfo", OperationalInfoDeserializer.getInstance(), tokenizer, mapping);
    }

    public void check() throws InvalidParameterException {
        super.check();
        if (this.entityKey == null) {
            throw new InvalidParameterException(InvalidParameterErrorCodes.E_MISSING_REQUIRED_ELEMENT, ResourceBundle.getString("EXC_IsNull_P1", "OperationalInfo.entityKey"));
        }
    }

    public boolean normalize() {
        boolean result = true;
        if (this.created != null) {
            result = false;
        }
        if (this.modified != null) {
            result = false;
        }
        if (this.modifiedIncludingChildren != null) {
            result = false;
        }
        if (this.nodeID != null) {
            result = false;
        }
        if (this.authorizedName != null) {
            result = false;
        }
        if (this.entityKey != null) {
            result = false;
        }
        return result;
    }

    public Object clone() throws CloneNotSupportedException {
        OperationalInfo theClone = (OperationalInfo)super.clone();
        if (this.created != null) {
            theClone.created = new Date(this.created.getTime());
        }
        if (this.modified != null) {
            theClone.modified = new Date(this.modified.getTime());
        }
        if (this.modifiedIncludingChildren != null) {
            theClone.modifiedIncludingChildren = new Date(this.modifiedIncludingChildren.getTime());
        }
        return theClone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OperationalInfo)) {
            return false;
        }
        OperationalInfo org_systinet_uddi_client_v3_struct_OperationalInfo = (OperationalInfo)o;
        boolean bl = this.created != null ? !this.created.equals(org_systinet_uddi_client_v3_struct_OperationalInfo.created) : org_systinet_uddi_client_v3_struct_OperationalInfo.created != null;
        if (bl) {
            return false;
        }
        boolean bl2 = this.modified != null ? !this.modified.equals(org_systinet_uddi_client_v3_struct_OperationalInfo.modified) : org_systinet_uddi_client_v3_struct_OperationalInfo.modified != null;
        if (bl2) {
            return false;
        }
        boolean bl3 = this.modifiedIncludingChildren != null ? !this.modifiedIncludingChildren.equals(org_systinet_uddi_client_v3_struct_OperationalInfo.modifiedIncludingChildren) : org_systinet_uddi_client_v3_struct_OperationalInfo.modifiedIncludingChildren != null;
        if (bl3) {
            return false;
        }
        boolean bl4 = this.nodeID != null ? !this.nodeID.equals(org_systinet_uddi_client_v3_struct_OperationalInfo.nodeID) : org_systinet_uddi_client_v3_struct_OperationalInfo.nodeID != null;
        if (bl4) {
            return false;
        }
        boolean bl5 = this.authorizedName != null ? !this.authorizedName.equals(org_systinet_uddi_client_v3_struct_OperationalInfo.authorizedName) : org_systinet_uddi_client_v3_struct_OperationalInfo.authorizedName != null;
        if (bl5) {
            return false;
        }
        return !(this.entityKey != null ? !this.entityKey.equals(org_systinet_uddi_client_v3_struct_OperationalInfo.entityKey) : org_systinet_uddi_client_v3_struct_OperationalInfo.entityKey != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + (this.created != null ? this.created.hashCode() : 0);
        result = 29 * result + (this.modified != null ? this.modified.hashCode() : 0);
        result = 29 * result + (this.modifiedIncludingChildren != null ? this.modifiedIncludingChildren.hashCode() : 0);
        result = 29 * result + (this.nodeID != null ? this.nodeID.hashCode() : 0);
        result = 29 * result + (this.authorizedName != null ? this.authorizedName.hashCode() : 0);
        result = 29 * result + (this.entityKey != null ? this.entityKey.hashCode() : 0);
        return result;
    }
}

