/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.uddi.client.v3.struct;

import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.Map;
import org.idoox.util.WrappedException;
import org.idoox.xml.TokenWriter;
import org.idoox.xml.Tokenizer;
import org.systinet.uddi.InvalidParameterErrorCodes;
import org.systinet.uddi.InvalidParameterException;
import org.systinet.uddi.ResourceBundle;
import org.systinet.uddi.client.base.UDDIObject;
import org.systinet.uddi.client.serialization.Deserializer;
import org.systinet.uddi.client.serialization.Serializer;
import org.systinet.uddi.client.util.StringHelper;
import org.systinet.uddi.client.v3.serialization.NameDeserializer;
import org.systinet.uddi.client.v3.serialization.NameSerializer;
import org.systinet.uddi.client.v3.util.Helper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Name
extends UDDIObject
implements Cloneable,
Serializable {
    private String lang;
    private String value;

    public Name() {
    }

    public Name(String value) throws InvalidParameterException {
        this.setValue(value);
    }

    public Name(String value, String lang) throws InvalidParameterException {
        this.setValue(value);
        this.setLang(lang);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) throws InvalidParameterException {
        if (value != null) {
            if ((value = StringHelper.whitespaceCollapse(value)).length() < 1) {
                throw new InvalidParameterException(InvalidParameterErrorCodes.E_NAME_TOO_SHORT, ResourceBundle.getString("EXC_ValueTooShort_P1", new Object[]{"1"}));
            }
            if (value.length() > 255) {
                throw new InvalidParameterException(InvalidParameterErrorCodes.E_NAME_TOO_LONG, ResourceBundle.getString("EXC_ValueTooLong_P1", new Object[]{"255"}));
            }
        }
        this.value = value;
    }

    public String getLang() {
        return this.lang;
    }

    public void setLang(String lang) {
        if (lang != null) {
            // empty if block
        }
        this.lang = lang;
    }

    public String toXML() {
        return Helper.serialize(this, "urn:uddi-org:api_v3", "name", NameSerializer.getInstance());
    }

    public void toXML(StringBuffer stringBuffer) {
        Helper.serialize((Object)this, "urn:uddi-org:api_v3", "name", (Serializer)NameSerializer.getInstance(), stringBuffer);
    }

    public Element toXML(Document document) {
        return Helper.serialize((Object)this, "urn:uddi-org:api_v3", "name", (Serializer)NameSerializer.getInstance(), document);
    }

    public void toXML(Writer writer) {
        Helper.serialize((Object)this, "urn:uddi-org:api_v3", "name", (Serializer)NameSerializer.getInstance(), writer);
    }

    public void toXML(TokenWriter tokenWriter) {
        Helper.serialize((Object)this, "urn:uddi-org:api_v3", "name", (Serializer)NameSerializer.getInstance(), tokenWriter);
    }

    public void toXML(TokenWriter tokenWriter, Map mapping) {
        Helper.serialize(this, "urn:uddi-org:api_v3", "name", NameSerializer.getInstance(), tokenWriter, mapping);
    }

    public static Name fromXML(String string) throws InvalidParameterException, WrappedException {
        return (Name)Helper.deserialize("urn:uddi-org:api_v3", "name", (Deserializer)NameDeserializer.getInstance(), string);
    }

    public static Name fromXML(Element element) throws InvalidParameterException, WrappedException {
        return (Name)Helper.deserialize("urn:uddi-org:api_v3", "name", (Deserializer)NameDeserializer.getInstance(), element);
    }

    public static Name fromXML(Reader reader) throws InvalidParameterException, WrappedException {
        return (Name)Helper.deserialize("urn:uddi-org:api_v3", "name", (Deserializer)NameDeserializer.getInstance(), reader);
    }

    public static Name fromXML(Tokenizer tokenizer) throws InvalidParameterException, WrappedException {
        return (Name)Helper.deserialize("urn:uddi-org:api_v3", "name", (Deserializer)NameDeserializer.getInstance(), tokenizer);
    }

    public static Name fromXML(Tokenizer tokenizer, Map mapping) throws InvalidParameterException, WrappedException {
        return (Name)Helper.deserialize("urn:uddi-org:api_v3", "name", NameDeserializer.getInstance(), tokenizer, mapping);
    }

    public void check() throws InvalidParameterException {
        super.check();
        if (this.value == null) {
            throw new InvalidParameterException(InvalidParameterErrorCodes.E_MISSING_REQUIRED_ELEMENT, ResourceBundle.getString("EXC_IsNull_P1", "Name.value"));
        }
    }

    public boolean normalize() {
        boolean result = true;
        if (this.value != null) {
            result = false;
        }
        if (this.lang != null) {
            result = false;
        }
        return result;
    }

    public Object clone() throws CloneNotSupportedException {
        Name theClone = (Name)super.clone();
        return theClone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Name)) {
            return false;
        }
        Name org_systinet_uddi_client_v3_struct_Name = (Name)o;
        boolean bl = this.value != null ? !this.value.equals(org_systinet_uddi_client_v3_struct_Name.value) : org_systinet_uddi_client_v3_struct_Name.value != null;
        if (bl) {
            return false;
        }
        return !(this.lang != null ? !this.lang.equals(org_systinet_uddi_client_v3_struct_Name.lang) : org_systinet_uddi_client_v3_struct_Name.lang != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 29 * result + (this.lang != null ? this.lang.hashCode() : 0);
        return result;
    }
}

