/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.uddi.client.v3.struct;

import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.Map;
import org.idoox.util.WrappedException;
import org.idoox.xml.TokenWriter;
import org.idoox.xml.Tokenizer;
import org.systinet.uddi.InvalidParameterErrorCodes;
import org.systinet.uddi.InvalidParameterException;
import org.systinet.uddi.ResourceBundle;
import org.systinet.uddi.client.base.StringArrayList;
import org.systinet.uddi.client.base.StringArrayListIterator;
import org.systinet.uddi.client.base.UDDIObject;
import org.systinet.uddi.client.serialization.Deserializer;
import org.systinet.uddi.client.serialization.Serializer;
import org.systinet.uddi.client.util.StringHelper;
import org.systinet.uddi.client.v3.serialization.Get_operationalInfoDeserializer;
import org.systinet.uddi.client.v3.serialization.Get_operationalInfoSerializer;
import org.systinet.uddi.client.v3.util.Helper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Get_operationalInfo
extends UDDIObject
implements Cloneable,
Serializable {
    protected String authInfo;
    protected StringArrayList entityKeyArrayList;

    public Get_operationalInfo() {
    }

    public Get_operationalInfo(StringArrayList entityKeyArrayList) throws InvalidParameterException {
        this.setEntityKeyArrayList(entityKeyArrayList);
    }

    public Get_operationalInfo(StringArrayList entityKeyArrayList, String authInfo) throws InvalidParameterException {
        this.setEntityKeyArrayList(entityKeyArrayList);
        this.setAuthInfo(authInfo);
    }

    public String getAuthInfo() {
        return this.authInfo;
    }

    public void setAuthInfo(String authInfo) {
        if (authInfo != null) {
            // empty if block
        }
        this.authInfo = authInfo;
    }

    public void addEntityKey(String item) throws InvalidParameterException {
        if (item == null) {
            throw new InvalidParameterException(InvalidParameterErrorCodes.E_MISSING_REQUIRED_ELEMENT, ResourceBundle.getString("EXC_IsNull_P1", "entityKeyArrayList.item"));
        }
        if ((item = StringHelper.whitespaceCollapse(item)).length() > 255) {
            throw new InvalidParameterException(InvalidParameterErrorCodes.E_NAME_TOO_LONG, ResourceBundle.getString("EXC_ValueTooLong_P1", new Object[]{"255"}));
        }
        if (item.length() == 0) {
            throw new InvalidParameterException(InvalidParameterErrorCodes.E_NAME_TOO_SHORT, ResourceBundle.getString("EXC_ValueTooShort_P1", new Object[]{"1"}));
        }
        if (this.entityKeyArrayList == null) {
            this.entityKeyArrayList = new StringArrayList();
        }
        this.entityKeyArrayList.add(item);
    }

    public StringArrayList getEntityKeyArrayList() {
        return this.entityKeyArrayList;
    }

    public void setEntityKeyArrayList(StringArrayList entityKeyArrayList) throws InvalidParameterException {
        if (entityKeyArrayList == null) {
            throw new InvalidParameterException(InvalidParameterErrorCodes.E_MISSING_REQUIRED_ELEMENT, ResourceBundle.getString("EXC_IsNull_P1", "entityKeyArrayList"));
        }
        if (entityKeyArrayList != null) {
            StringArrayListIterator iterator = entityKeyArrayList.stringArrayListIterator();
            while (iterator.hasNext()) {
                String item = iterator.next();
                if ((item = StringHelper.whitespaceCollapse(item)).length() > 255) {
                    throw new InvalidParameterException(InvalidParameterErrorCodes.E_NAME_TOO_LONG, ResourceBundle.getString("EXC_ValueTooLong_P1", new Object[]{"255"}));
                }
                if (item.length() != 0) continue;
                throw new InvalidParameterException(InvalidParameterErrorCodes.E_NAME_TOO_SHORT, ResourceBundle.getString("EXC_ValueTooShort_P1", new Object[]{"1"}));
            }
        }
        this.entityKeyArrayList = entityKeyArrayList;
    }

    public String toXML() {
        return Helper.serialize(this, "urn:uddi-org:api_v3", "get_operationalInfo", Get_operationalInfoSerializer.getInstance());
    }

    public void toXML(StringBuffer stringBuffer) {
        Helper.serialize((Object)this, "urn:uddi-org:api_v3", "get_operationalInfo", (Serializer)Get_operationalInfoSerializer.getInstance(), stringBuffer);
    }

    public Element toXML(Document document) {
        return Helper.serialize((Object)this, "urn:uddi-org:api_v3", "get_operationalInfo", (Serializer)Get_operationalInfoSerializer.getInstance(), document);
    }

    public void toXML(Writer writer) {
        Helper.serialize((Object)this, "urn:uddi-org:api_v3", "get_operationalInfo", (Serializer)Get_operationalInfoSerializer.getInstance(), writer);
    }

    public void toXML(TokenWriter tokenWriter) {
        Helper.serialize((Object)this, "urn:uddi-org:api_v3", "get_operationalInfo", (Serializer)Get_operationalInfoSerializer.getInstance(), tokenWriter);
    }

    public void toXML(TokenWriter tokenWriter, Map mapping) {
        Helper.serialize(this, "urn:uddi-org:api_v3", "get_operationalInfo", Get_operationalInfoSerializer.getInstance(), tokenWriter, mapping);
    }

    public static Get_operationalInfo fromXML(String string) throws InvalidParameterException, WrappedException {
        return (Get_operationalInfo)Helper.deserialize("urn:uddi-org:api_v3", "get_operationalInfo", (Deserializer)Get_operationalInfoDeserializer.getInstance(), string);
    }

    public static Get_operationalInfo fromXML(Element element) throws InvalidParameterException, WrappedException {
        return (Get_operationalInfo)Helper.deserialize("urn:uddi-org:api_v3", "get_operationalInfo", (Deserializer)Get_operationalInfoDeserializer.getInstance(), element);
    }

    public static Get_operationalInfo fromXML(Reader reader) throws InvalidParameterException, WrappedException {
        return (Get_operationalInfo)Helper.deserialize("urn:uddi-org:api_v3", "get_operationalInfo", (Deserializer)Get_operationalInfoDeserializer.getInstance(), reader);
    }

    public static Get_operationalInfo fromXML(Tokenizer tokenizer) throws InvalidParameterException, WrappedException {
        return (Get_operationalInfo)Helper.deserialize("urn:uddi-org:api_v3", "get_operationalInfo", (Deserializer)Get_operationalInfoDeserializer.getInstance(), tokenizer);
    }

    public static Get_operationalInfo fromXML(Tokenizer tokenizer, Map mapping) throws InvalidParameterException, WrappedException {
        return (Get_operationalInfo)Helper.deserialize("urn:uddi-org:api_v3", "get_operationalInfo", Get_operationalInfoDeserializer.getInstance(), tokenizer, mapping);
    }

    public void check() throws InvalidParameterException {
        super.check();
        if (this.entityKeyArrayList == null || this.entityKeyArrayList.size() < 1) {
            throw new InvalidParameterException(InvalidParameterErrorCodes.E_MISSING_REQUIRED_ELEMENT, ResourceBundle.getString("EXC_IsNull_P1", "Get_operationalInfo.entityKeyArrayList"));
        }
    }

    public boolean normalize() {
        boolean result = true;
        if (this.authInfo != null) {
            result = false;
        }
        if (this.entityKeyArrayList != null) {
            if (this.entityKeyArrayList.normalize()) {
                this.entityKeyArrayList = null;
            } else {
                result = false;
            }
        }
        return result;
    }

    public Object clone() throws CloneNotSupportedException {
        Get_operationalInfo theClone = (Get_operationalInfo)super.clone();
        if (this.entityKeyArrayList != null) {
            theClone.entityKeyArrayList = (StringArrayList)this.entityKeyArrayList.clone();
        }
        return theClone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Get_operationalInfo)) {
            return false;
        }
        Get_operationalInfo org_systinet_uddi_client_v3_struct_Get_operationalInfo = (Get_operationalInfo)o;
        boolean bl = this.authInfo != null ? !this.authInfo.equals(org_systinet_uddi_client_v3_struct_Get_operationalInfo.authInfo) : org_systinet_uddi_client_v3_struct_Get_operationalInfo.authInfo != null;
        if (bl) {
            return false;
        }
        return !(this.entityKeyArrayList != null ? !this.entityKeyArrayList.equals(org_systinet_uddi_client_v3_struct_Get_operationalInfo.entityKeyArrayList) : org_systinet_uddi_client_v3_struct_Get_operationalInfo.entityKeyArrayList != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + (this.authInfo != null ? this.authInfo.hashCode() : 0);
        result = 29 * result + (this.entityKeyArrayList != null ? this.entityKeyArrayList.hashCode() : 0);
        return result;
    }
}

